/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.paimon;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class PaimonPropertiesUtils {
    public static final Map<String, String> GRAVITINO_CONFIG_TO_PAIMON;
    public static final Map<String, String> PAIMON_CATALOG_CONFIG_TO_GRAVITINO;

    public static Map<String, String> toPaimonCatalogProperties(Map<String, String> gravitinoProperties) {
        HashMap<String, String> paimonProperties = new HashMap<String, String>();
        gravitinoProperties.forEach((key, value) -> {
            if (GRAVITINO_CONFIG_TO_PAIMON.containsKey(key)) {
                paimonProperties.put(GRAVITINO_CONFIG_TO_PAIMON.get(key), (String)value);
            }
        });
        return paimonProperties;
    }

    public static String getCatalogBackendName(Map<String, String> catalogProperties) {
        String backendName = catalogProperties.get("catalog-backend-name");
        if (backendName != null) {
            return backendName;
        }
        String catalogBackend = catalogProperties.get("catalog-backend");
        return Optional.ofNullable(catalogBackend).map(s -> s.toLowerCase(Locale.ROOT)).orElseThrow(() -> new UnsupportedOperationException(String.format("Unsupported catalog backend: %s", catalogBackend)));
    }

    static {
        HashMap<String, String> gravitinoConfigToPaimon = new HashMap<String, String>();
        HashMap paimonCatalogConfigToGravitino = new HashMap();
        gravitinoConfigToPaimon.put("catalog-backend", "catalog-backend");
        gravitinoConfigToPaimon.put("jdbc-driver", "jdbc-driver");
        gravitinoConfigToPaimon.put("jdbc-user", "jdbc.user");
        gravitinoConfigToPaimon.put("jdbc-password", "jdbc.password");
        gravitinoConfigToPaimon.put("uri", "uri");
        gravitinoConfigToPaimon.put("warehouse", "warehouse");
        gravitinoConfigToPaimon.put("catalog-backend-name", "catalog-backend-name");
        gravitinoConfigToPaimon.put("s3-endpoint", "s3.endpoint");
        gravitinoConfigToPaimon.put("s3-access-key-id", "s3.access-key");
        gravitinoConfigToPaimon.put("s3-secret-access-key", "s3.secret-key");
        gravitinoConfigToPaimon.put("oss-endpoint", "fs.oss.endpoint");
        gravitinoConfigToPaimon.put("oss-access-key-id", "fs.oss.accessKeyId");
        gravitinoConfigToPaimon.put("oss-secret-access-key", "fs.oss.accessKeySecret");
        GRAVITINO_CONFIG_TO_PAIMON = Collections.unmodifiableMap(gravitinoConfigToPaimon);
        gravitinoConfigToPaimon.forEach((key, value) -> paimonCatalogConfigToGravitino.put(value, key));
        PAIMON_CATALOG_CONFIG_TO_GRAVITINO = Collections.unmodifiableMap(paimonCatalogConfigToGravitino);
    }
}

