/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.nustaq.offheap.bytez.malloc;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.shaded.org.nustaq.offheap.bytez.Bytez;
import org.apache.hadoop.shaded.org.nustaq.offheap.bytez.BytezAllocator;
import org.apache.hadoop.shaded.org.nustaq.offheap.bytez.malloc.MallocBytez;

public class MallocBytezAllocator
implements BytezAllocator {
    public static AtomicLong alloced = new AtomicLong(0L);
    ArrayList<MallocBytez> allocated = new ArrayList();

    @Override
    public Bytez alloc(long len) {
        MallocBytez mallocBytez = new MallocBytez(MallocBytez.unsafe.allocateMemory(len), len);
        mallocBytez.clear();
        this.allocated.add(mallocBytez);
        alloced.getAndAdd(len);
        return mallocBytez;
    }

    @Override
    public void free(Bytez bytes) {
        if (bytes instanceof MallocBytez && this.allocated.contains(bytes)) {
            this.allocated.remove(bytes);
            alloced.getAndAdd(-bytes.length());
            ((MallocBytez)bytes).free();
        }
    }

    @Override
    public void freeAll() {
        for (int i = 0; i < this.allocated.size(); ++i) {
            MallocBytez mallocBytez = this.allocated.get(i);
            mallocBytez.free();
        }
        this.allocated.clear();
    }
}

