/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.keyvalue;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.type.keyvalue.KeyValue;

public final class LongToDouble
implements KeyValue<Long, Double> {
    public final long key;
    public final double value;

    public LongToDouble(long aKey) {
        this.key = aKey;
        this.value = Double.NaN;
    }

    public LongToDouble(long aKey, double aValue) {
        this.key = aKey;
        this.value = aValue;
    }

    public LongToDouble(long aKey, Double aValue) {
        this.key = aKey;
        this.value = aValue != null ? aValue : PrimitiveMath.ZERO;
    }

    public LongToDouble(Long aKey, double aValue) {
        this.key = aKey != null ? aKey : 0L;
        this.value = aValue;
    }

    public LongToDouble(Long aKey, Double aValue) {
        this.key = aKey != null ? aKey : 0L;
        this.value = aValue != null ? aValue : PrimitiveMath.ZERO;
    }

    LongToDouble() {
        this(0L, PrimitiveMath.ZERO);
    }

    @Override
    public int compareTo(KeyValue<Long, ?> aReference) {
        return this.key < aReference.getKey() ? -1 : (this.key == aReference.getKey() ? 0 : 1);
    }

    @Override
    public int compareTo(LongToDouble aReference) {
        return this.key < aReference.key ? -1 : (this.key == aReference.key ? 0 : 1);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LongToDouble)) {
            return false;
        }
        LongToDouble other = (LongToDouble)obj;
        return this.key == other.key;
    }

    @Override
    public Long getKey() {
        return this.key;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.key ^ this.key >>> 32);
        return result;
    }

    public String toString() {
        return String.valueOf(this.key) + String.valueOf('=') + String.valueOf(this.value);
    }
}

