/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.HBCK2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionsOnUnknownServersRecoverer
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(RegionsOnUnknownServersRecoverer.class.getName());
    private static final String CATALOG_JANITOR = "CatalogJanitor: hole=";
    private static final String UNKNOWN_SERVER = "unknown_server=";
    private Configuration conf;
    private Set<String> unknownServers = new HashSet<String>();
    private boolean dryRun = false;

    public RegionsOnUnknownServersRecoverer(Configuration conf) {
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        String logPath = null;
        if (args.length >= 1 && args.length < 3) {
            logPath = args[0];
            if (args.length == 2) {
                this.dryRun = args[1].equals("dryRun");
            }
        } else {
            LOG.error("Wrong number of arguments. Arguments are: <PATH_TO_MASTER_LOGS> [dryRun]");
            return 1;
        }
        try (BufferedReader reader = null;
             Connection conn = ConnectionFactory.createConnection((Configuration)this.conf);){
            reader = new BufferedReader(new FileReader(new File(logPath)));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (!line.contains(CATALOG_JANITOR)) continue;
                String[] servers = line.split(UNKNOWN_SERVER);
                for (int i = 1; i < servers.length; ++i) {
                    String server = servers[i].split("/")[0];
                    if (this.unknownServers.contains(server)) continue;
                    LOG.info("Adding server {} to our list of servers that will have SCPs.", (Object)server);
                    this.unknownServers.add(server);
                }
            }
            if (this.dryRun) {
                StringBuilder builder = new StringBuilder("This is a dry run, no SCPs will be submitted. Found unknown servers:");
                builder.append("\n");
                this.unknownServers.stream().forEach(s -> builder.append((String)s).append("\n"));
                LOG.info(builder.toString());
            } else {
                HBCK2 hbck2 = new HBCK2(this.conf);
                LOG.info("Submitting SCPs for the found unknown servers with HBCK2 scheduleRecoveries option.");
                hbck2.scheduleRecoveries(conn.getHbck(), this.unknownServers.toArray(new String[0]));
            }
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int errCode = ToolRunner.run((Tool)new RegionsOnUnknownServersRecoverer(conf), (String[])args);
        if (errCode != 0) {
            System.exit(errCode);
        }
    }
}

