/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.hbck1;

import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.ipc.RemoteWithExtrasException;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hbase.HBCKMetaTableAccessor;
import org.apache.hbase.HBCKRegionServerAdmin;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HBaseFsckRepair {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseFsckRepair.class);

    private HBaseFsckRepair() {
    }

    public static void fixMultiAssignment(Connection connection, RegionInfo region, List<ServerName> servers) throws IOException, KeeperException, InterruptedException {
        for (ServerName server : servers) {
            HBaseFsckRepair.closeRegionSilentlyAndWait(connection, server, region);
        }
        HBaseFsckRepair.forceOfflineInZK(connection.getAdmin(), region);
    }

    public static void fixUnassigned(Admin admin, RegionInfo region) throws IOException, KeeperException, InterruptedException {
        HBaseFsckRepair.forceOfflineInZK(admin, region);
    }

    private static void forceOfflineInZK(Admin admin, RegionInfo region) throws ZooKeeperConnectionException, KeeperException, IOException, InterruptedException {
        admin.assign(region.getRegionName());
    }

    public static void waitUntilAssigned(Admin admin, RegionInfo region) throws IOException, InterruptedException {
        long timeout = admin.getConfiguration().getLong("hbase.hbck.assign.timeout", 120000L);
        long expiration = timeout + System.currentTimeMillis();
        while (System.currentTimeMillis() < expiration) {
            try {
                boolean inTransition = false;
                for (RegionState rs : admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.REGIONS_IN_TRANSITION)).getRegionStatesInTransition()) {
                    if (RegionInfo.COMPARATOR.compare(rs.getRegion(), region) != 0) continue;
                    inTransition = true;
                    break;
                }
                if (!inTransition) {
                    return;
                }
                LOG.info("Region still in transition, waiting for it to become assigned: " + region);
            }
            catch (IOException e) {
                LOG.warn("Exception when waiting for region to become assigned, retrying", e);
            }
            Thread.sleep(1000L);
        }
        throw new IOException("Region " + region + " failed to move out of transition within timeout " + timeout + "ms");
    }

    public static void closeRegionSilentlyAndWait(Connection connection, ServerName server, RegionInfo region) throws IOException, InterruptedException {
        long timeout = connection.getConfiguration().getLong("hbase.hbck.close.timeout", 120000L);
        HBCKRegionServerAdmin admin = new HBCKRegionServerAdmin(connection, server);
        admin.closeRegion(region.getRegionName());
        if (timeout < 0L) {
            return;
        }
        long expiration = timeout + System.currentTimeMillis();
        while (System.currentTimeMillis() < expiration) {
            try {
                RegionInfo rsRegion = admin.getRegionInfo(region.getRegionName());
                if (rsRegion == null) {
                    return;
                }
            }
            catch (IOException ioe) {
                if (ioe instanceof NotServingRegionException || ioe instanceof RemoteWithExtrasException && ((RemoteWithExtrasException)ioe).unwrapRemoteException() instanceof NotServingRegionException) {
                    return;
                }
                LOG.warn("Exception when retrieving regioninfo from: {}", (Object)region.getRegionNameAsString(), (Object)ioe);
            }
            Thread.sleep(1000L);
        }
        throw new IOException("Region " + region + " failed to close within timeout " + timeout);
    }

    public static void fixMetaHoleOnlineAndAddReplicas(Configuration conf, RegionInfo hri, Collection<ServerName> servers, int numReplicas) throws IOException {
        Connection conn = ConnectionFactory.createConnection((Configuration)conf);
        Table meta = conn.getTable(TableName.META_TABLE_NAME);
        Put put = HBCKMetaTableAccessor.makePutFromRegionInfo(hri, System.currentTimeMillis());
        if (numReplicas > 1) {
            Random r = new Random();
            ServerName[] serversArr = servers.toArray(new ServerName[servers.size()]);
            for (int i = 1; i < numReplicas; ++i) {
                ServerName sn = serversArr[r.nextInt(serversArr.length)];
                HBCKMetaTableAccessor.addLocation(put, sn, sn.getStartcode(), i);
            }
        }
        meta.put(put);
        meta.close();
        conn.close();
    }

    public static HRegion createHDFSRegionDir(Configuration conf, RegionInfo hri, TableDescriptor htd) throws IOException {
        Path root = CommonFSUtils.getRootDir((Configuration)conf);
        HRegion region = HRegion.createHRegion((RegionInfo)hri, (Path)root, (Configuration)conf, (TableDescriptor)htd, null);
        region.close();
        return region;
    }

    public static void removeParentInMeta(Configuration conf, RegionInfo hri) throws IOException {
        Connection conn = ConnectionFactory.createConnection((Configuration)conf);
        HBCKMetaTableAccessor.deleteRegionInfo(conn, hri);
    }
}

