/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.spectator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.helix.PropertyType;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RoutingTable {
    private static final Logger logger = LoggerFactory.getLogger(RoutingTable.class);
    private final Map<String, ResourceInfo> _resourceInfoMap;
    private final Map<String, ResourceGroupInfo> _resourceGroupInfoMap;
    private final Collection<LiveInstance> _liveInstances;
    protected final Collection<InstanceConfig> _instanceConfigs;
    private final Collection<ExternalView> _externalViews;
    private final PropertyType _propertyType;
    private static Comparator<InstanceConfig> INSTANCE_CONFIG_COMPARATOR = new Comparator<InstanceConfig>(){

        @Override
        public int compare(InstanceConfig config1, InstanceConfig config2) {
            if (config1 == config2) {
                return 0;
            }
            if (config1 == null) {
                return -1;
            }
            if (config2 == null) {
                return 1;
            }
            return config1.getId().compareTo(config2.getId());
        }
    };

    @Deprecated
    public RoutingTable() {
        this(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    protected RoutingTable(PropertyType propertyType) {
        this(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), propertyType);
    }

    public RoutingTable(Map<String, Map<String, Map<String, CurrentState>>> currentStateMap, Collection<InstanceConfig> instanceConfigs, Collection<LiveInstance> liveInstances) {
        this(Collections.emptyList(), instanceConfigs, liveInstances, PropertyType.CURRENTSTATES);
        this.refresh(currentStateMap);
    }

    public RoutingTable(Collection<ExternalView> externalViews, Collection<InstanceConfig> instanceConfigs, Collection<LiveInstance> liveInstances) {
        this(externalViews, instanceConfigs, liveInstances, PropertyType.EXTERNALVIEW);
    }

    protected RoutingTable(Collection<ExternalView> externalViews, Collection<InstanceConfig> instanceConfigs, Collection<LiveInstance> liveInstances, PropertyType propertytype) {
        this._propertyType = propertytype;
        this._resourceInfoMap = new HashMap<String, ResourceInfo>();
        this._resourceGroupInfoMap = new HashMap<String, ResourceGroupInfo>();
        this._liveInstances = new HashSet<LiveInstance>(liveInstances);
        this._instanceConfigs = new HashSet<InstanceConfig>(instanceConfigs);
        this._externalViews = new HashSet<ExternalView>(externalViews);
        this.refresh(this._externalViews);
    }

    private void refresh(Collection<ExternalView> externalViewList) {
        HashMap<String, InstanceConfig> instanceConfigMap = new HashMap<String, InstanceConfig>();
        if (externalViewList != null && !externalViewList.isEmpty()) {
            for (InstanceConfig config : this._instanceConfigs) {
                instanceConfigMap.put(config.getId(), config);
            }
            for (ExternalView extView : externalViewList) {
                String resourceName = extView.getId();
                for (String partitionName : extView.getPartitionSet()) {
                    Map<String, String> stateMap = extView.getStateMap(partitionName);
                    for (String instanceName : stateMap.keySet()) {
                        String currentState = stateMap.get(instanceName);
                        if (instanceConfigMap.containsKey(instanceName)) {
                            InstanceConfig instanceConfig = (InstanceConfig)instanceConfigMap.get(instanceName);
                            if (extView.isGroupRoutingEnabled()) {
                                this.addEntry(resourceName, extView.getResourceGroupName(), extView.getInstanceGroupTag(), partitionName, currentState, instanceConfig);
                                continue;
                            }
                            this.addEntry(resourceName, partitionName, currentState, instanceConfig);
                            continue;
                        }
                        logger.warn("Participant {} is not found with proper configuration information. It might already be removed from the cluster. Skip recording partition assignment entry: Partition {}, Participant {}, State {}.", new Object[]{instanceName, partitionName, instanceName, stateMap.get(instanceName)});
                    }
                }
            }
        }
    }

    private void refresh(Map<String, Map<String, Map<String, CurrentState>>> currentStateMap) {
        HashMap<String, InstanceConfig> instanceConfigMap = new HashMap<String, InstanceConfig>();
        if (currentStateMap != null && !currentStateMap.isEmpty()) {
            for (InstanceConfig config : this._instanceConfigs) {
                instanceConfigMap.put(config.getId(), config);
            }
            for (LiveInstance liveInstance : this._liveInstances) {
                String instanceName = liveInstance.getInstanceName();
                String sessionId = liveInstance.getEphemeralOwner();
                InstanceConfig instanceConfig = (InstanceConfig)instanceConfigMap.get(instanceName);
                if (instanceConfig == null) {
                    logger.warn("Participant {} is not found with proper configuration information. It might already be removed from the cluster. Skip recording partition assignments that are related to this instance.", (Object)instanceName);
                    continue;
                }
                Map<Object, Object> currentStates = Collections.emptyMap();
                if (currentStateMap.containsKey(instanceName) && currentStateMap.get(instanceName).containsKey(sessionId)) {
                    currentStates = currentStateMap.get(instanceName).get(sessionId);
                }
                for (CurrentState currentState : currentStates.values()) {
                    String resourceName = currentState.getResourceName();
                    Map<String, String> stateMap = currentState.getPartitionStateMap();
                    for (String partitionName : stateMap.keySet()) {
                        String state = stateMap.get(partitionName);
                        this.addEntry(resourceName, partitionName, state, instanceConfig);
                    }
                }
            }
        }
    }

    protected void addEntry(String resourceName, String partitionName, String state, InstanceConfig config) {
        if (!this._resourceInfoMap.containsKey(resourceName)) {
            this._resourceInfoMap.put(resourceName, new ResourceInfo());
        }
        ResourceInfo resourceInfo = this._resourceInfoMap.get(resourceName);
        resourceInfo.addEntry(partitionName, state, config);
    }

    private void addEntry(String resourceName, String resourceGroupName, String resourceTag, String partitionName, String state, InstanceConfig config) {
        this.addEntry(resourceName, partitionName, state, config);
        if (!this._resourceGroupInfoMap.containsKey(resourceGroupName)) {
            this._resourceGroupInfoMap.put(resourceGroupName, new ResourceGroupInfo());
        }
        ResourceGroupInfo resourceGroupInfo = this._resourceGroupInfoMap.get(resourceGroupName);
        resourceGroupInfo.addEntry(resourceTag, partitionName, state, config);
    }

    ResourceInfo get(String resourceName) {
        return this._resourceInfoMap.get(resourceName);
    }

    ResourceGroupInfo getResourceGroup(String resourceGroupName) {
        return this._resourceGroupInfoMap.get(resourceGroupName);
    }

    public Set<InstanceConfig> getInstancesForResource(String resourceName, String state) {
        Set<InstanceConfig> instanceSet = null;
        ResourceInfo resourceInfo = this.get(resourceName);
        if (resourceInfo != null) {
            instanceSet = resourceInfo.getInstances(state);
        }
        if (instanceSet == null) {
            instanceSet = Collections.emptySet();
        }
        return instanceSet;
    }

    public Set<InstanceConfig> getInstancesForResourceGroup(String resourceGroupName, String state) {
        Set<InstanceConfig> instanceSet = null;
        ResourceGroupInfo resourceGroupInfo = this.getResourceGroup(resourceGroupName);
        if (resourceGroupInfo != null) {
            instanceSet = resourceGroupInfo.getInstances(state);
        }
        if (instanceSet == null) {
            instanceSet = Collections.emptySet();
        }
        return instanceSet;
    }

    public Set<InstanceConfig> getInstancesForResourceGroup(String resourceGroupName, String state, List<String> resourceTags) {
        HashSet<InstanceConfig> instanceSet = null;
        ResourceGroupInfo resourceGroupInfo = this.getResourceGroup(resourceGroupName);
        if (resourceGroupInfo != null) {
            instanceSet = new HashSet<InstanceConfig>();
            for (String tag : resourceTags) {
                Set<InstanceConfig> instances = resourceGroupInfo.getInstances(state, tag);
                if (instances == null) continue;
                instanceSet.addAll(resourceGroupInfo.getInstances(state, tag));
            }
        }
        if (instanceSet == null) {
            return Collections.emptySet();
        }
        return instanceSet;
    }

    public List<InstanceConfig> getInstancesForResource(String resourceName, String partitionName, String state) {
        PartitionInfo keyInfo;
        List<InstanceConfig> instanceList = null;
        ResourceInfo resourceInfo = this.get(resourceName);
        if (resourceInfo != null && (keyInfo = resourceInfo.get(partitionName)) != null) {
            instanceList = keyInfo.get(state);
        }
        if (instanceList == null) {
            instanceList = Collections.emptyList();
        }
        return instanceList;
    }

    public List<InstanceConfig> getInstancesForResourceGroup(String resourceGroupName, String partitionName, String state) {
        PartitionInfo keyInfo;
        List<Object> instanceList = null;
        ResourceGroupInfo resourceGroupInfo = this.getResourceGroup(resourceGroupName);
        if (resourceGroupInfo != null && (keyInfo = resourceGroupInfo.get(partitionName)) != null) {
            instanceList = keyInfo.get(state);
        }
        if (instanceList == null) {
            instanceList = Collections.emptyList();
        }
        return Collections.unmodifiableList(instanceList);
    }

    protected Collection<LiveInstance> getLiveInstances() {
        return Collections.unmodifiableCollection(this._liveInstances);
    }

    protected Collection<InstanceConfig> getInstanceConfigs() {
        return Collections.unmodifiableCollection(this._instanceConfigs);
    }

    protected Collection<String> getResources() {
        return Collections.unmodifiableCollection(this._resourceInfoMap.keySet());
    }

    public List<InstanceConfig> getInstancesForResourceGroup(String resourceGroupName, String partitionName, String state, List<String> resourceTags) {
        ResourceGroupInfo resourceGroupInfo = this.getResourceGroup(resourceGroupName);
        ArrayList<InstanceConfig> instanceList = null;
        if (resourceGroupInfo != null) {
            instanceList = new ArrayList<InstanceConfig>();
            for (String tag : resourceTags) {
                PartitionInfo keyInfo = resourceGroupInfo.get(partitionName, tag);
                if (keyInfo == null || !keyInfo.containsState(state)) continue;
                instanceList.addAll(keyInfo.get(state));
            }
        }
        if (instanceList == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(instanceList);
    }

    protected Collection<ExternalView> getExternalViews() {
        return Collections.unmodifiableCollection(this._externalViews);
    }

    protected PropertyType getPropertyType() {
        return this._propertyType;
    }

    protected String getStateType() {
        return "HELIX_DEFAULT";
    }

    class PartitionInfo {
        Map<String, List<InstanceConfig>> stateInfoMap = new HashMap<String, List<InstanceConfig>>();

        public void addEntry(String state, InstanceConfig config) {
            if (!this.stateInfoMap.containsKey(state)) {
                this.stateInfoMap.put(state, new ArrayList());
            }
            List<InstanceConfig> list = this.stateInfoMap.get(state);
            list.add(config);
        }

        List<InstanceConfig> get(String state) {
            return this.stateInfoMap.get(state);
        }

        boolean containsState(String state) {
            return this.stateInfoMap.containsKey(state);
        }
    }

    class ResourceGroupInfo {
        ResourceInfo aggregatedResourceInfo;
        Map<String, ResourceInfo> tagToResourceMap;

        public ResourceGroupInfo() {
            this.aggregatedResourceInfo = new ResourceInfo();
            this.tagToResourceMap = new HashMap<String, ResourceInfo>();
        }

        public void addEntry(String resourceTag, String stateUnitKey, String state, InstanceConfig config) {
            this.aggregatedResourceInfo.addEntry(stateUnitKey, state, config);
            if (!this.tagToResourceMap.containsKey(resourceTag)) {
                this.tagToResourceMap.put(resourceTag, new ResourceInfo());
            }
            ResourceInfo resourceInfo = this.tagToResourceMap.get(resourceTag);
            resourceInfo.addEntry(stateUnitKey, state, config);
        }

        public Set<InstanceConfig> getInstances(String state) {
            return this.aggregatedResourceInfo.getInstances(state);
        }

        public Set<InstanceConfig> getInstances(String state, String resourceTag) {
            ResourceInfo resourceInfo = this.tagToResourceMap.get(resourceTag);
            if (resourceInfo != null) {
                return resourceInfo.getInstances(state);
            }
            return null;
        }

        PartitionInfo get(String stateUnitKey) {
            return this.aggregatedResourceInfo.get(stateUnitKey);
        }

        PartitionInfo get(String stateUnitKey, String resourceTag) {
            ResourceInfo resourceInfo = this.tagToResourceMap.get(resourceTag);
            if (resourceInfo == null) {
                return null;
            }
            return resourceInfo.get(stateUnitKey);
        }
    }

    class ResourceInfo {
        Map<String, PartitionInfo> partitionInfoMap = new HashMap<String, PartitionInfo>();
        Map<String, Set<InstanceConfig>> stateInfoMap = new HashMap<String, Set<InstanceConfig>>();

        public void addEntry(String stateUnitKey, String state, InstanceConfig config) {
            if (!this.stateInfoMap.containsKey(state)) {
                this.stateInfoMap.put(state, new TreeSet(INSTANCE_CONFIG_COMPARATOR));
            }
            Set<InstanceConfig> set = this.stateInfoMap.get(state);
            set.add(config);
            if (!this.partitionInfoMap.containsKey(stateUnitKey)) {
                this.partitionInfoMap.put(stateUnitKey, new PartitionInfo());
            }
            PartitionInfo stateUnitKeyInfo = this.partitionInfoMap.get(stateUnitKey);
            stateUnitKeyInfo.addEntry(state, config);
        }

        public Set<InstanceConfig> getInstances(String state) {
            return this.stateInfoMap.get(state);
        }

        PartitionInfo get(String stateUnitKey) {
            return this.partitionInfoMap.get(stateUnitKey);
        }
    }
}

