/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.api.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.helix.PropertyType;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ViewClusterSourceConfig {
    private static final List<PropertyType> _validPropertyTypes = Collections.unmodifiableList(Arrays.asList(PropertyType.INSTANCES, PropertyType.EXTERNALVIEW, PropertyType.LIVEINSTANCES));
    private static final ObjectMapper _objectMapper = new ObjectMapper();
    private final String _name;
    private final String _zkAddress;
    private List<PropertyType> _properties;

    @JsonCreator
    public ViewClusterSourceConfig(@JsonProperty(value="name") String name, @JsonProperty(value="zkAddress") String zkAddress, @JsonProperty(value="properties") List<PropertyType> properties) {
        this._name = name;
        this._zkAddress = zkAddress;
        this._properties = properties;
    }

    public ViewClusterSourceConfig(ViewClusterSourceConfig config) {
        this(config.getName(), config.getZkAddress(), new ArrayList<PropertyType>(config.getProperties()));
    }

    public void setProperties(List<PropertyType> properties) {
        for (PropertyType p : properties) {
            if (_validPropertyTypes.contains((Object)p)) continue;
            throw new IllegalArgumentException(String.format("Property %s is not support in ViewCluster yet.", new Object[]{p}));
        }
        this._properties = properties;
    }

    public String getName() {
        return this._name;
    }

    public String getZkAddress() {
        return this._zkAddress;
    }

    public List<PropertyType> getProperties() {
        return this._properties;
    }

    @JsonIgnore
    public static List<PropertyType> getValidPropertyTypes() {
        return _validPropertyTypes;
    }

    public String toJson() throws IOException {
        return _objectMapper.writeValueAsString((Object)this);
    }

    public String toString() {
        return String.format("name=%s; zkAddr=%s; properties=%s", this._name, this._zkAddress, this._properties);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof ViewClusterSourceConfig)) {
            return false;
        }
        ViewClusterSourceConfig otherConfig = (ViewClusterSourceConfig)other;
        return this._name.equals(otherConfig.getName()) && this._zkAddress.equals(otherConfig.getZkAddress()) && this._properties.containsAll(otherConfig.getProperties()) && otherConfig.getProperties().containsAll(this._properties);
    }

    public static ViewClusterSourceConfig fromJson(String jsonString) {
        try {
            return (ViewClusterSourceConfig)_objectMapper.readValue(jsonString, ViewClusterSourceConfig.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Invalid Json: %s, Exception: %s", jsonString, e.toString()));
        }
    }
}

