/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.nio.channels.spi.SelectorProvider;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ProcessorSelector;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.nio.NIOChannelDistributor;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.SelectionKeyHandler;
import org.glassfish.grizzly.nio.SelectorHandler;
import org.glassfish.grizzly.strategies.WorkerThreadIOStrategy;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

public abstract class NIOTransportBuilder<T extends NIOTransportBuilder> {
    protected Class<? extends NIOTransport> transportClass;
    protected ThreadPoolConfig workerConfig;
    protected ThreadPoolConfig kernelConfig;
    protected SelectorProvider selectorProvider;
    protected SelectorHandler selectorHandler = SelectorHandler.DEFAULT_SELECTOR_HANDLER;
    protected SelectionKeyHandler selectionKeyHandler = SelectionKeyHandler.DEFAULT_SELECTION_KEY_HANDLER;
    protected MemoryManager memoryManager = MemoryManager.DEFAULT_MEMORY_MANAGER;
    protected AttributeBuilder attributeBuilder = AttributeBuilder.DEFAULT_ATTRIBUTE_BUILDER;
    protected IOStrategy ioStrategy = WorkerThreadIOStrategy.getInstance();
    protected int selectorRunnerCount = -1;
    protected NIOChannelDistributor nioChannelDistributor;
    protected String name;
    protected Processor processor;
    protected ProcessorSelector processorSelector;
    protected int readBufferSize = -1;
    protected int writeBufferSize = -1;
    protected int clientSocketSoTimeout = -1;
    protected int connectionTimeout = 30000;
    protected boolean reuseAddress = true;
    protected int maxPendingBytesPerConnection = -2;
    protected boolean optimizedForMultiplexing = false;

    protected NIOTransportBuilder(Class<? extends NIOTransport> transportClass) {
        this.transportClass = transportClass;
    }

    public ThreadPoolConfig getWorkerThreadPoolConfig() {
        return this.workerConfig;
    }

    public T setWorkerThreadPoolConfig(ThreadPoolConfig workerConfig) {
        this.workerConfig = workerConfig;
        return this.getThis();
    }

    public ThreadPoolConfig getSelectorThreadPoolConfig() {
        return this.kernelConfig;
    }

    public T setSelectorThreadPoolConfig(ThreadPoolConfig kernelConfig) {
        this.kernelConfig = kernelConfig;
        return this.getThis();
    }

    public IOStrategy getIOStrategy() {
        return this.ioStrategy;
    }

    public T setIOStrategy(IOStrategy ioStrategy) {
        this.ioStrategy = ioStrategy;
        return this.getThis();
    }

    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public T setMemoryManager(MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
        return this.getThis();
    }

    public SelectorHandler getSelectorHandler() {
        return this.selectorHandler;
    }

    public T setSelectorHandler(SelectorHandler selectorHandler) {
        this.selectorHandler = selectorHandler;
        return this.getThis();
    }

    public SelectionKeyHandler getSelectionKeyHandler() {
        return this.selectionKeyHandler;
    }

    public T setSelectionKeyHandler(SelectionKeyHandler selectionKeyHandler) {
        this.selectionKeyHandler = selectionKeyHandler;
        return this.getThis();
    }

    public AttributeBuilder getAttributeBuilder() {
        return this.attributeBuilder;
    }

    public T setAttributeBuilder(AttributeBuilder attributeBuilder) {
        this.attributeBuilder = attributeBuilder;
        return this.getThis();
    }

    public NIOChannelDistributor getNIOChannelDistributor() {
        return this.nioChannelDistributor;
    }

    public T setNIOChannelDistributor(NIOChannelDistributor nioChannelDistributor) {
        this.nioChannelDistributor = nioChannelDistributor;
        return this.getThis();
    }

    public SelectorProvider getSelectorProvider() {
        return this.selectorProvider;
    }

    public T setSelectorProvider(SelectorProvider selectorProvider) {
        this.selectorProvider = selectorProvider;
        return this.getThis();
    }

    public String getName() {
        return this.name;
    }

    public T setName(String name) {
        this.name = name;
        return this.getThis();
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public T setProcessor(Processor processor) {
        this.processor = processor;
        return this.getThis();
    }

    public ProcessorSelector getProcessorSelector() {
        return this.processorSelector;
    }

    public T setProcessorSelector(ProcessorSelector processorSelector) {
        this.processorSelector = processorSelector;
        return this.getThis();
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public T setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
        return this.getThis();
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public T setWriteBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
        return this.getThis();
    }

    public int getClientSocketSoTimeout() {
        return this.clientSocketSoTimeout;
    }

    public T setClientSocketSoTimeout(int clientSocketSoTimeout) {
        this.clientSocketSoTimeout = clientSocketSoTimeout;
        return this.getThis();
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public T setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this.getThis();
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public T setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
        return this.getThis();
    }

    public int getMaxAsyncWriteQueueSizeInBytes() {
        return this.maxPendingBytesPerConnection;
    }

    public T setMaxAsyncWriteQueueSizeInBytes(int maxAsyncWriteQueueSizeInBytes) {
        this.maxPendingBytesPerConnection = maxAsyncWriteQueueSizeInBytes;
        return this.getThis();
    }

    public boolean isOptimizedForMultiplexing() {
        return this.optimizedForMultiplexing;
    }

    public T setOptimizedForMultiplexing(boolean optimizedForMultiplexing) {
        this.optimizedForMultiplexing = optimizedForMultiplexing;
        return this.getThis();
    }

    public NIOTransport build() {
        ThreadPoolConfig kernelLocal;
        NIOTransport transport = this.create();
        transport.setIOStrategy(this.ioStrategy);
        if (this.workerConfig != null) {
            transport.setWorkerThreadPoolConfig(this.workerConfig);
        }
        if ((kernelLocal = this.kernelConfig) != null) {
            transport.setKernelThreadPoolConfig(kernelLocal);
        } else {
            kernelLocal = ThreadPoolConfig.defaultConfig();
            transport.setKernelThreadPoolConfig(kernelLocal);
        }
        transport.setSelectorProvider(this.selectorProvider);
        transport.setSelectorHandler(this.selectorHandler);
        transport.setSelectionKeyHandler(this.selectionKeyHandler);
        transport.setMemoryManager(this.memoryManager);
        transport.setAttributeBuilder(this.attributeBuilder);
        transport.setSelectorRunnersCount(this.selectorRunnerCount);
        transport.setNIOChannelDistributor(this.nioChannelDistributor);
        transport.setProcessor(this.processor);
        transport.setProcessorSelector(this.processorSelector);
        transport.setReadBufferSize(this.readBufferSize);
        transport.setWriteBufferSize(this.writeBufferSize);
        transport.setReuseAddress(this.reuseAddress);
        transport.setOptimizedForMultiplexing(this.isOptimizedForMultiplexing());
        transport.getAsyncQueueIO().getWriter().setMaxPendingBytesPerConnection(this.maxPendingBytesPerConnection);
        return transport;
    }

    protected ThreadPoolConfig configSelectorPool(ThreadPoolConfig config) {
        int runnerCount = this.getRunnerCount();
        config.setPoolName("Grizzly-kernel");
        return config.setCorePoolSize(runnerCount).setMaxPoolSize(runnerCount);
    }

    protected abstract T getThis();

    protected abstract NIOTransport create();

    private int getRunnerCount() {
        return Runtime.getRuntime().availableProcessors();
    }
}

