/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.view.aggregator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.helix.api.config.ViewClusterSourceConfig;
import org.apache.helix.model.ClusterConfig;

public class SourceClusterConfigChangeAction {
    private final List<ViewClusterSourceConfig> _toAdd;
    private final List<ViewClusterSourceConfig> _toDelete;
    private final ClusterConfig _oldConfig;
    private final ClusterConfig _newConfig;
    private boolean _shouldResetTimer;

    public SourceClusterConfigChangeAction(ClusterConfig oldConfig, ClusterConfig newConfig) {
        this._oldConfig = oldConfig;
        this._newConfig = newConfig;
        this._shouldResetTimer = false;
        this._toAdd = new ArrayList<ViewClusterSourceConfig>();
        this._toDelete = new ArrayList<ViewClusterSourceConfig>();
        this.validate();
    }

    private void validate() {
        StringBuilder allErrs = new StringBuilder();
        if (this._newConfig == null) {
            allErrs.append("New config is null;");
        }
        if (this._oldConfig != null && !this._oldConfig.isViewCluster()) {
            allErrs.append("Old config is not view cluster config;");
        }
        if (this._newConfig != null && !this._newConfig.isViewCluster()) {
            allErrs.append("New config is not view cluster config;");
        }
        if (allErrs.length() > 0) {
            throw new IllegalArgumentException(allErrs.toString());
        }
    }

    public void computeAction() {
        this._shouldResetTimer = this._oldConfig == null || this._oldConfig.getViewClusterRefershPeriod() != this._newConfig.getViewClusterRefershPeriod();
        HashMap<String, ViewClusterSourceConfig> oldConfigMap = new HashMap<String, ViewClusterSourceConfig>();
        HashMap<String, ViewClusterSourceConfig> currentConfigMap = new HashMap<String, ViewClusterSourceConfig>();
        if (this._oldConfig != null) {
            for (ViewClusterSourceConfig viewClusterSourceConfig : this._oldConfig.getViewClusterSourceConfigs()) {
                oldConfigMap.put(this.generateConfigMapKey(viewClusterSourceConfig.getName(), viewClusterSourceConfig.getZkAddress()), viewClusterSourceConfig);
            }
        }
        for (ViewClusterSourceConfig viewClusterSourceConfig : this._newConfig.getViewClusterSourceConfigs()) {
            currentConfigMap.put(this.generateConfigMapKey(viewClusterSourceConfig.getName(), viewClusterSourceConfig.getZkAddress()), viewClusterSourceConfig);
        }
        for (Map.Entry entry : currentConfigMap.entrySet()) {
            HashSet currentPropertySet;
            HashSet oldPropertySet;
            if (!oldConfigMap.containsKey(entry.getKey()) || (oldPropertySet = new HashSet(((ViewClusterSourceConfig)oldConfigMap.get(entry.getKey())).getProperties())).equals(currentPropertySet = new HashSet(((ViewClusterSourceConfig)entry.getValue()).getProperties()))) continue;
            this._toAdd.add(new ViewClusterSourceConfig((ViewClusterSourceConfig)entry.getValue()));
            this._toDelete.add(new ViewClusterSourceConfig((ViewClusterSourceConfig)oldConfigMap.get(entry.getKey())));
        }
        HashSet removedKeys = new HashSet(oldConfigMap.keySet());
        removedKeys.removeAll(currentConfigMap.keySet());
        for (String removedKey : removedKeys) {
            this._toDelete.add(new ViewClusterSourceConfig((ViewClusterSourceConfig)oldConfigMap.get(removedKey)));
        }
        HashSet hashSet = new HashSet(currentConfigMap.keySet());
        hashSet.removeAll(oldConfigMap.keySet());
        for (String addedKey : hashSet) {
            this._toAdd.add(new ViewClusterSourceConfig((ViewClusterSourceConfig)currentConfigMap.get(addedKey)));
        }
    }

    public List<ViewClusterSourceConfig> getConfigsToAdd() {
        return this._toAdd;
    }

    public List<ViewClusterSourceConfig> getConfigsToDelete() {
        return this._toDelete;
    }

    public boolean shouldResetTimer() {
        return this._shouldResetTimer;
    }

    public long getCurrentRefreshPeriodMs() {
        return this._newConfig.getViewClusterRefershPeriod() * 1000;
    }

    private String generateConfigMapKey(String clusterName, String zkAddr) {
        return String.format("%s%s", clusterName, zkAddr);
    }
}

