/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.introspect;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.annotation.NoClass;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;

public class CodehausJacksonIntrospector
extends NopAnnotationIntrospector {
    private static final long serialVersionUID = 1L;

    public JsonIgnoreProperties.Value findPropertyIgnorals(Annotated a) {
        JsonIgnoreProperties ignoreAnnotation = (JsonIgnoreProperties)a.getAnnotation(JsonIgnoreProperties.class);
        if (ignoreAnnotation != null) {
            return JsonIgnoreProperties.Value.forIgnoreUnknown((boolean)ignoreAnnotation.ignoreUnknown());
        }
        return super.findPropertyIgnorals(a);
    }

    public Class<?> findDeserializationContentType(Annotated a, JavaType baseContentType) {
        Class serClass;
        JsonSerialize serializeAnnotation = (JsonSerialize)a.getAnnotation(JsonSerialize.class);
        if (serializeAnnotation != null && (serClass = serializeAnnotation.contentAs()) != NoClass.class) {
            return serClass;
        }
        return null;
    }

    public PropertyName findNameForDeserialization(Annotated a) {
        String name = null;
        if (a instanceof AnnotatedField) {
            name = this.findDeserializationName((AnnotatedField)a);
        } else if (a instanceof AnnotatedMethod) {
            name = this.findDeserializationName((AnnotatedMethod)a);
        } else if (a instanceof AnnotatedParameter) {
            name = this.findDeserializationName((AnnotatedParameter)a);
        }
        if (name == null) {
            return null;
        }
        return name.isEmpty() ? PropertyName.USE_DEFAULT : new PropertyName(name);
    }

    public String findDeserializationName(AnnotatedField af) {
        JsonProperty propertyAnnotation = (JsonProperty)af.getAnnotation(JsonProperty.class);
        return propertyAnnotation == null ? null : propertyAnnotation.value();
    }

    public String findDeserializationName(AnnotatedMethod am) {
        JsonProperty propertyAnnotation = (JsonProperty)am.getAnnotation(JsonProperty.class);
        return propertyAnnotation == null ? null : propertyAnnotation.value();
    }

    public String findDeserializationName(AnnotatedParameter param) {
        JsonProperty propertyAnnotation;
        if (param != null && (propertyAnnotation = (JsonProperty)param.getAnnotation(JsonProperty.class)) != null) {
            return propertyAnnotation.value();
        }
        return null;
    }

    public Class<?> findSerializationContentType(Annotated a, JavaType baseType) {
        Class serClass;
        JsonSerialize serializeAnnotation = (JsonSerialize)a.getAnnotation(JsonSerialize.class);
        if (serializeAnnotation != null && (serClass = serializeAnnotation.contentAs()) != NoClass.class) {
            return serClass;
        }
        return null;
    }

    public JsonInclude.Value findPropertyInclusion(Annotated a) {
        JsonSerialize serializeAnnotation = (JsonSerialize)a.getAnnotation(JsonSerialize.class);
        if (serializeAnnotation != null) {
            for (JsonInclude.Include include : JsonInclude.Include.values()) {
                if (!include.name().equals(serializeAnnotation.include().name())) continue;
                return JsonInclude.Value.construct((JsonInclude.Include)include, (JsonInclude.Include)include);
            }
        }
        return JsonInclude.Value.empty();
    }

    public JsonInclude.Include findSerializationInclusion(Annotated a, JsonInclude.Include defValue) {
        JsonSerialize serializeAnnotation = (JsonSerialize)a.getAnnotation(JsonSerialize.class);
        return serializeAnnotation == null ? defValue : JsonInclude.Include.valueOf((String)serializeAnnotation.include().name());
    }

    public JsonInclude.Include findSerializationInclusionForContent(Annotated a, JsonInclude.Include defValue) {
        JsonSerialize serializeAnnotation = (JsonSerialize)a.getAnnotation(JsonSerialize.class);
        return serializeAnnotation == null ? defValue : JsonInclude.Include.valueOf((String)serializeAnnotation.include().name());
    }

    public Class<?> findSerializationKeyType(Annotated a, JavaType baseType) {
        Class serClass;
        JsonSerialize serializeAnnotation = (JsonSerialize)a.getAnnotation(JsonSerialize.class);
        if (serializeAnnotation != null && (serClass = serializeAnnotation.keyAs()) != NoClass.class) {
            return serClass;
        }
        return null;
    }

    public Class<?> findSerializationType(Annotated a) {
        Class serClass;
        JsonSerialize serializeAnnotation = (JsonSerialize)a.getAnnotation(JsonSerialize.class);
        if (serializeAnnotation != null && (serClass = serializeAnnotation.as()) != NoClass.class) {
            return serClass;
        }
        return null;
    }

    public JsonSerialize.Typing findSerializationTyping(Annotated a) {
        JsonSerialize serializeAnnotation = (JsonSerialize)a.getAnnotation(JsonSerialize.class);
        return serializeAnnotation == null ? null : JsonSerialize.Typing.valueOf((String)serializeAnnotation.typing().name());
    }

    public PropertyName findNameForSerialization(Annotated a) {
        String name = a instanceof AnnotatedField ? this.findSerializationName((AnnotatedField)a) : (a instanceof AnnotatedMethod ? this.findSerializationName((AnnotatedMethod)a) : null);
        if (name != null) {
            if (name.length() == 0) {
                return PropertyName.USE_DEFAULT;
            }
            return new PropertyName(name);
        }
        return null;
    }

    public String findSerializationName(AnnotatedField af) {
        JsonProperty propertyAnnotation = (JsonProperty)af.getAnnotation(JsonProperty.class);
        if (propertyAnnotation != null) {
            return propertyAnnotation.value();
        }
        if (af.hasAnnotation(JsonSerialize.class)) {
            return "";
        }
        return null;
    }

    public String findSerializationName(AnnotatedMethod am) {
        JsonProperty propertyAnnotation = (JsonProperty)am.getAnnotation(JsonProperty.class);
        if (propertyAnnotation != null) {
            return propertyAnnotation.value();
        }
        if (am.hasAnnotation(JsonSerialize.class)) {
            return "";
        }
        return null;
    }

    public boolean hasCreatorAnnotation(Annotated a) {
        return a.hasAnnotation(JsonCreator.class);
    }

    public boolean hasIgnoreMarker(AnnotatedMember am) {
        JsonIgnore ignoreAnnotation = (JsonIgnore)am.getAnnotation(JsonIgnore.class);
        return ignoreAnnotation != null && ignoreAnnotation.value();
    }

    public Object findSerializer(Annotated a) {
        Class serClass;
        JsonSerialize serializeAnnotation = (JsonSerialize)a.getAnnotation(JsonSerialize.class);
        if (serializeAnnotation != null && (serClass = serializeAnnotation.using()) != JsonSerializer.None.class) {
            return serClass;
        }
        return null;
    }

    public Object findKeySerializer(Annotated a) {
        Class serClass;
        JsonSerialize serializeAnnotation = (JsonSerialize)a.getAnnotation(JsonSerialize.class);
        if (serializeAnnotation != null && (serClass = serializeAnnotation.keyUsing()) != JsonSerializer.None.class) {
            return serClass;
        }
        return null;
    }

    public Object findContentSerializer(Annotated a) {
        Class serClass;
        JsonSerialize serializeAnnotation = (JsonSerialize)a.getAnnotation(JsonSerialize.class);
        if (serializeAnnotation != null && (serClass = serializeAnnotation.contentUsing()) != JsonSerializer.None.class) {
            return serClass;
        }
        return null;
    }
}

