/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server.resources;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.helix.HelixException;
import org.apache.helix.rest.common.ContextPropertyKeys;
import org.apache.helix.rest.common.HelixRestNamespace;
import org.apache.helix.rest.server.auditlog.AuditLog;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.introspect.CodehausJacksonIntrospector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/json", "text/plain"})
@Consumes(value={"application/json", "text/plain"})
public class AbstractResource {
    private static Logger _logger = LoggerFactory.getLogger((String)AbstractResource.class.getName());
    @Context
    protected Application _application;
    @Context
    protected HttpServletRequest _servletRequest;
    protected AuditLog.Builder _auditLogBuilder;
    protected static ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected static ObjectReader ZNRECORD_READER = new ObjectMapper().setAnnotationIntrospector((AnnotationIntrospector)new CodehausJacksonIntrospector()).readerFor(ZNRecord.class);

    protected void addExceptionToAuditLog(Exception ex) {
        if (this._auditLogBuilder == null) {
            this._auditLogBuilder = (AuditLog.Builder)this._servletRequest.getAttribute("AUDIT_LOG");
        }
        this._auditLogBuilder.addException(ex);
    }

    protected Response serverError() {
        return Response.serverError().build();
    }

    protected Response serverError(String errorMsg) {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorMsgToJson(errorMsg)).build();
    }

    protected Response serverError(Exception ex) {
        this.addExceptionToAuditLog(ex);
        return Response.serverError().entity((Object)this.errorMsgToJson(ex.getMessage())).build();
    }

    protected Response notFound() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").build();
    }

    protected Response notFound(String errorMsg) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)this.errorMsgToJson(errorMsg)).build();
    }

    protected Response OK(Object entity) {
        return Response.ok((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    protected Response OK() {
        return Response.ok().build();
    }

    protected Response OKWithHeader(Object entity, String headerName, Object headerValue) {
        if (headerName == null || headerName.length() == 0) {
            return this.OK(entity);
        }
        return Response.ok((Object)entity).header(headerName, headerValue).build();
    }

    protected Response created() {
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    protected Response badRequest(String errorMsg) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorMsgToJson(errorMsg)).type("text/plain").build();
    }

    private String errorMsgToJson(String error) {
        try {
            HashMap<String, String> errorMap = new HashMap<String, String>();
            errorMap.put(Properties.error.name(), error);
            return AbstractResource.toJson(errorMap);
        }
        catch (IOException e) {
            _logger.error("Failed to convert " + error + " to JSON string", (Throwable)e);
            return error;
        }
    }

    protected Response JSONRepresentation(Object entity) {
        return this.JSONRepresentation(entity, null, null);
    }

    protected Response JSONRepresentation(Object entity, String headerName, Object headerValue) {
        try {
            String jsonStr = AbstractResource.toJson(entity);
            return this.OKWithHeader(jsonStr, headerName, headerValue);
        }
        catch (IOException e) {
            _logger.error("Failed to convert " + entity + " to JSON response", (Throwable)e);
            return this.serverError();
        }
    }

    protected static String toJson(Object object) throws IOException {
        OBJECT_MAPPER.enable(SerializationFeature.INDENT_OUTPUT);
        StringWriter sw = new StringWriter();
        OBJECT_MAPPER.writeValue((Writer)sw, object);
        sw.append('\n');
        return sw.toString();
    }

    protected Command getCommand(String commandStr) throws HelixException {
        if (commandStr == null) {
            throw new HelixException("Command string is null!");
        }
        try {
            return Command.valueOf(commandStr);
        }
        catch (IllegalArgumentException ex) {
            throw new HelixException("Unknown command: " + commandStr);
        }
    }

    protected String getNamespace() {
        HelixRestNamespace namespace = (HelixRestNamespace)this._application.getProperties().get(ContextPropertyKeys.METADATA.name());
        return namespace.getName();
    }

    public static enum Command {
        activate,
        deactivate,
        addInstanceTag,
        addVirtualTopologyGroup,
        expand,
        enable,
        disable,
        enableMaintenanceMode,
        disableMaintenanceMode,
        enablePartitions,
        disablePartitions,
        update,
        add,
        delete,
        stoppable,
        rebalance,
        reset,
        resetPartitions,
        removeInstanceTag,
        addResource,
        addWagedResource,
        getResource,
        validateWeight,
        enableWagedRebalance,
        enableWagedRebalanceForAllResources,
        purgeOfflineParticipants,
        getInstance,
        getAllInstances,
        setInstanceOperation,
        canCompleteSwap,
        completeSwapIfPossible,
        onDemandRebalance,
        isEvacuateFinished,
        setPartitionsToError;

    }

    public static enum Properties {
        id,
        disabled,
        history,
        count,
        error;

    }
}

