/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server.resources.helix;

import java.io.IOException;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.manager.zk.ZkBucketDataAccessor;
import org.apache.helix.rest.common.ContextPropertyKeys;
import org.apache.helix.rest.server.ServerContext;
import org.apache.helix.rest.server.resources.AbstractResource;
import org.apache.helix.task.TaskDriver;
import org.apache.helix.tools.ClusterSetup;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.impl.client.ZkClient;

public class AbstractHelixResource
extends AbstractResource {
    public RealmAwareZkClient getRealmAwareZkClient() {
        ServerContext serverContext = this.getServerContext();
        return serverContext.getRealmAwareZkClient();
    }

    @Deprecated
    public ZkClient getZkClient() {
        return (ZkClient)this.getRealmAwareZkClient();
    }

    public HelixAdmin getHelixAdmin() {
        ServerContext serverContext = this.getServerContext();
        return serverContext.getHelixAdmin();
    }

    public ClusterSetup getClusterSetup() {
        ServerContext serverContext = this.getServerContext();
        return serverContext.getClusterSetup();
    }

    public TaskDriver getTaskDriver(String clusterName) {
        ServerContext serverContext = this.getServerContext();
        return serverContext.getTaskDriver(clusterName);
    }

    public ConfigAccessor getConfigAccessor() {
        ServerContext serverContext = this.getServerContext();
        return serverContext.getConfigAccessor();
    }

    public HelixDataAccessor getDataAccssor(String clusterName) {
        ServerContext serverContext = this.getServerContext();
        return serverContext.getDataAccessor(clusterName);
    }

    protected BaseDataAccessor<byte[]> getByteArrayDataAccessor() {
        return this.getServerContext().getByteArrayZkBaseDataAccessor();
    }

    protected ZkBucketDataAccessor getZkBucketDataAccessor() {
        return this.getServerContext().getZkBucketDataAccessor();
    }

    protected static ZNRecord toZNRecord(String data) throws IOException {
        return (ZNRecord)ZNRECORD_READER.readValue(data);
    }

    private ServerContext getServerContext() {
        return (ServerContext)this._application.getProperties().get(ContextPropertyKeys.SERVER_CONTEXT.name());
    }
}

