/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.PartitionFrameCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.str.CharSink;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPartitionFrameCursorFactory
implements PartitionFrameCursorFactory {
    private final RecordMetadata metadata;
    private final long metadataVersion;
    private final TableToken tableToken;

    public AbstractPartitionFrameCursorFactory(TableToken tableToken, long metadataVersion, RecordMetadata metadata) {
        this.tableToken = tableToken;
        this.metadataVersion = metadataVersion;
        this.metadata = metadata;
    }

    @Override
    public void close() {
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public TableToken getTableToken() {
        return this.tableToken;
    }

    @Override
    public boolean supportsTableRowId(TableToken tableToken) {
        return this.tableToken.equals(tableToken);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.meta("on").val(this.tableToken.getTableName());
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        sink.putAscii("{\"name\":\"").put(this.getClass().getSimpleName()).putAscii("\", \"table\":\"").put(this.tableToken).putAscii("\"}");
    }

    protected TableReader getReader(SqlExecutionContext executionContext) {
        return executionContext.getReader(this.tableToken, this.metadataVersion);
    }
}

