/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractIntervalPartitionFrameCursor;
import io.questdb.cairo.TimestampFinder;
import io.questdb.cairo.sql.PartitionFrame;
import io.questdb.griffin.model.RuntimeIntrinsicIntervalModel;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;

public class IntervalBwdPartitionFrameCursor
extends AbstractIntervalPartitionFrameCursor {
    private static final Log LOG = LogFactory.getLog(IntervalBwdPartitionFrameCursor.class);

    public IntervalBwdPartitionFrameCursor(RuntimeIntrinsicIntervalModel intervalModel, int timestampIndex) {
        super(intervalModel, timestampIndex);
    }

    @Override
    public PartitionFrame next(long skipTarget) {
        while (this.intervalsLo < this.intervalsHi && this.partitionLo < this.partitionHi) {
            int currentInterval = this.intervalsHi - 1;
            int currentPartition = this.partitionHi - 1;
            long rowCount = this.reader.getPartitionRowCountFromMetadata(currentPartition);
            if (rowCount > 0L) {
                TimestampFinder timestampFinder = this.initTimestampFinder(currentPartition, rowCount);
                long intervalLo = this.intervals.getQuick(currentInterval * 2);
                long intervalHi = this.intervals.getQuick(currentInterval * 2 + 1);
                long limitHi = this.partitionLimit == -1L ? rowCount - 1L : this.partitionLimit - 1L;
                LOG.debug().$("next [partition=").$(currentPartition).$(", intervalLo=").microTime(intervalLo).$(", intervalHi=").microTime(intervalHi).$(", limitHi=").$(limitHi).$(", rowCount=").$(rowCount).$(", currentInterval=").$(currentInterval).I$();
                long partitionTimestampLoApprox = timestampFinder.minTimestampApproxFromMetadata();
                if (partitionTimestampLoApprox > intervalHi) {
                    this.skipPartition(currentPartition);
                    continue;
                }
                long partitionTimestampHiApprox = timestampFinder.maxTimestampApproxFromMetadata();
                if (partitionTimestampHiApprox < intervalLo) {
                    this.skipInterval(currentInterval, limitHi + 1L);
                    continue;
                }
                this.reader.openPartition(currentPartition);
                timestampFinder.prepare();
                long partitionTimestampHiExact = timestampFinder.timestampAt(limitHi);
                if (partitionTimestampHiExact < intervalLo) {
                    this.skipInterval(currentInterval, limitHi + 1L);
                    continue;
                }
                long partitionTimestampLoExact = timestampFinder.minTimestampExact();
                long lo = partitionTimestampLoExact < intervalLo ? timestampFinder.findTimestamp(intervalLo - 1L, 0L, limitHi) + 1L : 0L;
                long hi = partitionTimestampHiExact > intervalHi ? timestampFinder.findTimestamp(intervalHi, lo, limitHi) + 1L : limitHi + 1L;
                if (lo == 0L) {
                    this.skipPartition(currentPartition);
                } else {
                    this.skipInterval(currentInterval, lo);
                }
                if (lo >= hi) continue;
                this.frame.partitionIndex = currentPartition;
                this.frame.rowLo = lo;
                this.frame.rowHi = hi;
                this.sizeSoFar += hi - lo;
                byte format = this.reader.getPartitionFormat(currentPartition);
                if (format == 1) {
                    assert (this.parquetDecoder.getFileAddr() != -1L) : "parquet decoder is not initialized";
                    this.frame.format = 1;
                    this.frame.parquetDecoder = this.parquetDecoder;
                } else {
                    assert (format == 0);
                    this.frame.format = 0;
                    this.frame.parquetDecoder = null;
                }
                return this.frame;
            }
            this.partitionLimit = -1L;
            this.partitionHi = currentPartition;
        }
        return null;
    }

    @Override
    public void toTop() {
        super.toTop();
        this.partitionLimit = -1L;
    }

    private void skipInterval(int intervalIndex, long limit) {
        LOG.debug().$("next skips interval [partitionLimit=").$(limit).$(", intervalsHi=").$(intervalIndex).$(']').$();
        this.partitionLimit = limit;
        this.intervalsHi = intervalIndex;
    }

    private void skipPartition(int currentPartition) {
        LOG.debug().$("next skips partition").$();
        this.partitionHi = currentPartition;
        this.partitionLimit = -1L;
    }
}

