/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.SymbolMapWriter;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMOR;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.Hash;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;

public class SymbolMapUtil {
    private static final Log LOG = LogFactory.getLog(SymbolMapUtil.class);
    private MemoryCMOR charMem;
    private BitmapIndexWriter indexWriter;
    private MemoryMARW offsetMem;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildSymbolFiles(CairoConfiguration configuration, Path path, CharSequence name, long columnNameTxn, int symbolCount, int symbolCapacity) {
        int plen = path.size();
        try {
            FilesFacade ff = configuration.getFilesFacade();
            long mapPageSize = configuration.getMiscAppendPageSize();
            if (!ff.exists(TableUtils.offsetFileName(path.trimTo(plen), name, columnNameTxn))) {
                LOG.error().$(path).$(" is not found").$();
                throw CairoException.critical(0).put("SymbolMap does not exist: ").put(path);
            }
            long len = ff.length(path.$());
            if (len < 64L) {
                LOG.error().$(path).$(" is too short [len=").$(len).$(']').$();
                throw CairoException.critical(0).put("SymbolMap is too short: ").put(path);
            }
            this.offsetMem = SymbolMapUtil.open(configuration, ff, mapPageSize, len, path.$(), this.offsetMem);
            if (symbolCapacity < 1) {
                symbolCapacity = this.offsetMem.getInt(0L);
                assert (symbolCapacity > 0);
            }
            int maxHash = Math.max(Numbers.ceilPow2(symbolCapacity / 2) - 1, 1);
            if (this.indexWriter == null) {
                this.indexWriter = new BitmapIndexWriter(configuration);
            }
            this.indexWriter.of(path.trimTo(plen), name, columnNameTxn);
            this.truncate(symbolCapacity);
            long charFileLen = ff.length(TableUtils.charFileName(path.trimTo(plen), name, columnNameTxn));
            if (charFileLen == 0L) {
                return;
            }
            this.charMem = SymbolMapUtil.open(configuration, ff, mapPageSize, -1L, TableUtils.charFileName(path.trimTo(plen), name, columnNameTxn), this.charMem);
            long strOffset = 0L;
            long offsetOffset = SymbolMapWriter.keyToOffset(0);
            this.offsetMem.putLong(0L);
            offsetOffset += 8L;
            for (int i = 0; i < symbolCount; ++i) {
                if (strOffset > this.charMem.size() - 4L) {
                    throw new CairoException().put("corrupted symbol map [name=").put(path).put(']');
                }
                CharSequence symbol = this.charMem.getStrA(strOffset);
                strOffset += (long)Vm.getStorageLength(symbol);
                if (symbol.length() == 0) {
                    LOG.info().$("symbol is empty [index=").$(i).$(']').$();
                }
                int hash = Hash.boundedHash(symbol, maxHash);
                this.indexWriter.add(hash, offsetOffset - 8L);
                this.offsetMem.putLong(strOffset);
                offsetOffset += 8L;
            }
        }
        finally {
            Misc.free(this.charMem);
            if (this.offsetMem != null) {
                this.offsetMem.close(false);
            }
            Misc.free(this.indexWriter);
            path.trimTo(plen);
        }
    }

    private static MemoryCMOR open(CairoConfiguration configuration, FilesFacade ff, long mapPageSize, long size, LPSZ path, MemoryCMOR mem) {
        long fileSize;
        if (size == -1L && (fileSize = ff.length(path)) > 0L) {
            size = fileSize;
        }
        if (mem == null) {
            mem = Vm.getMemoryCMOR();
        }
        mem.of(ff, path, mapPageSize, size, 5, configuration.getWriterFileOpenOpts());
        return mem;
    }

    private static MemoryMARW open(CairoConfiguration configuration, FilesFacade ff, long mapPageSize, long size, LPSZ path, MemoryMARW mem) {
        if (mem == null) {
            mem = Vm.getCMARWInstance(ff, path, mapPageSize, size, 5, configuration.getWriterFileOpenOpts());
        } else {
            mem.of(ff, path, mapPageSize, size, 5, configuration.getWriterFileOpenOpts());
        }
        return mem;
    }

    private void truncate(int symbolCapacity) {
        boolean useCache = this.offsetMem.getBool(4L);
        boolean nullFlag = this.offsetMem.getBool(8L);
        this.offsetMem.truncate();
        this.offsetMem.putInt(0L, symbolCapacity);
        this.offsetMem.putBool(4L, useCache);
        this.offsetMem.putBool(8L, nullFlag);
        this.offsetMem.jumpTo(SymbolMapWriter.keyToOffset(0));
        this.indexWriter.truncate();
    }
}

