/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.ColumnFilter;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.map.RecordValueSink;
import io.questdb.cairo.sql.Record;
import io.questdb.std.BytecodeAssembler;

public class RecordValueSinkFactory {
    public static RecordValueSink getInstance(BytecodeAssembler asm, ColumnTypes columnTypes, ColumnFilter columnFilter) {
        asm.init(RecordSink.class);
        asm.setupPool();
        int thisClassIndex = asm.poolClass(asm.poolUtf8("io/questdb/cairo/valuesink"));
        int interfaceClassIndex = asm.poolClass(RecordValueSink.class);
        int rGetInt = asm.poolInterfaceMethod(Record.class, "getInt", "(I)I");
        int rGetIPv4 = asm.poolInterfaceMethod(Record.class, "getIPv4", "(I)I");
        int rGetGeoInt = asm.poolInterfaceMethod(Record.class, "getGeoInt", "(I)I");
        int rGetLong = asm.poolInterfaceMethod(Record.class, "getLong", "(I)J");
        int rGetGeoLong = asm.poolInterfaceMethod(Record.class, "getGeoLong", "(I)J");
        int rGetDate = asm.poolInterfaceMethod(Record.class, "getDate", "(I)J");
        int rGetTimestamp = asm.poolInterfaceMethod(Record.class, "getTimestamp", "(I)J");
        int rGetByte = asm.poolInterfaceMethod(Record.class, "getByte", "(I)B");
        int rGetGeoByte = asm.poolInterfaceMethod(Record.class, "getGeoByte", "(I)B");
        int rGetShort = asm.poolInterfaceMethod(Record.class, "getShort", "(I)S");
        int rGetGeoShort = asm.poolInterfaceMethod(Record.class, "getGeoShort", "(I)S");
        int rGetChar = asm.poolInterfaceMethod(Record.class, "getChar", "(I)C");
        int rGetBool = asm.poolInterfaceMethod(Record.class, "getBool", "(I)Z");
        int rGetFloat = asm.poolInterfaceMethod(Record.class, "getFloat", "(I)F");
        int rGetDouble = asm.poolInterfaceMethod(Record.class, "getDouble", "(I)D");
        int wPutInt = asm.poolInterfaceMethod(MapValue.class, "putInt", "(II)V");
        int wPutLong = asm.poolInterfaceMethod(MapValue.class, "putLong", "(IJ)V");
        int wPutByte = asm.poolInterfaceMethod(MapValue.class, "putByte", "(IB)V");
        int wPutShort = asm.poolInterfaceMethod(MapValue.class, "putShort", "(IS)V");
        int wPutChar = asm.poolInterfaceMethod(MapValue.class, "putChar", "(IC)V");
        int wPutBool = asm.poolInterfaceMethod(MapValue.class, "putBool", "(IZ)V");
        int wPutFloat = asm.poolInterfaceMethod(MapValue.class, "putFloat", "(IF)V");
        int wPutDouble = asm.poolInterfaceMethod(MapValue.class, "putDouble", "(ID)V");
        int wPutDate = asm.poolInterfaceMethod(MapValue.class, "putDate", "(IJ)V");
        int wPutTimestamp = asm.poolInterfaceMethod(MapValue.class, "putTimestamp", "(IJ)V");
        int copyNameIndex = asm.poolUtf8("copy");
        int copySigIndex = asm.poolUtf8("(Lio/questdb/cairo/sql/Record;Lio/questdb/cairo/map/MapValue;)V");
        asm.finishPool();
        asm.defineClass(thisClassIndex);
        asm.interfaceCount(1);
        asm.putShort(interfaceClassIndex);
        asm.fieldCount(0);
        asm.methodCount(2);
        asm.defineDefaultConstructor();
        asm.startMethod(copyNameIndex, copySigIndex, 4, 3);
        int n = columnFilter.getColumnCount();
        block17: for (int i = 0; i < n; ++i) {
            int index = columnFilter.getColumnIndexFactored(i);
            asm.aload(2);
            asm.iconst(i);
            asm.aload(1);
            asm.iconst(index);
            int columnType = columnTypes.getColumnType(index);
            switch (ColumnType.tagOf(columnType)) {
                case 5: 
                case 12: {
                    asm.invokeInterface(rGetInt, 1);
                    asm.invokeInterface(wPutInt, 2);
                    continue block17;
                }
                case 25: {
                    asm.invokeInterface(rGetIPv4, 1);
                    asm.invokeInterface(wPutInt, 2);
                    continue block17;
                }
                case 16: {
                    asm.invokeInterface(rGetGeoInt, 1);
                    asm.invokeInterface(wPutInt, 2);
                    continue block17;
                }
                case 6: {
                    asm.invokeInterface(rGetLong, 1);
                    asm.invokeInterface(wPutLong, 3);
                    continue block17;
                }
                case 17: {
                    asm.invokeInterface(rGetGeoLong, 1);
                    asm.invokeInterface(wPutLong, 3);
                    continue block17;
                }
                case 7: {
                    asm.invokeInterface(rGetDate, 1);
                    asm.invokeInterface(wPutDate, 3);
                    continue block17;
                }
                case 8: {
                    asm.invokeInterface(rGetTimestamp, 1);
                    asm.invokeInterface(wPutTimestamp, 3);
                    continue block17;
                }
                case 2: {
                    asm.invokeInterface(rGetByte, 1);
                    asm.invokeInterface(wPutByte, 2);
                    continue block17;
                }
                case 14: {
                    asm.invokeInterface(rGetGeoByte, 1);
                    asm.invokeInterface(wPutByte, 2);
                    continue block17;
                }
                case 3: {
                    asm.invokeInterface(rGetShort, 1);
                    asm.invokeInterface(wPutShort, 2);
                    continue block17;
                }
                case 15: {
                    asm.invokeInterface(rGetGeoShort, 1);
                    asm.invokeInterface(wPutShort, 2);
                    continue block17;
                }
                case 4: {
                    asm.invokeInterface(rGetChar, 1);
                    asm.invokeInterface(wPutChar, 2);
                    continue block17;
                }
                case 1: {
                    asm.invokeInterface(rGetBool, 1);
                    asm.invokeInterface(wPutBool, 2);
                    continue block17;
                }
                case 9: {
                    asm.invokeInterface(rGetFloat, 1);
                    asm.invokeInterface(wPutFloat, 2);
                    continue block17;
                }
                case 10: {
                    asm.invokeInterface(rGetDouble, 1);
                    asm.invokeInterface(wPutDouble, 3);
                    continue block17;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        asm.return_();
        asm.endMethodCode();
        asm.putShort(0);
        asm.putShort(0);
        asm.endMethod();
        asm.putShort(0);
        return (RecordValueSink)asm.newInstance();
    }
}

