/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapRecordCursor;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.map.MapValueMergeFunction;
import io.questdb.cairo.map.UnorderedVarcharMapCursor;
import io.questdb.cairo.map.UnorderedVarcharMapRecord;
import io.questdb.cairo.map.UnorderedVarcharMapValue;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.LimitOverflowException;
import io.questdb.griffin.engine.groupby.FastGroupByAllocator;
import io.questdb.griffin.engine.groupby.GroupByAllocator;
import io.questdb.std.BinarySequence;
import io.questdb.std.Hash;
import io.questdb.std.Interval;
import io.questdb.std.Long256;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.bytes.Bytes;
import io.questdb.std.bytes.DirectByteSink;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.Nullable;

public class UnorderedVarcharMap
implements Map,
Reopenable {
    static final byte FLAG_IS_ASCII = -128;
    static final byte FLAG_IS_NULL = 64;
    static final long KEY_SIZE = 16L;
    static final int MASK_FLAGS_FROM_SIZE = 0x3FFFFFFF;
    static final long PTR_UNSTABLE_MASK = Long.MIN_VALUE;
    static final long PTR_MASK = Long.MAX_VALUE;
    static final int SIZE_IS_NULL = 0x40000000;
    private static final int KEY_SINK_INITIAL_CAPACITY = 16;
    private static final long MAX_SAFE_INT_POW_2 = 0x80000000L;
    private static final int MIN_KEY_CAPACITY = 16;
    private final GroupByAllocator allocator;
    private final UnorderedVarcharMapCursor cursor;
    private final long entrySize;
    private final Key key;
    private final DirectByteSink keySink;
    private final double loadFactor;
    private final int maxResizes;
    private final int memoryTag;
    private final UnorderedVarcharMapRecord record;
    private final UnorderedVarcharMapValue value;
    private final UnorderedVarcharMapValue value2;
    private final UnorderedVarcharMapValue value3;
    private int free;
    private int initialKeyCapacity;
    private int keyCapacity;
    private long mask;
    private long memLimit;
    private long memStart;
    private int nResizes;
    private int size = 0;

    public UnorderedVarcharMap(@Nullable ColumnTypes valueTypes, int keyCapacity, double loadFactor, int maxResizes, long allocatorDefaultChunkSize, long allocatorMaxChunkSize) {
        this(valueTypes, keyCapacity, loadFactor, maxResizes, 60, allocatorDefaultChunkSize, allocatorMaxChunkSize);
    }

    UnorderedVarcharMap(@Nullable ColumnTypes valueTypes, int keyCapacity, double loadFactor, int maxResizes, int memoryTag, long allocatorDefaultChunkSize, long allocatorMaxChunkSize) {
        assert (loadFactor > 0.0 && loadFactor < 1.0);
        try {
            this.memoryTag = memoryTag;
            this.loadFactor = loadFactor;
            this.keyCapacity = (int)((double)keyCapacity / loadFactor);
            this.keyCapacity = this.initialKeyCapacity = Math.max(Numbers.ceilPow2(this.keyCapacity), 16);
            this.maxResizes = maxResizes;
            this.mask = this.keyCapacity - 1;
            this.free = (int)((double)this.keyCapacity * loadFactor);
            this.nResizes = 0;
            long valueOffset = 0L;
            long[] valueOffsets = null;
            long valueSize = 0L;
            if (valueTypes != null) {
                int valueColumnCount = valueTypes.getColumnCount();
                valueOffsets = new long[valueColumnCount];
                for (int i = 0; i < valueColumnCount; ++i) {
                    valueOffsets[i] = valueOffset;
                    int columnType = valueTypes.getColumnType(i);
                    int size = ColumnType.sizeOf(columnType);
                    if (size <= 0) {
                        throw CairoException.nonCritical().put("value type is not supported: ").put(ColumnType.nameOf(columnType));
                    }
                    valueOffset += (long)size;
                    valueSize += (long)size;
                }
            }
            this.entrySize = Bytes.align8b(16L + valueSize);
            long sizeBytes = this.entrySize * (long)this.keyCapacity;
            this.memStart = Unsafe.malloc(sizeBytes, memoryTag);
            Vect.memset(this.memStart, sizeBytes, 0);
            this.memLimit = this.memStart + sizeBytes;
            this.keySink = new DirectByteSink(16L, memoryTag);
            this.value = new UnorderedVarcharMapValue(valueSize, valueOffsets);
            this.value2 = new UnorderedVarcharMapValue(valueSize, valueOffsets);
            this.value3 = new UnorderedVarcharMapValue(valueSize, valueOffsets);
            this.record = new UnorderedVarcharMapRecord(valueSize, valueOffsets, this.value, valueTypes);
            this.cursor = new UnorderedVarcharMapCursor(this.record, this);
            this.key = new Key();
            this.allocator = new FastGroupByAllocator(allocatorDefaultChunkSize, allocatorMaxChunkSize, false);
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    public static long packHashSizeFlags(long hash, int size, byte flags) {
        assert (size < 0x40000000);
        assert ((flags & 0x3F) == 0);
        int sizeAndFlags = size | flags << 24;
        return (long)sizeAndFlags << 32 | hash & 0xFFFFFFFFL;
    }

    public static long unpackHash(long hashSizeFlags) {
        return hashSizeFlags & 0xFFFFFFFFL;
    }

    @Override
    public void clear() {
        this.free = (int)((double)this.keyCapacity * this.loadFactor);
        this.size = 0;
        this.nResizes = 0;
        Vect.memset(this.memStart, this.memLimit - this.memStart, 0);
        Misc.free(this.allocator);
    }

    @Override
    public void close() {
        if (this.memStart != 0L) {
            this.memLimit = this.memStart = Unsafe.free(this.memStart, this.memLimit - this.memStart, this.memoryTag);
            this.free = 0;
            this.size = 0;
        }
        Misc.free(this.keySink);
        Misc.free(this.allocator);
    }

    @Override
    public MapRecordCursor getCursor() {
        return this.cursor.init(this.memStart, this.memLimit, this.size);
    }

    @Override
    public long getHeapSize() {
        return this.memLimit - this.memStart + this.allocator.allocated();
    }

    @Override
    public int getKeyCapacity() {
        return this.keyCapacity;
    }

    @Override
    public MapRecord getRecord() {
        return this.record;
    }

    @Override
    public boolean isOpen() {
        return this.memStart != 0L;
    }

    @Override
    public void merge(Map srcMap, MapValueMergeFunction mergeFunc) {
        assert (this != srcMap);
        long srcMapSize = srcMap.size();
        if (srcMapSize == 0L) {
            return;
        }
        UnorderedVarcharMap srcVarcharMap = (UnorderedVarcharMap)srcMap;
        block0: for (long srcAddr = srcVarcharMap.memStart; srcAddr < srcVarcharMap.memLimit; srcAddr += this.entrySize) {
            long dstHashSizeFlags;
            long srcHashSizeFlags = Unsafe.getUnsafe().getLong(srcAddr);
            if (srcHashSizeFlags == 0L) continue;
            long srcPtrWithUnstableFlags = Unsafe.getUnsafe().getLong(srcAddr + 8L);
            int srcSize = UnorderedVarcharMap.unpackSize(srcHashSizeFlags);
            long srcHash = UnorderedVarcharMap.unpackHash(srcHashSizeFlags);
            long destAddr = this.getStartAddress(srcHash & this.mask);
            while ((dstHashSizeFlags = Unsafe.getUnsafe().getLong(destAddr)) != 0L) {
                long dstPtrWithUnstableFlags;
                if (dstHashSizeFlags == srcHashSizeFlags && Vect.memeq(srcPtrWithUnstableFlags & Long.MAX_VALUE, (dstPtrWithUnstableFlags = Unsafe.getUnsafe().getLong(destAddr + 8L)) & Long.MAX_VALUE, srcSize)) {
                    mergeFunc.merge(this.valueAt(destAddr), srcVarcharMap.valueAt(srcAddr));
                    continue block0;
                }
                destAddr = this.getNextAddress(destAddr);
            }
            if ((srcPtrWithUnstableFlags & Long.MIN_VALUE) == 0L) {
                Vect.memcpy(destAddr, srcAddr, this.entrySize);
            } else {
                long arenaPtr = this.allocator.malloc(srcSize);
                Vect.memcpy(arenaPtr, srcPtrWithUnstableFlags & Long.MAX_VALUE, srcSize);
                long arenaPtrWithUnstableFlags = arenaPtr | Long.MIN_VALUE;
                Unsafe.getUnsafe().putLong(destAddr, srcHashSizeFlags);
                Unsafe.getUnsafe().putLong(destAddr + 8L, arenaPtrWithUnstableFlags);
                Vect.memcpy(destAddr + 16L, srcAddr + 16L, this.entrySize - 16L);
            }
            ++this.size;
            if (--this.free != 0) continue;
            this.rehash();
        }
    }

    @Override
    public void reopen(int keyCapacity, long heapSize) {
        if (this.memStart == 0L) {
            keyCapacity = (int)((double)keyCapacity / this.loadFactor);
            this.initialKeyCapacity = Math.max(Numbers.ceilPow2(keyCapacity), 16);
            this.restoreInitialCapacity();
        }
    }

    @Override
    public void reopen() {
        if (this.memStart == 0L) {
            this.restoreInitialCapacity();
        }
    }

    @Override
    public void restoreInitialCapacity() {
        if (this.memStart == 0L || this.keyCapacity != this.initialKeyCapacity) {
            this.keyCapacity = this.initialKeyCapacity;
            this.mask = this.keyCapacity - 1;
            long sizeBytes = this.entrySize * (long)this.keyCapacity;
            this.memStart = this.memStart == 0L ? Unsafe.malloc(sizeBytes, this.memoryTag) : Unsafe.realloc(this.memStart, this.memLimit - this.memStart, sizeBytes, this.memoryTag);
            this.memLimit = this.memStart + sizeBytes;
            this.keySink.reopen();
        }
        this.clear();
    }

    @Override
    public void setKeyCapacity(int newKeyCapacity) {
        long requiredCapacity = (long)((double)newKeyCapacity / this.loadFactor);
        if (requiredCapacity > 0x80000000L) {
            throw CairoException.nonCritical().put("map capacity overflow");
        }
        this.rehash(Numbers.ceilPow2((int)requiredCapacity));
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public MapValue valueAt(long startAddress) {
        return this.valueOf(startAddress, false, this.value);
    }

    @Override
    public MapKey withKey() {
        return this.key.init();
    }

    private UnorderedVarcharMapValue asNew(long startAddress, long hash, long keyPtrWithUnstableFlag, int keySize, long keyHashSizeFlags, UnorderedVarcharMapValue value) {
        Unsafe.getUnsafe().putLong(startAddress, keyHashSizeFlags);
        if ((keyPtrWithUnstableFlag & Long.MIN_VALUE) == 0L) {
            Unsafe.getUnsafe().putLong(startAddress + 8L, keyPtrWithUnstableFlag);
        } else {
            long arenaPtr = this.allocator.malloc(keySize);
            Vect.memcpy(arenaPtr, keyPtrWithUnstableFlag & Long.MAX_VALUE, keySize);
            long arenaPtrWithUnstableFlags = arenaPtr | Long.MIN_VALUE;
            Unsafe.getUnsafe().putLong(startAddress + 8L, arenaPtrWithUnstableFlags);
        }
        if (--this.free == 0) {
            long entryPtrWithUnstableFlag;
            long loadedHashSizeFlags;
            this.rehash();
            startAddress = this.getStartAddress(hash & this.mask);
            long ptr = keyPtrWithUnstableFlag & Long.MAX_VALUE;
            while ((loadedHashSizeFlags = Unsafe.getUnsafe().getLong(startAddress)) != keyHashSizeFlags || !Vect.memeq((entryPtrWithUnstableFlag = Unsafe.getUnsafe().getLong(startAddress + 8L)) & Long.MAX_VALUE, ptr, keySize)) {
                startAddress = this.getNextAddress(startAddress);
            }
        }
        ++this.size;
        return this.valueOf(startAddress, true, value);
    }

    private long getNextAddress(long entryAddress) {
        if ((entryAddress += this.entrySize) < this.memLimit) {
            return entryAddress;
        }
        return this.memStart;
    }

    private long getStartAddress(long memStart, long index) {
        return memStart + this.entrySize * index;
    }

    private long getStartAddress(long index) {
        return this.getStartAddress(this.memStart, index);
    }

    private UnorderedVarcharMapValue probe0(long startAddress, long hash, long ptrWithUnstableFlag, int size, long packedHashSizeFlagsToFind, UnorderedVarcharMapValue value) {
        long currentEntryPtr;
        long loadedHashSizeFlags;
        long ptr = ptrWithUnstableFlag & Long.MAX_VALUE;
        do {
            startAddress = this.getNextAddress(startAddress);
            loadedHashSizeFlags = Unsafe.getUnsafe().getLong(startAddress);
            if (loadedHashSizeFlags != 0L) continue;
            return this.asNew(startAddress, hash, ptrWithUnstableFlag, size, packedHashSizeFlagsToFind, value);
        } while (loadedHashSizeFlags != packedHashSizeFlagsToFind || !Vect.memeq(currentEntryPtr = Unsafe.getUnsafe().getLong(startAddress + 8L) & Long.MAX_VALUE, ptr, size));
        return this.valueOf(startAddress, false, value);
    }

    private UnorderedVarcharMapValue probeReadOnly(long startAddress, long ptr, long size, long packedHashSizeFlagsToFind, UnorderedVarcharMapValue value) {
        long currentEntryPtr;
        long loadedHashSizeFlags;
        do {
            startAddress = this.getNextAddress(startAddress);
            loadedHashSizeFlags = Unsafe.getUnsafe().getLong(startAddress);
            if (loadedHashSizeFlags != 0L) continue;
            return null;
        } while (loadedHashSizeFlags != packedHashSizeFlagsToFind || !Vect.memeq(currentEntryPtr = Unsafe.getUnsafe().getLong(startAddress + 8L) & Long.MAX_VALUE, ptr, size));
        return this.valueOf(startAddress, false, value);
    }

    private void rehash() {
        this.rehash((long)this.keyCapacity << 1);
    }

    private void rehash(long newKeyCapacity) {
        if (this.nResizes == this.maxResizes) {
            throw LimitOverflowException.instance().put("limit of ").put(this.maxResizes).put(" resizes exceeded in unordered map");
        }
        if (newKeyCapacity > 0x80000000L) {
            throw CairoException.nonCritical().put("map capacity overflow");
        }
        if (newKeyCapacity <= (long)this.keyCapacity) {
            return;
        }
        long newSizeBytes = this.entrySize * newKeyCapacity;
        long newMemStart = Unsafe.malloc(newSizeBytes, this.memoryTag);
        long newMemLimit = newMemStart + newSizeBytes;
        Vect.memset(newMemStart, newSizeBytes, 0);
        int newMask = (int)newKeyCapacity - 1;
        for (long addr = this.memStart; addr < this.memLimit; addr += this.entrySize) {
            long packedHashSizeFlags = Unsafe.getUnsafe().getLong(addr);
            if (packedHashSizeFlags == 0L) continue;
            int hash = Unsafe.getUnsafe().getInt(addr);
            long newAddr = this.getStartAddress(newMemStart, hash & newMask);
            while (Unsafe.getUnsafe().getLong(newAddr) != 0L) {
                if ((newAddr += this.entrySize) < newMemLimit) continue;
                newAddr = newMemStart;
            }
            Vect.memcpy(newAddr, addr, this.entrySize);
        }
        Unsafe.free(this.memStart, this.memLimit - this.memStart, this.memoryTag);
        this.memStart = newMemStart;
        this.memLimit = newMemStart + newSizeBytes;
        this.mask = newMask;
        this.free += (int)((double)(newKeyCapacity - (long)this.keyCapacity) * this.loadFactor);
        this.keyCapacity = (int)newKeyCapacity;
        ++this.nResizes;
    }

    private UnorderedVarcharMapValue valueOf(long startAddress, boolean newValue, UnorderedVarcharMapValue value) {
        return value.of(startAddress, this.memLimit, newValue);
    }

    static boolean isAscii(byte flags) {
        return (flags & 0xFFFFFF80) != 0;
    }

    static boolean isNull(byte flags) {
        return (flags & 0x40) != 0;
    }

    static boolean isSizeNull(int sizeAndFlags) {
        return (sizeAndFlags & 0x40000000) != 0;
    }

    static byte unpackFlags(long packedHashSizeFlags) {
        return (byte)(packedHashSizeFlags >>> 56);
    }

    static int unpackSize(long packedHashSizeFlags) {
        int sizeAndFlags = (int)(packedHashSizeFlags >>> 32);
        return sizeAndFlags & 0x3FFFFFFF;
    }

    long entrySize() {
        return this.entrySize;
    }

    boolean isZeroKey(long startAddress) {
        long packedHashAndSize = Unsafe.getUnsafe().getLong(startAddress);
        return packedHashAndSize == 0L;
    }

    class Key
    implements MapKey {
        private byte flags;
        private long ptrWithUnstableFlag;
        private int size;

        Key() {
        }

        @Override
        public long commit() {
            return 16L;
        }

        @Override
        public void copyFrom(MapKey srcKey) {
            Key srcVarcharKey = (Key)srcKey;
            this.size = srcVarcharKey.size;
            this.flags = srcVarcharKey.flags;
            if ((srcVarcharKey.ptrWithUnstableFlag & Long.MIN_VALUE) == 0L) {
                this.ptrWithUnstableFlag = srcVarcharKey.ptrWithUnstableFlag;
            } else {
                UnorderedVarcharMap.this.keySink.clear();
                long srcPtr = srcVarcharKey.ptrWithUnstableFlag & Long.MAX_VALUE;
                UnorderedVarcharMap.this.keySink.put(srcPtr, srcPtr + (long)this.size);
                long ptr = UnorderedVarcharMap.this.keySink.ptr();
                this.ptrWithUnstableFlag = ptr | Long.MIN_VALUE;
            }
        }

        @Override
        public MapValue createValue() {
            long hash = Hash.hashMem64(this.ptrWithUnstableFlag & Long.MAX_VALUE, this.size);
            return this.createValue(hash);
        }

        @Override
        public MapValue createValue(long hashCode) {
            long currentPtr;
            long index = hashCode & UnorderedVarcharMap.this.mask;
            long startAddress = UnorderedVarcharMap.this.getStartAddress(index);
            long loadedHashSizeFlags = Unsafe.getUnsafe().getLong(startAddress);
            long currentHashSizeFlags = UnorderedVarcharMap.packHashSizeFlags(hashCode, this.size, this.flags);
            if (loadedHashSizeFlags == 0L) {
                return UnorderedVarcharMap.this.asNew(startAddress, hashCode, this.ptrWithUnstableFlag, this.size, currentHashSizeFlags, UnorderedVarcharMap.this.value);
            }
            if (loadedHashSizeFlags == currentHashSizeFlags && Vect.memeq(currentPtr = Unsafe.getUnsafe().getLong(startAddress + 8L) & Long.MAX_VALUE, this.ptrWithUnstableFlag & Long.MAX_VALUE, this.size)) {
                return UnorderedVarcharMap.this.valueOf(startAddress, false, UnorderedVarcharMap.this.value);
            }
            return UnorderedVarcharMap.this.probe0(startAddress, hashCode, this.ptrWithUnstableFlag, this.size, currentHashSizeFlags, UnorderedVarcharMap.this.value);
        }

        @Override
        public MapValue findValue() {
            return this.findValue(this.ptrWithUnstableFlag, this.size, this.flags, UnorderedVarcharMap.this.value);
        }

        @Override
        public MapValue findValue2() {
            return this.findValue(this.ptrWithUnstableFlag, this.size, this.flags, UnorderedVarcharMap.this.value2);
        }

        @Override
        public MapValue findValue3() {
            return this.findValue(this.ptrWithUnstableFlag, this.size, this.flags, UnorderedVarcharMap.this.value3);
        }

        @Override
        public long hash() {
            return Hash.hashMem64(this.ptrWithUnstableFlag & Long.MAX_VALUE, this.size);
        }

        public Key init() {
            return this;
        }

        @Override
        public void put(Record record, RecordSink sink) {
            sink.copy(record, this);
        }

        @Override
        public void putArray(ArrayView view) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putBin(BinarySequence value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putBool(boolean value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putByte(byte value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putChar(char value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putDate(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putDouble(double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putFloat(float value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putIPv4(int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putInt(int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putInterval(Interval interval) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putLong(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putLong128(long lo, long hi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putLong256(Long256 value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putLong256(long l0, long l1, long l2, long l3) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putRecord(Record value) {
        }

        @Override
        public void putShort(short value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putStr(CharSequence value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putStr(CharSequence value, int lo, int hi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putTimestamp(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putVarchar(Utf8Sequence value) {
            if (value == null) {
                this.size = 0;
                this.ptrWithUnstableFlag = 0L;
                this.flags = (byte)-64;
            } else {
                this.size = value.size();
                if (value.isStable()) {
                    this.ptrWithUnstableFlag = value.ptr();
                } else {
                    UnorderedVarcharMap.this.keySink.clear();
                    if (value.ptr() != -1L) {
                        UnorderedVarcharMap.this.keySink.put(value.ptr(), value.ptr() + (long)this.size);
                    } else {
                        UnorderedVarcharMap.this.keySink.put(value);
                    }
                    long ptr = UnorderedVarcharMap.this.keySink.ptr();
                    this.ptrWithUnstableFlag = ptr | Long.MIN_VALUE;
                }
                this.flags = (byte)(value.isAscii() ? -128 : 0);
            }
            assert (this.size > 0 || (this.flags & 0xFFFFFF80) != 0);
        }

        @Override
        public void skip(int bytes) {
        }

        private MapValue findValue(long ptrWithUnstableFlag, int size, byte flags, UnorderedVarcharMapValue value) {
            long currentPtr;
            long ptr = ptrWithUnstableFlag & Long.MAX_VALUE;
            long hash = Hash.hashMem64(ptr, size);
            long index = hash & UnorderedVarcharMap.this.mask;
            long startAddress = UnorderedVarcharMap.this.getStartAddress(index);
            long loadedHashSizeFlags = Unsafe.getUnsafe().getLong(startAddress);
            if (loadedHashSizeFlags == 0L) {
                return null;
            }
            long packedHashSizeFlags = UnorderedVarcharMap.packHashSizeFlags(hash, size, flags);
            if (loadedHashSizeFlags == packedHashSizeFlags && Vect.memeq(currentPtr = Unsafe.getUnsafe().getLong(startAddress + 8L) & Long.MAX_VALUE, ptr, size)) {
                return UnorderedVarcharMap.this.valueOf(startAddress, false, value);
            }
            return UnorderedVarcharMap.this.probeReadOnly(startAddress, ptr, size, packedHashSizeFlags, value);
        }

        void copyFromStartAddress(long address) {
            long srcPackedHashAndSize = Unsafe.getUnsafe().getLong(address);
            byte srcFlags = UnorderedVarcharMap.unpackFlags(srcPackedHashAndSize);
            int srcSize = UnorderedVarcharMap.unpackSize(srcPackedHashAndSize);
            long srcPtrWithUnstableFlag = Unsafe.getUnsafe().getLong(address + 8L);
            if ((srcPtrWithUnstableFlag & Long.MIN_VALUE) == 0L) {
                this.ptrWithUnstableFlag = srcPtrWithUnstableFlag;
            } else {
                UnorderedVarcharMap.this.keySink.clear();
                long srcPtr = srcPtrWithUnstableFlag & Long.MAX_VALUE;
                UnorderedVarcharMap.this.keySink.put(srcPtr, srcPtr + (long)srcSize);
                long ptr = UnorderedVarcharMap.this.keySink.ptr();
                this.ptrWithUnstableFlag = ptr | Long.MIN_VALUE;
            }
            this.size = srcSize;
            this.flags = srcFlags;
        }
    }
}

