/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.mv;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.EntityColumnFilter;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TableWriterAPI;
import io.questdb.cairo.mv.FixedOffsetIntervalIterator;
import io.questdb.cairo.mv.MatViewDefinition;
import io.questdb.cairo.mv.MatViewGraph;
import io.questdb.cairo.mv.MatViewRefreshSqlExecutionContext;
import io.questdb.cairo.mv.MatViewRefreshTask;
import io.questdb.cairo.mv.MatViewState;
import io.questdb.cairo.mv.MatViewStateStore;
import io.questdb.cairo.mv.MatViewTimerJob;
import io.questdb.cairo.mv.SampleByIntervalIterator;
import io.questdb.cairo.mv.TimeZoneIntervalIterator;
import io.questdb.cairo.mv.WalTxnRangeLoader;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.cairo.wal.WalWriter;
import io.questdb.cairo.wal.seq.SeqTxnTracker;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.RecordToRowCopier;
import io.questdb.griffin.RecordToRowCopierUtils;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.griffin.engine.groupby.TimestampSamplerFactory;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.Job;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.std.QuietCloseable;
import io.questdb.std.datetime.TimeZoneRules;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.datetime.microtime.Timestamps;
import io.questdb.std.str.Path;
import io.questdb.std.str.Sinkable;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MatViewRefreshJob
implements Job,
QuietCloseable {
    private static final Log LOG = LogFactory.getLog(MatViewRefreshJob.class);
    private final ObjList<TableToken> childViewSink = new ObjList();
    private final ObjList<TableToken> childViewSink2 = new ObjList();
    private final EntityColumnFilter columnFilter = new EntityColumnFilter();
    private final CairoConfiguration configuration;
    private final CairoEngine engine;
    private final StringSink errorMsgSink = new StringSink();
    private final FixedOffsetIntervalIterator fixedOffsetIterator = new FixedOffsetIntervalIterator();
    private final MatViewGraph graph;
    private final LongList intervals = new LongList();
    private final MicrosecondClock microsecondClock;
    private final RefreshContext refreshContext = new RefreshContext();
    private final MatViewRefreshSqlExecutionContext refreshSqlExecutionContext;
    private final MatViewRefreshTask refreshTask = new MatViewRefreshTask();
    private final MatViewStateStore stateStore;
    private final TimeZoneIntervalIterator timeZoneIterator = new TimeZoneIntervalIterator();
    private final WalTxnRangeLoader txnRangeLoader;
    private final int workerId;

    public MatViewRefreshJob(int workerId, CairoEngine engine, int sharedQueryWorkerCount) {
        try {
            this.workerId = workerId;
            this.engine = engine;
            this.refreshSqlExecutionContext = new MatViewRefreshSqlExecutionContext(engine, sharedQueryWorkerCount);
            this.graph = engine.getMatViewGraph();
            this.stateStore = engine.getMatViewStateStore();
            this.configuration = engine.getConfiguration();
            this.txnRangeLoader = new WalTxnRangeLoader(this.configuration.getFilesFacade());
            this.microsecondClock = this.configuration.getMicrosecondClock();
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public void close() {
        LOG.info().$("materialized view refresh job closing [workerId=").$(this.workerId).I$();
        Misc.free(this.refreshSqlExecutionContext);
        Misc.free(this.txnRangeLoader);
    }

    @Override
    public boolean run(int workerId, @NotNull Job.RunStatus runStatus) {
        assert (this.workerId == workerId);
        return this.processNotifications();
    }

    private static long approxPartitionMicros(int partitionBy) {
        switch (partitionBy) {
            case 4: {
                return 3600000000L;
            }
            case 0: {
                return 86400000000L;
            }
            case 5: {
                return 604800000000L;
            }
            case 1: {
                return 2592000000000L;
            }
            case 2: {
                return 31536000000000L;
            }
        }
        throw new UnsupportedOperationException("unexpected partition by: " + partitionBy);
    }

    private static long estimateRowsPerBucket(@NotNull TableReader baseTableReader, long bucketMicros) {
        long rows = baseTableReader.size();
        long partitionMicros = MatViewRefreshJob.approxPartitionMicros(baseTableReader.getPartitionedBy());
        int partitionCount = baseTableReader.getPartitionCount();
        if (partitionCount > 0) {
            return Math.max(1L, rows * bucketMicros / (partitionMicros * (long)partitionCount));
        }
        return 1L;
    }

    private static void intersectIntervals(LongList intervals, long lo, long hi) {
        if (intervals != null && intervals.size() > 0) {
            intervals.add(lo, hi);
            IntervalUtils.intersectInPlace(intervals, intervals.size() - 2);
        }
    }

    private static void unionIntervals(LongList intervals, long lo, long hi) {
        if (intervals != null) {
            intervals.add(lo, hi);
            IntervalUtils.unionInPlace(intervals, intervals.size() - 2);
        }
    }

    private boolean checkIfBaseTableDropped(MatViewRefreshTask refreshTask) {
        TableToken baseTableToken = refreshTask.baseTableToken;
        TableToken viewToken = refreshTask.matViewToken;
        if (viewToken == null) {
            assert (baseTableToken != null);
            try {
                this.engine.verifyTableToken(baseTableToken);
            }
            catch (CairoException | TableReferenceOutOfDateException ignore) {
                this.invalidateDependentViews(baseTableToken, "base table is dropped or renamed");
                return true;
            }
        }
        return false;
    }

    private void commitMatView(@NotNull MatViewState viewState, @NotNull WalWriter walWriter, @NotNull RefreshContext refreshContext, @NotNull RecordCursorFactory factory, @NotNull RecordToRowCopier copier, long refreshTriggerTimestamp, long replacementTimestampLo, long replacementTimestampHi) {
        long commitPeriodHi;
        long recordRowCopierMetadataVersion = walWriter.getMetadata().getMetadataVersion();
        long refreshFinishTimestamp = this.microsecondClock.getTicks();
        long l = commitPeriodHi = refreshContext.periodHi != Long.MIN_VALUE ? refreshContext.periodHi : viewState.getLastPeriodHi();
        if (refreshContext.toBaseTxn == -1L) {
            walWriter.commitWithParams(replacementTimestampLo, replacementTimestampHi, (byte)3);
            if (refreshContext.periodHi != Long.MIN_VALUE) {
                walWriter.resetMatViewState(viewState.getLastRefreshBaseTxn(), refreshFinishTimestamp, false, null, commitPeriodHi, viewState.getRefreshIntervals(), viewState.getRefreshIntervalsBaseTxn());
            }
            viewState.rangeRefreshSuccess(factory, copier, recordRowCopierMetadataVersion, refreshFinishTimestamp, refreshTriggerTimestamp, commitPeriodHi);
        } else {
            walWriter.commitMatView(refreshContext.toBaseTxn, refreshFinishTimestamp, commitPeriodHi, replacementTimestampLo, replacementTimestampHi);
            viewState.refreshSuccess(factory, copier, recordRowCopierMetadataVersion, refreshFinishTimestamp, refreshTriggerTimestamp, refreshContext.toBaseTxn, commitPeriodHi);
        }
    }

    private void enqueueInvalidateDependentViews(TableToken viewToken, String invalidationReason) {
        this.childViewSink2.clear();
        this.graph.getDependentViews(viewToken, this.childViewSink2);
        int n = this.childViewSink2.size();
        for (int v = 0; v < n; ++v) {
            this.stateStore.enqueueInvalidate(this.childViewSink2.get(v), invalidationReason);
        }
    }

    private RefreshContext findRefreshIntervals(@NotNull TableReader baseTableReader, @NotNull MatViewDefinition viewDefinition, @NotNull MatViewState viewState, @NotNull WalWriter walWriter, long lastRefreshTxn) throws SqlException {
        return this.findRefreshIntervals(baseTableReader, viewDefinition, viewState, walWriter, lastRefreshTxn, Long.MIN_VALUE, Long.MIN_VALUE);
    }

    private RefreshContext findRefreshIntervals(@NotNull TableReader baseTableReader, @NotNull MatViewDefinition viewDefinition, @NotNull MatViewState viewState, @NotNull WalWriter walWriter, long lastRefreshTxn, long rangeFrom, long rangeTo) throws SqlException {
        this.refreshContext.clear();
        long lastTxn = baseTableReader.getSeqTxn();
        TableToken baseTableToken = baseTableReader.getTableToken();
        TableToken viewToken = viewDefinition.getMatViewToken();
        long now = this.microsecondClock.getTicks();
        boolean rangeRefresh = rangeTo != Long.MIN_VALUE;
        boolean incrementalRefresh = lastRefreshTxn != Long.MIN_VALUE;
        LongList refreshIntervals = null;
        long minTs = Long.MAX_VALUE;
        long maxTs = Long.MIN_VALUE;
        if (incrementalRefresh) {
            if (lastRefreshTxn > -1L) {
                refreshIntervals = this.updateRefreshIntervals0(lastTxn, baseTableToken, viewDefinition, viewState, walWriter);
                if (refreshIntervals != null) {
                    if (refreshIntervals.size() > 0) {
                        minTs = refreshIntervals.getQuick(0);
                        maxTs = refreshIntervals.getQuick(refreshIntervals.size() - 1);
                    }
                } else {
                    minTs = baseTableReader.getMinTimestamp();
                    maxTs = baseTableReader.getMaxTimestamp();
                }
            } else {
                minTs = baseTableReader.getMinTimestamp();
                maxTs = baseTableReader.getMaxTimestamp();
            }
            this.refreshContext.toBaseTxn = lastTxn;
        } else if (rangeRefresh) {
            if (rangeFrom == Long.MIN_VALUE) {
                long periodLo = viewState.getLastPeriodHi();
                if (periodLo == Long.MIN_VALUE) {
                    periodLo = baseTableReader.getMinTimestamp();
                }
                if (periodLo < rangeTo) {
                    minTs = periodLo;
                    maxTs = rangeTo;
                    this.refreshContext.periodHi = rangeTo + 1L;
                }
            } else {
                minTs = Math.max(rangeFrom, baseTableReader.getMinTimestamp());
                maxTs = Math.min(rangeTo, baseTableReader.getMaxTimestamp());
            }
        } else {
            minTs = baseTableReader.getMinTimestamp();
            maxTs = baseTableReader.getMaxTimestamp();
            this.refreshContext.toBaseTxn = lastTxn;
        }
        if (!rangeRefresh) {
            int refreshLimitHoursOrMonths;
            if (viewDefinition.getPeriodLength() > 0) {
                TimestampSampler periodSampler = viewDefinition.getPeriodSampler();
                if (periodSampler == null) {
                    periodSampler = TimestampSamplerFactory.getInstance((long)viewDefinition.getPeriodLength(), viewDefinition.getPeriodLengthUnit(), -1);
                    viewDefinition.setPeriodSampler(periodSampler);
                }
                periodSampler.setStart(viewDefinition.getTimerStart());
                long delay = MatViewTimerJob.periodDelayMicros(viewDefinition.getPeriodDelay(), viewDefinition.getPeriodDelayUnit());
                long nowLocal = viewDefinition.getTimerTzRules() != null ? now + viewDefinition.getTimerTzRules().getOffset(now) : now;
                long periodHiLocal = periodSampler.round(nowLocal - delay) - 1L;
                long periodHi = viewDefinition.getTimerTzRules() != null ? periodHiLocal - viewDefinition.getTimerTzRules().getOffset(periodHiLocal) : periodHiLocal;
                MatViewRefreshJob.intersectIntervals(refreshIntervals, Long.MIN_VALUE, periodHi);
                maxTs = Math.min(maxTs, periodHi);
                if (incrementalRefresh) {
                    long periodLo = viewState.getLastPeriodHi();
                    if (periodLo == Long.MIN_VALUE) {
                        periodLo = baseTableReader.getMinTimestamp();
                    }
                    if (periodLo < periodHi) {
                        if (refreshIntervals != null) {
                            MatViewRefreshJob.unionIntervals(refreshIntervals, periodLo, periodHi);
                            minTs = refreshIntervals.getQuick(0);
                            maxTs = refreshIntervals.getQuick(refreshIntervals.size() - 1);
                        } else {
                            minTs = periodLo;
                            maxTs = periodHi;
                        }
                        this.refreshContext.periodHi = periodHi + 1L;
                    }
                } else {
                    this.refreshContext.periodHi = periodHi + 1L;
                }
            }
            if ((refreshLimitHoursOrMonths = viewDefinition.getRefreshLimitHoursOrMonths()) != 0) {
                minTs = refreshLimitHoursOrMonths > 0 ? Math.max(minTs, now - 3600000000L * (long)refreshLimitHoursOrMonths) : Math.max(minTs, Timestamps.addMonths(now, refreshLimitHoursOrMonths));
                MatViewRefreshJob.intersectIntervals(refreshIntervals, minTs, Long.MAX_VALUE);
            }
        }
        if (minTs <= maxTs) {
            TimestampSampler timestampSampler = viewDefinition.getTimestampSampler();
            long rowsPerBucket = MatViewRefreshJob.estimateRowsPerBucket(baseTableReader, timestampSampler.getApproxBucketSize());
            int rowsPerQuery = this.configuration.getMatViewRowsPerQueryEstimate();
            int step = Math.max(1, (int)((long)rowsPerQuery / rowsPerBucket));
            SampleByIntervalIterator intervalIterator = this.intervalIterator(timestampSampler, viewDefinition.getTzRules(), viewDefinition.getFixedOffset(), refreshIntervals, minTs, maxTs, step);
            long iteratorMinTs = intervalIterator.getMinTimestamp();
            long iteratorMaxTs = intervalIterator.getMaxTimestamp();
            LOG.info().$("refreshing materialized view [view=").$(viewToken).$(", baseTable=").$(baseTableToken).$(", fromTxn=").$(lastRefreshTxn).$(", toTxn=").$(this.refreshContext.toBaseTxn).$(", periodHi=").$ts(this.refreshContext.periodHi).$(", iteratorMinTs>=").$ts(iteratorMinTs).$(", iteratorMaxTs<").$ts(iteratorMaxTs).I$();
            this.refreshContext.intervalIterator = intervalIterator;
        } else {
            LOG.info().$("no intervals to refresh in materialized view [view=").$(viewToken).$(", baseTable=").$(baseTableToken).$(", fromTxn=").$(lastRefreshTxn).$(", toTxn=").$(this.refreshContext.toBaseTxn).$(", periodHi=").$ts(this.refreshContext.periodHi).I$();
        }
        return this.refreshContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fullRefresh(MatViewRefreshTask refreshTask) {
        TableToken viewToken = refreshTask.matViewToken;
        assert (viewToken != null);
        long refreshTriggerTimestamp = refreshTask.refreshTriggerTimestamp;
        MatViewState viewState = this.stateStore.getViewState(viewToken);
        if (viewState == null || viewState.isDropped()) {
            return false;
        }
        if (!viewState.tryLock()) {
            LOG.debug().$("could not lock materialized view for full refresh, will retry [view=").$(viewToken).I$();
            viewState.markAsPendingInvalidation();
            this.stateStore.enqueueFullRefresh(viewToken);
            return false;
        }
        MatViewDefinition viewDefinition = viewState.getViewDefinition();
        try (WalWriter walWriter = this.engine.getWalWriter(viewToken);){
            TableToken baseTableToken = this.verifyBaseTableToken(viewDefinition, viewState, walWriter);
            if (baseTableToken == null) {
                boolean bl = false;
                return bl;
            }
            if (!baseTableToken.isWal()) {
                this.refreshFailState(viewDefinition, viewState, walWriter, "base table is not a WAL table");
                boolean bl = false;
                return bl;
            }
            try (TableReader baseTableReader = this.engine.getReader(baseTableToken);){
                this.engine.detachReader(baseTableReader);
                this.refreshSqlExecutionContext.of(baseTableReader);
                try {
                    walWriter.truncateSoft();
                    this.resetInvalidState(viewState, walWriter);
                    RefreshContext refreshContext = this.findRefreshIntervals(baseTableReader, viewDefinition, viewState, walWriter, Long.MIN_VALUE);
                    this.insertAsSelect(viewDefinition, viewState, walWriter, refreshContext, refreshTriggerTimestamp);
                }
                finally {
                    this.refreshSqlExecutionContext.clearReader();
                    this.engine.attachReader(baseTableReader);
                }
            }
            catch (Throwable th) {
                LOG.error().$("could not perform full refresh [view=").$(viewToken).$(", baseTable=").$(baseTableToken).$(", ex=").$(th).I$();
                this.refreshFailState(viewDefinition, viewState, walWriter, th);
                boolean bl = false;
                if (walWriter != null) {
                    walWriter.close();
                }
                viewState.incrementRefreshSeq();
                viewState.unlock();
                viewState.tryCloseIfDropped();
                return bl;
            }
        }
        catch (Throwable th) {
            if (this.handleErrorRetryRefresh(th, viewToken, this.stateStore, refreshTask)) {
                boolean bl = false;
                return bl;
            }
            LOG.error().$("could not perform full refresh, unexpected error [view=").$(viewToken).$(", ex=").$(th).I$();
            this.refreshFailState(viewDefinition, viewState, null, th);
            boolean bl = false;
            return bl;
        }
        finally {
            viewState.incrementRefreshSeq();
            viewState.unlock();
            viewState.tryCloseIfDropped();
        }
        if (viewDefinition.getRefreshType() == 0) {
            this.stateStore.enqueueIncrementalRefresh(viewToken);
        }
        return true;
    }

    private RecordToRowCopier getRecordToRowCopier(TableWriterAPI tableWriter, RecordCursorFactory factory, SqlCompiler compiler) throws SqlException {
        this.columnFilter.of(factory.getMetadata().getColumnCount());
        return RecordToRowCopierUtils.generateCopier(compiler.getAsm(), factory.getMetadata(), tableWriter.getMetadata(), this.columnFilter);
    }

    private boolean handleErrorRetryRefresh(Throwable th, TableToken viewToken, @Nullable MatViewStateStore stateStore, @Nullable MatViewRefreshTask refreshTask) {
        TableToken updatedToken;
        CairoException ex;
        if (th instanceof CairoException && (ex = (CairoException)th).isTableDoesNotExist() && (updatedToken = this.engine.getUpdatedTableToken(viewToken)) != null && updatedToken != viewToken) {
            if (stateStore != null) {
                if (refreshTask == null || refreshTask.operation == 0) {
                    stateStore.enqueueIncrementalRefresh(updatedToken);
                } else if (refreshTask.operation == 1) {
                    stateStore.enqueueFullRefresh(updatedToken);
                } else if (refreshTask.operation == 2) {
                    stateStore.enqueueRangeRefresh(updatedToken, refreshTask.rangeFrom, refreshTask.rangeTo);
                } else {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean incrementalRefresh(MatViewRefreshTask refreshTask) {
        TableToken baseTableToken = refreshTask.baseTableToken;
        TableToken viewToken = refreshTask.matViewToken;
        long refreshTriggerTimestamp = refreshTask.refreshTriggerTimestamp;
        if (viewToken == null) {
            return this.refreshDependentViewsIncremental(baseTableToken, this.graph, this.stateStore, refreshTriggerTimestamp);
        }
        return this.refreshIncremental(viewToken, this.stateStore, refreshTriggerTimestamp);
    }

    private boolean insertAsSelect(@NotNull MatViewDefinition viewDefinition, @NotNull MatViewState viewState, @NotNull WalWriter walWriter, @NotNull RefreshContext refreshContext, long refreshTriggerTimestamp) {
        assert (viewState.isLocked());
        int maxRetries = this.configuration.getMatViewMaxRefreshRetries();
        long oomRetryTimeout = this.configuration.getMatViewRefreshOomRetryTimeout();
        long batchSize = this.configuration.getMatViewInsertAsSelectBatchSize();
        RecordCursorFactory factory = null;
        long refreshStartTimestamp = this.microsecondClock.getTicks();
        viewState.setLastRefreshStartTimestamp(refreshStartTimestamp);
        TableToken viewTableToken = viewDefinition.getMatViewToken();
        SampleByIntervalIterator intervalIterator = refreshContext.intervalIterator;
        if (intervalIterator == null) {
            if (refreshContext.toBaseTxn != -1L || refreshContext.periodHi != Long.MIN_VALUE) {
                long commitBaseTxn = refreshContext.toBaseTxn != -1L ? refreshContext.toBaseTxn : viewState.getLastRefreshBaseTxn();
                long commitPeriodHi = refreshContext.periodHi != Long.MIN_VALUE ? refreshContext.periodHi : viewState.getLastPeriodHi();
                this.refreshSuccessNoRows(viewState, walWriter, this.microsecondClock.getTicks(), refreshTriggerTimestamp, commitBaseTxn, commitPeriodHi);
                return true;
            }
            return false;
        }
        int intervalStep = intervalIterator.getStep();
        try {
            factory = viewState.acquireRecordFactory();
            RecordToRowCopier copier = viewState.getRecordToRowCopier();
            for (int i = 0; i <= maxRetries; ++i) {
                try {
                    if (factory == null) {
                        String viewSql = viewDefinition.getMatViewSql();
                        try (SqlCompiler compiler = this.engine.getSqlCompiler();){
                            LOG.info().$("compiling materialized view [view=").$(viewTableToken).$(", attempt=").$(i).I$();
                            CompiledQuery compiledQuery = compiler.compile(viewSql, this.refreshSqlExecutionContext);
                            assert (compiledQuery.getType() == 1);
                            factory = compiledQuery.getRecordCursorFactory();
                            if (copier == null || walWriter.getMetadata().getMetadataVersion() != viewState.getRecordRowCopierMetadataVersion()) {
                                copier = this.getRecordToRowCopier(walWriter, factory, compiler);
                            }
                        }
                        catch (SqlException e) {
                            factory = Misc.free(factory);
                            LOG.error().$("could not compile materialized view [view=").$(viewTableToken).$(", sql=").$(viewSql).$(", errorPos=").$(e.getPosition()).$(", attempt=").$(i).$(", error=").$safe(e.getFlyweightMessage()).I$();
                            this.refreshFailState(viewDefinition, viewState, walWriter, e);
                            return false;
                        }
                    }
                    assert (factory != null);
                    assert (copier != null);
                    String timestampName = walWriter.getMetadata().getColumnName(walWriter.getMetadata().getTimestampIndex());
                    int cursorTimestampIndex = factory.getMetadata().getColumnIndex(timestampName);
                    assert (cursorTimestampIndex > -1);
                    long commitTarget = batchSize;
                    long rowCount = 0L;
                    intervalIterator.toTop(intervalStep);
                    long replacementTimestampLo = Long.MIN_VALUE;
                    long replacementTimestampHi = Long.MIN_VALUE;
                    while (intervalIterator.next()) {
                        this.refreshSqlExecutionContext.setRange(intervalIterator.getTimestampLo(), intervalIterator.getTimestampHi());
                        if (replacementTimestampHi != intervalIterator.getTimestampLo()) {
                            if (replacementTimestampHi > replacementTimestampLo) {
                                walWriter.commitWithParams(replacementTimestampLo, replacementTimestampHi, (byte)3);
                                commitTarget = rowCount + batchSize;
                            }
                            replacementTimestampLo = intervalIterator.getTimestampLo();
                        }
                        replacementTimestampHi = intervalIterator.getTimestampHi();
                        RecordCursor cursor = factory.getCursor(this.refreshSqlExecutionContext);
                        try {
                            Record record = cursor.getRecord();
                            while (cursor.hasNext()) {
                                long timestamp = record.getTimestamp(cursorTimestampIndex);
                                assert (timestamp >= replacementTimestampLo && timestamp < replacementTimestampHi) : "timestamp out of range [expected: " + Timestamps.toUSecString(replacementTimestampLo) + ", " + Timestamps.toUSecString(replacementTimestampHi) + "), actual: " + Timestamps.toUSecString(timestamp);
                                TableWriter.Row row = walWriter.newRow(timestamp);
                                copier.copy(record, row);
                                row.append();
                                ++rowCount;
                            }
                            if (rowCount < commitTarget) continue;
                            if (intervalIterator.isLast()) {
                                this.commitMatView(viewState, walWriter, refreshContext, factory, copier, refreshTriggerTimestamp, replacementTimestampLo, replacementTimestampHi);
                            } else {
                                walWriter.commitWithParams(replacementTimestampLo, replacementTimestampHi, (byte)3);
                            }
                            replacementTimestampLo = replacementTimestampHi;
                            commitTarget = rowCount + batchSize;
                        }
                        finally {
                            if (cursor == null) continue;
                            cursor.close();
                        }
                    }
                    if (replacementTimestampHi > replacementTimestampLo) {
                        this.commitMatView(viewState, walWriter, refreshContext, factory, copier, refreshTriggerTimestamp, replacementTimestampLo, replacementTimestampHi);
                    }
                    break;
                }
                catch (TableReferenceOutOfDateException e) {
                    factory = Misc.free(factory);
                    if (i != maxRetries) continue;
                    LOG.info().$("base table is under heavy DDL changes, will retry refresh later [view=").$(viewTableToken).$(", totalAttempts=").$(maxRetries).$(", msg=").$safe(e.getFlyweightMessage()).I$();
                    this.stateStore.enqueueIncrementalRefresh(viewTableToken);
                    return false;
                }
                catch (Throwable th) {
                    factory = Misc.free(factory);
                    if (th instanceof CairoException && CairoException.isCairoOomError(th) && i < maxRetries && intervalStep > 1) {
                        LOG.info().$("query failed with out-of-memory, retrying with a reduced intervalStep [view=").$(viewTableToken).$(", intervalStep=").$(intervalStep /= 2).$(", error=").$safe(((CairoException)th).getFlyweightMessage()).I$();
                        Os.sleep(oomRetryTimeout);
                        continue;
                    }
                    throw th;
                }
            }
        }
        catch (Throwable th) {
            Misc.free(factory);
            LOG.error().$("could not refresh materialized view [view=").$(viewTableToken).$(", ex=").$(th).I$();
            this.refreshFailState(viewDefinition, viewState, walWriter, th);
            return false;
        }
        return true;
    }

    private SampleByIntervalIterator intervalIterator(@NotNull TimestampSampler sampler, @Nullable TimeZoneRules tzRules, long fixedOffset, @Nullable LongList refreshIntervals, long minTs, long maxTs, int step) {
        if (tzRules == null || tzRules.hasFixedOffset()) {
            long fixedTzOffset = tzRules != null ? tzRules.getOffset(0L) : 0L;
            return this.fixedOffsetIterator.of(sampler, fixedOffset - fixedTzOffset, refreshIntervals, minTs, maxTs, step);
        }
        return this.timeZoneIterator.of(sampler, tzRules, fixedOffset, refreshIntervals, minTs, maxTs, step);
    }

    private void invalidate(MatViewRefreshTask refreshTask) {
        String invalidationReason = refreshTask.invalidationReason;
        if (refreshTask.isBaseTableTask()) {
            this.invalidateDependentViews(refreshTask.baseTableToken, invalidationReason);
        } else {
            this.invalidateView(refreshTask.matViewToken, invalidationReason, true);
        }
    }

    private void invalidateDependentViews(TableToken baseTableToken, String invalidationReason) {
        this.childViewSink.clear();
        this.graph.getDependentViews(baseTableToken, this.childViewSink);
        int n = this.childViewSink.size();
        for (int v = 0; v < n; ++v) {
            TableToken viewToken = this.childViewSink.get(v);
            this.invalidateView(viewToken, invalidationReason, false);
        }
        this.stateStore.notifyBaseInvalidated(baseTableToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateView(TableToken viewToken, String invalidationReason, boolean force) {
        MatViewState viewState = this.stateStore.getViewState(viewToken);
        if (viewState != null && !viewState.isDropped() && !viewState.isInvalid()) {
            block14: {
                if (!viewState.tryLock()) {
                    LOG.debug().$("skipping materialized view invalidation, locked by another refresh run [view=").$(viewToken).I$();
                    viewState.markAsPendingInvalidation();
                    this.stateStore.enqueueInvalidate(viewToken, invalidationReason);
                    return;
                }
                try {
                    if (!force && viewState.getLastRefreshBaseTxn() == -1L) break block14;
                    while (true) {
                        viewToken = this.engine.getUpdatedTableToken(viewToken);
                        try (WalWriter walWriter = this.engine.getWalWriter(viewToken);){
                            long invalidationTimestamp = this.microsecondClock.getTicks();
                            LOG.error().$("marking materialized view as invalid [view=").$(viewToken).$(", reason=").$safe(invalidationReason).$(", ts=").$ts(invalidationTimestamp).I$();
                            this.setInvalidState(viewState, walWriter, invalidationReason, invalidationTimestamp);
                        }
                        catch (CairoException ex) {
                            if (this.handleErrorRetryRefresh(ex, viewToken, null, null)) continue;
                            throw ex;
                        }
                        break;
                    }
                }
                finally {
                    viewState.unlock();
                    viewState.tryCloseIfDropped();
                }
            }
            this.enqueueInvalidateDependentViews(viewToken, "base materialized view is invalidated");
        }
    }

    private boolean processNotifications() {
        boolean refreshed = false;
        block7: while (this.stateStore.tryDequeueRefreshTask(this.refreshTask)) {
            if (this.checkIfBaseTableDropped(this.refreshTask)) continue;
            int operation = this.refreshTask.operation;
            switch (operation) {
                case 0: {
                    refreshed |= this.incrementalRefresh(this.refreshTask);
                    continue block7;
                }
                case 2: {
                    refreshed |= this.rangeRefresh(this.refreshTask);
                    continue block7;
                }
                case 1: {
                    refreshed |= this.fullRefresh(this.refreshTask);
                    continue block7;
                }
                case 3: {
                    this.invalidate(this.refreshTask);
                    continue block7;
                }
                case 4: {
                    this.updateRefreshIntervals(this.refreshTask);
                    continue block7;
                }
            }
            throw new RuntimeException("unexpected operation: " + operation);
        }
        return refreshed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rangeRefresh(MatViewRefreshTask refreshTask) {
        TableToken viewToken = refreshTask.matViewToken;
        assert (viewToken != null);
        long refreshTriggerTimestamp = refreshTask.refreshTriggerTimestamp;
        long rangeFrom = refreshTask.rangeFrom;
        long rangeTo = refreshTask.rangeTo;
        MatViewState viewState = this.stateStore.getViewState(viewToken);
        if (viewState == null || viewState.isPendingInvalidation() || viewState.isInvalid() || viewState.isDropped()) {
            return false;
        }
        if (!viewState.tryLock()) {
            LOG.debug().$("could not lock materialized view for range refresh, will retry [view=").$(viewToken).$(", from=").$ts(rangeFrom).$(", to=").$ts(rangeTo).I$();
            this.stateStore.enqueueRangeRefresh(viewToken, rangeFrom, rangeTo);
            return false;
        }
        MatViewDefinition viewDefinition = viewState.getViewDefinition();
        try {
            WalWriter walWriter = this.engine.getWalWriter(viewToken);
            try {
                TableToken baseTableToken;
                String baseTableName = viewDefinition.getBaseTableName();
                try {
                    baseTableToken = this.engine.verifyTableName(viewDefinition.getBaseTableName());
                }
                catch (CairoException e) {
                    LOG.error().$("could not perform range refresh, could not verify base table [view=").$(viewToken).$(", from=").$ts(rangeFrom).$(", to=").$ts(rangeTo).$(", baseTableName=").$(baseTableName).$(", errno=").$(e.getErrno()).$(", errorMsg=").$safe(e.getFlyweightMessage()).I$();
                    this.refreshFailState(viewDefinition, viewState, walWriter, e);
                    boolean bl = false;
                    if (walWriter != null) {
                        walWriter.close();
                    }
                    viewState.unlock();
                    viewState.tryCloseIfDropped();
                    return bl;
                }
                if (!baseTableToken.isWal()) {
                    this.refreshFailState(viewDefinition, viewState, walWriter, "base table is not a WAL table");
                    boolean e = false;
                    return e;
                }
                try (TableReader baseTableReader = this.engine.getReader(baseTableToken);){
                    this.engine.detachReader(baseTableReader);
                    this.refreshSqlExecutionContext.of(baseTableReader);
                    try {
                        RefreshContext refreshContext = this.findRefreshIntervals(baseTableReader, viewDefinition, viewState, walWriter, Long.MIN_VALUE, rangeFrom, rangeTo);
                        this.insertAsSelect(viewDefinition, viewState, walWriter, refreshContext, refreshTriggerTimestamp);
                    }
                    finally {
                        this.refreshSqlExecutionContext.clearReader();
                        this.engine.attachReader(baseTableReader);
                    }
                }
                catch (Throwable th) {
                    LOG.error().$("could not perform full refresh [view=").$(viewToken).$(", baseTable=").$(baseTableToken).$(", ex=").$(th).I$();
                    this.refreshFailState(viewDefinition, viewState, walWriter, th);
                    boolean bl = false;
                    if (walWriter != null) {
                        walWriter.close();
                    }
                    viewState.unlock();
                    viewState.tryCloseIfDropped();
                    return bl;
                }
            }
            finally {
                if (walWriter != null) {
                    try {
                        walWriter.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (Throwable th) {
            if (this.handleErrorRetryRefresh(th, viewToken, this.stateStore, refreshTask)) {
                boolean bl = false;
                return bl;
            }
            LOG.error().$("could not perform range refresh, unexpected error [view=").$(viewToken).$(", ex=").$(th).I$();
            this.refreshFailState(viewDefinition, viewState, null, th);
            boolean bl = false;
            return bl;
        }
        finally {
            viewState.unlock();
            viewState.tryCloseIfDropped();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refreshDependentViewsIncremental(TableToken baseTableToken, MatViewGraph graph, MatViewStateStore stateStore, long refreshTriggerTimestamp) {
        assert (baseTableToken.isWal());
        boolean refreshed = false;
        SeqTxnTracker baseSeqTracker = this.engine.getTableSequencerAPI().getTxnTracker(baseTableToken);
        long minRefreshToTxn = baseSeqTracker.getWriterTxn();
        this.childViewSink.clear();
        graph.getDependentViews(baseTableToken, this.childViewSink);
        int n = this.childViewSink.size();
        for (int v = 0; v < n; ++v) {
            TableToken viewToken = this.childViewSink.get(v);
            MatViewState viewState = stateStore.getViewState(viewToken);
            if (viewState == null || viewState.isPendingInvalidation() || viewState.isInvalid() || viewState.isDropped()) continue;
            MatViewDefinition viewDefinition = viewState.getViewDefinition();
            if (viewDefinition.getRefreshType() != 0) {
                viewState.incrementRefreshIntervalsSeq();
                continue;
            }
            if (!viewState.tryLock()) {
                LOG.debug().$("skipping materialized view refresh, locked by another refresh run [view=").$(viewToken).I$();
                stateStore.enqueueIncrementalRefresh(viewToken);
                continue;
            }
            try (WalWriter walWriter = this.engine.getWalWriter(viewToken);){
                try {
                    refreshed |= this.refreshIncremental0(baseTableToken, viewDefinition, viewState, walWriter, refreshTriggerTimestamp);
                }
                catch (Throwable th) {
                    this.refreshFailState(viewDefinition, viewState, walWriter, th);
                }
                continue;
            }
            catch (Throwable th) {
                if (this.handleErrorRetryRefresh(th, viewToken, stateStore, null)) continue;
                LOG.error().$("could not perform incremental refresh, unexpected error [view=").$(viewToken).$(", ex=").$(th).I$();
                this.refreshFailState(viewDefinition, viewState, null, th);
                continue;
            }
            finally {
                viewState.incrementRefreshSeq();
                viewState.unlock();
                viewState.tryCloseIfDropped();
            }
        }
        this.refreshTask.clear();
        this.refreshTask.baseTableToken = baseTableToken;
        this.refreshTask.operation = 0;
        stateStore.notifyBaseRefreshed(this.refreshTask, minRefreshToTxn);
        if (refreshed) {
            LOG.info().$("refreshed materialized views dependent on [baseTable=").$(baseTableToken).I$();
        }
        return refreshed;
    }

    private void refreshFailState(@NotNull MatViewDefinition viewDefinition, @NotNull MatViewState viewState, @Nullable WalWriter walWriter, CharSequence errorMessage) {
        viewState.refreshFail(this.microsecondClock.getTicks(), errorMessage);
        if (walWriter != null) {
            walWriter.resetMatViewState(viewState.getLastRefreshBaseTxn(), viewState.getLastRefreshFinishTimestamp(), true, errorMessage, viewState.getLastPeriodHi(), viewState.getRefreshIntervals(), viewState.getRefreshIntervalsBaseTxn());
        }
        this.enqueueInvalidateDependentViews(viewDefinition.getMatViewToken(), "base materialized view refresh failed");
    }

    private void refreshFailState(@NotNull MatViewDefinition viewDefinition, @NotNull MatViewState viewState, @Nullable WalWriter walWriter, @NotNull Throwable th) {
        this.errorMsgSink.clear();
        if (th instanceof Sinkable) {
            ((Sinkable)((Object)th)).toSink(this.errorMsgSink);
        } else {
            this.errorMsgSink.put(th.getMessage());
        }
        this.refreshFailState(viewDefinition, viewState, walWriter, this.errorMsgSink);
    }

    /*
     * Exception decompiling
     */
    private boolean refreshIncremental(@NotNull TableToken viewToken, MatViewStateStore stateStore, long refreshTriggerTimestamp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refreshIncremental0(@NotNull TableToken baseTableToken, @NotNull MatViewDefinition viewDefinition, @NotNull MatViewState viewState, @NotNull WalWriter walWriter, long refreshTriggerTimestamp) throws SqlException {
        assert (viewState.isLocked());
        try (TableReader baseTableReader = this.engine.getReader(baseTableToken);){
            long fromBaseTxn = viewState.getLastRefreshBaseTxn();
            long toBaseTxn = baseTableReader.getSeqTxn();
            if (fromBaseTxn > toBaseTxn) {
                TableToken viewToken = viewDefinition.getMatViewToken();
                throw CairoException.nonCritical().put("unexpected txn numbers, base table may have been renamed [view=").put(viewToken.getTableName()).put(", fromBaseTxn=").put(fromBaseTxn).put(", toBaseTxn=").put(toBaseTxn).put(']');
            }
            if (viewDefinition.getPeriodLength() == 0 && fromBaseTxn > -1L && fromBaseTxn == toBaseTxn) {
                boolean viewToken = false;
                return viewToken;
            }
            this.engine.detachReader(baseTableReader);
            this.refreshSqlExecutionContext.of(baseTableReader);
            try {
                RefreshContext refreshContext = this.findRefreshIntervals(baseTableReader, viewDefinition, viewState, walWriter, fromBaseTxn);
                boolean bl = this.insertAsSelect(viewDefinition, viewState, walWriter, refreshContext, refreshTriggerTimestamp);
                this.refreshSqlExecutionContext.clearReader();
                this.engine.attachReader(baseTableReader);
                return bl;
            }
            catch (Throwable throwable) {
                this.refreshSqlExecutionContext.clearReader();
                this.engine.attachReader(baseTableReader);
                throw throwable;
            }
        }
    }

    private void refreshSuccessNoRows(MatViewState viewState, @Nullable WalWriter walWriter, long refreshFinishedTimestamp, long refreshTriggeredTimestamp, long baseTableTxn, long periodHi) {
        viewState.refreshSuccessNoRows(refreshFinishedTimestamp, refreshTriggeredTimestamp, baseTableTxn, periodHi);
        if (walWriter != null) {
            walWriter.resetMatViewState(baseTableTxn, refreshFinishedTimestamp, false, null, periodHi, null, -1L);
        }
    }

    private void resetInvalidState(MatViewState viewState, WalWriter walWriter) {
        viewState.markAsValid();
        viewState.setLastRefreshBaseTableTxn(-1L);
        viewState.setRefreshIntervalsBaseTxn(-1L);
        viewState.getRefreshIntervals().clear();
        viewState.setLastRefreshTimestamp(Long.MIN_VALUE);
        viewState.setLastPeriodHi(Long.MIN_VALUE);
        walWriter.resetMatViewState(viewState.getLastRefreshBaseTxn(), viewState.getLastRefreshFinishTimestamp(), false, null, viewState.getLastPeriodHi(), null, -1L);
    }

    private void setInvalidState(MatViewState viewState, WalWriter walWriter, CharSequence invalidationReason, long invalidationTimestamp) {
        viewState.markAsInvalid(invalidationReason);
        viewState.setLastRefreshTimestamp(invalidationTimestamp);
        viewState.setLastRefreshStartTimestamp(invalidationTimestamp);
        walWriter.resetMatViewState(viewState.getLastRefreshBaseTxn(), viewState.getLastRefreshFinishTimestamp(), true, invalidationReason, viewState.getLastPeriodHi(), viewState.getRefreshIntervals(), viewState.getRefreshIntervalsBaseTxn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRefreshIntervals(@NotNull MatViewRefreshTask refreshTask) {
        assert (refreshTask.matViewToken != null);
        TableToken viewToken = refreshTask.matViewToken;
        MatViewState viewState = this.stateStore.getViewState(viewToken);
        if (!(viewState == null || viewState.isPendingInvalidation() || viewState.isInvalid() || viewState.isDropped())) {
            if (!viewState.tryLock()) {
                LOG.debug().$("skipping refresh intervals update, locked by a refresh run [view=").$(viewToken).I$();
                this.stateStore.enqueueUpdateRefreshIntervals(viewToken);
                return;
            }
            MatViewDefinition viewDefinition = viewState.getViewDefinition();
            try (WalWriter walWriter = this.engine.getWalWriter(viewToken);){
                TableToken baseTableToken = this.verifyBaseTableToken(viewDefinition, viewState, walWriter);
                if (baseTableToken == null) {
                    return;
                }
                SeqTxnTracker baseSeqTracker = this.engine.getTableSequencerAPI().getTxnTracker(baseTableToken);
                long lastTxn = baseSeqTracker.getWriterTxn();
                this.updateRefreshIntervals0(lastTxn, baseTableToken, viewDefinition, viewState, walWriter);
            }
            catch (Throwable th) {
                LOG.error().$("could not update refresh intervals, unexpected error [view=").$(viewToken).$(", ex=").$(th).I$();
                this.refreshFailState(viewDefinition, viewState, null, th);
            }
            finally {
                viewState.unlock();
                viewState.tryCloseIfDropped();
            }
        }
    }

    private LongList updateRefreshIntervals0(long lastBaseTxn, @NotNull TableToken baseTableToken, @NotNull MatViewDefinition viewDefinition, @NotNull MatViewState viewState, @NotNull WalWriter walWriter) {
        assert (viewState.isLocked());
        TableToken viewToken = viewDefinition.getMatViewToken();
        long lastRefreshTxn = Math.max(viewState.getLastRefreshBaseTxn(), viewState.getRefreshIntervalsBaseTxn());
        if (lastRefreshTxn > -1L) {
            if (lastRefreshTxn >= lastBaseTxn) {
                return viewState.getRefreshIntervals();
            }
            try {
                this.intervals.clear();
                this.txnRangeLoader.load(this.engine, Path.PATH.get(), baseTableToken, this.intervals, lastRefreshTxn, lastBaseTxn);
                if (this.intervals.size() > 0) {
                    int dividerIndex = this.intervals.size();
                    this.intervals.addAll(viewState.getRefreshIntervals());
                    IntervalUtils.unionInPlace(this.intervals, dividerIndex);
                    int cacheCapacity = this.configuration.getMatViewMaxRefreshIntervals() << 1;
                    if (this.intervals.size() > cacheCapacity) {
                        this.intervals.setQuick(cacheCapacity - 1, this.intervals.getQuick(this.intervals.size() - 1));
                        this.intervals.setPos(cacheCapacity);
                    }
                    viewState.setRefreshIntervals(this.intervals);
                }
                viewState.setRefreshIntervalsBaseTxn(lastBaseTxn);
                walWriter.resetMatViewState(viewState.getLastRefreshBaseTxn(), viewState.getLastRefreshFinishTimestamp(), false, null, viewState.getLastPeriodHi(), viewState.getRefreshIntervals(), viewState.getRefreshIntervalsBaseTxn());
                return viewState.getRefreshIntervals();
            }
            catch (CairoException ex) {
                LOG.error().$("could not read WAL transactions, falling back to full refresh [view=").$(viewToken).$(", ex=").$safe(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).I$();
                viewState.getRefreshIntervals().clear();
                viewState.setRefreshIntervalsBaseTxn(-1L);
            }
        }
        return null;
    }

    @Nullable
    private TableToken verifyBaseTableToken(@NotNull MatViewDefinition viewDefinition, @NotNull MatViewState viewState, @NotNull WalWriter walWriter) {
        TableToken baseTableToken;
        String baseTableName = viewDefinition.getBaseTableName();
        try {
            baseTableToken = this.engine.verifyTableName(baseTableName);
        }
        catch (CairoException e) {
            LOG.error().$("could not verify base table [view=").$(viewDefinition.getMatViewToken()).$(", baseTableName=").$(baseTableName).$(", errno=").$(e.getErrno()).$(", errorMsg=").$safe(e.getFlyweightMessage()).I$();
            this.refreshFailState(viewDefinition, viewState, walWriter, e);
            return null;
        }
        return baseTableToken;
    }

    private static class RefreshContext
    implements Mutable {
        public SampleByIntervalIterator intervalIterator;
        public long periodHi = Long.MIN_VALUE;
        public long toBaseTxn = -1L;

        private RefreshContext() {
        }

        @Override
        public void clear() {
            this.intervalIterator = null;
            this.periodHi = Long.MIN_VALUE;
            this.toBaseTxn = -1L;
        }
    }
}

