/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.pool;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.pool.AbstractMultiTenantPool;
import io.questdb.cairo.pool.PoolTenant;
import io.questdb.cairo.pool.ResourcePoolSupervisor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.griffin.BatchCallback;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.ExpressionParserListener;
import io.questdb.griffin.QueryBuilder;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.ops.Operation;
import io.questdb.griffin.model.ExecutionModel;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.InsertModel;
import io.questdb.griffin.model.QueryModel;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.Rnd;
import org.jetbrains.annotations.Nullable;

public final class SqlCompilerPool
extends AbstractMultiTenantPool<C> {
    private static final TableToken[] TOKENS = new TableToken[]{new TableToken("blue", "/compilers/blue/", 0, false, false, false), new TableToken("red", "/compilers/red/", 0, false, false, false), new TableToken("green", "/compilers/green/", 0, false, false, false)};
    private final CairoEngine engine;
    private final Rnd rnd = new Rnd();

    public SqlCompilerPool(CairoEngine engine) {
        super(engine.getConfiguration(), engine.getConfiguration().getSqlCompilerPoolCapacity() / 32 + 1, 0L);
        this.engine = engine;
    }

    public C get() {
        return (C)super.get(this.getRandToken());
    }

    @Override
    public boolean releaseInactive() {
        return false;
    }

    private TableToken getRandToken() {
        return TOKENS[this.rnd.nextPositiveInt() % TOKENS.length];
    }

    @Override
    protected byte getListenerSrc() {
        return 6;
    }

    @Override
    protected C newTenant(TableToken tableToken, AbstractMultiTenantPool.Entry<C> entry, int index, @Nullable ResourcePoolSupervisor<C> supervisor) {
        return new C(this.engine.getSqlCompilerFactory().getInstance(this.engine), this, tableToken, entry, index);
    }

    public static class C
    implements SqlCompiler,
    PoolTenant<C> {
        private final SqlCompiler delegate;
        private final int index;
        private AbstractMultiTenantPool.Entry<C> entry;
        private AbstractMultiTenantPool<C> pool;
        private TableToken tableToken;

        public C(SqlCompiler delegate, AbstractMultiTenantPool<C> pool, TableToken tableToken, AbstractMultiTenantPool.Entry<C> entry, int index) {
            this.delegate = delegate;
            this.pool = pool;
            this.tableToken = tableToken;
            this.entry = entry;
            this.index = index;
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public void close() {
            this.setFullFatJoins(false);
            AbstractMultiTenantPool<C> pool = this.pool;
            if (pool != null && this.entry != null && pool.returnToPool(this)) {
                return;
            }
            this.delegate.close();
        }

        @Override
        public CompiledQuery compile(CharSequence sqlText, SqlExecutionContext ctx) throws SqlException {
            return this.delegate.compile(sqlText, ctx);
        }

        @Override
        public void compileBatch(CharSequence batchText, SqlExecutionContext sqlExecutionContext, BatchCallback batchCallback) throws Exception {
            this.delegate.compileBatch(batchText, sqlExecutionContext, batchCallback);
        }

        @Override
        public void execute(Operation op, SqlExecutionContext executionContext) throws SqlException {
            this.delegate.execute(op, executionContext);
        }

        @Override
        public RecordCursorFactory generateSelectWithRetries(QueryModel queryModel, @Nullable InsertModel insertModel, SqlExecutionContext executionContext, boolean generateProgressLogger) throws SqlException {
            return this.delegate.generateSelectWithRetries(queryModel, insertModel, executionContext, generateProgressLogger);
        }

        @Override
        public BytecodeAssembler getAsm() {
            return this.delegate.getAsm();
        }

        public SqlCompiler getDelegate() {
            return this.delegate;
        }

        @Override
        public CairoEngine getEngine() {
            return this.delegate.getEngine();
        }

        @Override
        public AbstractMultiTenantPool.Entry<C> getEntry() {
            return this.entry;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public TableToken getTableToken() {
            return this.tableToken;
        }

        @Override
        public void goodbye() {
            this.entry = null;
            this.pool = null;
        }

        @Override
        public QueryBuilder query() {
            return this.delegate.query();
        }

        @Override
        public void refresh(ResourcePoolSupervisor<C> supervisor) {
            this.clear();
        }

        @Override
        public void setEnableJitNullChecks(boolean value) {
            this.delegate.setEnableJitNullChecks(value);
        }

        @Override
        public void setFullFatJoins(boolean fullFatJoins) {
            this.delegate.setFullFatJoins(fullFatJoins);
        }

        @Override
        public ExecutionModel testCompileModel(CharSequence sqlText, SqlExecutionContext executionContext) throws SqlException {
            return this.delegate.testCompileModel(sqlText, executionContext);
        }

        @Override
        public ExpressionNode testParseExpression(CharSequence expression, QueryModel model) throws SqlException {
            return this.delegate.testParseExpression(expression, model);
        }

        @Override
        public void testParseExpression(CharSequence expression, ExpressionParserListener listener) throws SqlException {
            this.delegate.testParseExpression(expression, listener);
        }

        @Override
        public void updateTableToken(TableToken tableToken) {
            this.tableToken = tableToken;
        }
    }
}

