/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.file.BlockFileReader;
import io.questdb.cairo.mv.MatViewStateReader;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMR;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cairo.wal.WalEventCursor;
import io.questdb.cairo.wal.WalEventReader;
import io.questdb.cairo.wal.seq.TableTransactionLogV1;
import io.questdb.std.FilesFacade;
import io.questdb.std.str.Path;

public class WalUtils {
    public static final String CONVERT_FILE_NAME = "_convert";
    public static final int DROP_TABLE_STRUCTURE_VERSION = -2;
    public static final int DROP_TABLE_WAL_ID = -2;
    public static final String EVENT_FILE_NAME = "_event";
    public static final String EVENT_INDEX_FILE_NAME = "_event.i";
    public static final CharSequence INITIAL_META_FILE_NAME = "_meta.0";
    public static final int METADATA_WALID = -1;
    public static final int MIN_WAL_ID = -2;
    public static final int SEG_MIN_ID = 0;
    public static final int SEG_NONE_ID = 0x1FFFFFFF;
    public static final int SEG_MAX_ID = 0x1FFFFFFE;
    public static final String SEQ_DIR = "txn_seq";
    public static final String SEQ_DIR_DEPRECATED = "seq";
    public static final long SEQ_META_OFFSET_WAL_LENGTH = 0L;
    public static final long SEQ_META_OFFSET_WAL_VERSION = 4L;
    public static final long SEQ_META_OFFSET_STRUCTURE_VERSION = 8L;
    public static final long SEQ_META_OFFSET_COLUMN_COUNT = 16L;
    public static final long SEQ_META_OFFSET_TIMESTAMP_INDEX = 20L;
    public static final long SEQ_META_TABLE_ID = 24L;
    public static final long SEQ_META_SUSPENDED = 28L;
    public static final long SEQ_META_OFFSET_COLUMNS = 29L;
    public static final String TABLE_REGISTRY_NAME_FILE = "tables.d";
    public static final String TXNLOG_FILE_NAME = "_txnlog";
    public static final String TXNLOG_FILE_NAME_META_INX = "_txnlog.meta.i";
    public static final String TXNLOG_FILE_NAME_META_VAR = "_txnlog.meta.d";
    public static final String TXNLOG_PARTS_DIR = "_txn_parts";
    public static final int WALE_HEADER_SIZE = 8;
    public static final long WALE_MAX_TXN_OFFSET_32 = 0L;
    public static final byte WAL_DEDUP_MODE_DEFAULT = 0;
    public static final byte WAL_DEDUP_MODE_NO_DEDUP = 1;
    public static final byte WAL_DEDUP_MODE_UPSERT_NEW = 2;
    public static final byte WAL_DEDUP_MODE_REPLACE_RANGE = 3;
    public static final byte WAL_DEDUP_MODE_MAX = 3;
    public static final int WAL_FORMAT_OFFSET_32 = 4;
    public static final short WAL_FORMAT_VERSION = 0;
    public static final short WALE_FORMAT_VERSION = 0;
    public static final short WALE_MAT_VIEW_FORMAT_VERSION = 1;
    public static final String WAL_INDEX_FILE_NAME = "_wal_index.d";
    public static final String WAL_NAME_BASE = "wal";
    public static final String WAL_PENDING_FS_MARKER = ".pending";
    public static final int WAL_SEQUENCER_FORMAT_VERSION_V1 = 0;
    public static final int WAL_SEQUENCER_FORMAT_VERSION_V2 = 1;
    public static long WAL_DEFAULT_BASE_TABLE_TXN = Long.MIN_VALUE;
    public static long WAL_DEFAULT_LAST_PERIOD_HI = Long.MIN_VALUE;
    public static long WAL_DEFAULT_LAST_REFRESH_TIMESTAMP = Long.MIN_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTxnLogFile(FilesFacade ff, MemoryMARW mem, Path txnSeqDirPath, long tableCreateDate, int chunkSize, int mkDirMode) {
        int rootLen = txnSeqDirPath.size();
        try {
            if (chunkSize < 1) {
                mem.smallFile(ff, txnSeqDirPath.concat(TXNLOG_FILE_NAME).$(), 0);
                mem.putInt(0);
                mem.putLong(0L);
                mem.putLong(tableCreateDate);
                mem.close();
            } else {
                mem.smallFile(ff, txnSeqDirPath.concat(TXNLOG_FILE_NAME).$(), 0);
                mem.putInt(1);
                mem.putLong(0L);
                mem.putLong(tableCreateDate);
                mem.putInt(chunkSize);
                mem.jumpTo(76L);
                mem.close(false);
                txnSeqDirPath.trimTo(rootLen).concat(TXNLOG_PARTS_DIR);
                if (!ff.exists(txnSeqDirPath.$())) {
                    ff.mkdir(txnSeqDirPath.$(), mkDirMode);
                }
            }
        }
        finally {
            txnSeqDirPath.trimTo(rootLen);
        }
    }

    public static boolean readMatViewState(Path tablePath, TableToken tableToken, CairoConfiguration configuration, MemoryCMR txnLogMemory, WalEventReader walEventReader, BlockFileReader blockFileReader, MatViewStateReader matViewStateReader) {
        block22: {
            try (MemoryCMR mem = txnLogMemory;){
                int tablePathLen = tablePath.size();
                mem.smallFile(configuration.getFilesFacade(), tablePath.concat(SEQ_DIR).concat(TXNLOG_FILE_NAME).$(), 13);
                if (mem.size() < 76L) {
                    throw CairoException.critical(0).put("invalid transaction log file [path=").put(tablePath).put(", size=").put(mem.size()).put(']');
                }
                int formatVersion = mem.getInt(0L);
                if (formatVersion == 0) {
                    long txnCount = mem.getLong(4L);
                    if (txnCount > 0L && mem.size() >= 76L + txnCount * TableTransactionLogV1.RECORD_SIZE) {
                        for (long txn = txnCount - 1L; txn >= 0L; --txn) {
                            long offset = 76L + txn * TableTransactionLogV1.RECORD_SIZE;
                            if (!WalUtils.processTransaction(mem, offset, tablePath, tablePathLen, walEventReader, blockFileReader, matViewStateReader, tableToken)) continue;
                            boolean bl = true;
                            return bl;
                        }
                    }
                    break block22;
                }
                if (formatVersion == 1) {
                    long txnCount = mem.getLong(4L);
                    long partSize = mem.getInt(20L);
                    if (txnCount <= 0L || partSize <= 0L) break block22;
                    long partCount = (txnCount + partSize - 1L) / partSize;
                    try (MemoryCMR partMem = Vm.getCMRInstance();){
                        for (long part = partCount - 1L; part >= 0L; --part) {
                            tablePath.trimTo(tablePathLen).concat(SEQ_DIR).concat(TXNLOG_PARTS_DIR).slash().put(part);
                            partMem.smallFile(configuration.getFilesFacade(), tablePath.$(), 13);
                            long partTxnCount = Math.min(partSize, txnCount - part * partSize);
                            for (long txn = partTxnCount - 1L; txn >= 0L; --txn) {
                                long offset = txn * 60L;
                                if (!WalUtils.processTransaction(partMem, offset, tablePath, tablePathLen, walEventReader, blockFileReader, matViewStateReader, tableToken)) continue;
                                boolean bl = true;
                                return bl;
                            }
                        }
                        break block22;
                    }
                }
                throw new UnsupportedOperationException("Unsupported transaction log version: " + formatVersion);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean processTransaction(MemoryCMR mem, long offset, Path tablePath, int tablePathLen, WalEventReader walEventReader, BlockFileReader blockFileReader, MatViewStateReader matViewStateReader, TableToken tableToken) {
        int walId = mem.getInt(offset + 8L);
        int segmentId = mem.getInt(offset + 12L);
        int segmentTxn = mem.getInt(offset + 16L);
        if (walId <= 0) return false;
        tablePath.trimTo(tablePathLen).concat(WAL_NAME_BASE).put(walId).slash().put(segmentId);
        try (WalEventReader eventReader = walEventReader;){
            WalEventCursor walEventCursor = eventReader.of(tablePath, segmentTxn);
            if (walEventCursor.getType() == 3) {
                matViewStateReader.of(walEventCursor.getMatViewDataInfo());
                boolean bl = true;
                return bl;
            }
            if (walEventCursor.getType() != 4) return false;
            matViewStateReader.of(walEventCursor.getMatViewInvalidationInfo());
            boolean bl = true;
            return bl;
        }
        catch (Throwable th) {
            try (BlockFileReader blockReader = blockFileReader;){
                tablePath.trimTo(tablePathLen).concat("_mv.s");
                blockReader.of(tablePath.$());
                matViewStateReader.of(blockReader, tableToken);
                boolean bl = true;
                return bl;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
    }
}

