/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal.seq;

import io.questdb.cairo.AbstractRecordMetadata;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.file.BlockFileWriter;
import io.questdb.cairo.mv.MatViewDefinition;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.cairo.wal.WalUtils;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.str.Path;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicLong;

public class SequencerMetadata
extends AbstractRecordMetadata
implements TableRecordMetadata,
Closeable {
    private final int commitMode;
    private final FilesFacade ff;
    private final MemoryMARW metaMem;
    private final IntList readColumnOrder = new IntList();
    private final boolean readonly;
    private final MemoryMR roMetaMem;
    private final AtomicLong structureVersion = new AtomicLong(-1L);
    private volatile boolean suspended;
    private int tableId;
    private TableToken tableToken;

    public SequencerMetadata(FilesFacade ff, int commitMode) {
        this(ff, commitMode, false);
    }

    public SequencerMetadata(FilesFacade ff, int commitMode, boolean readonly) {
        this.ff = ff;
        this.commitMode = commitMode;
        this.readonly = readonly;
        if (!readonly) {
            this.metaMem = Vm.getCMARWInstance();
            this.roMetaMem = this.metaMem;
        } else {
            this.metaMem = null;
            this.roMetaMem = Vm.getCMRInstance();
        }
    }

    public void addColumn(CharSequence columnName, int columnType, int symbolCapacity, boolean symbolCacheFlag, boolean isIndexed, int indexValueBlockCapacity, boolean isDedupKey) {
        this.addColumn0(columnName, columnType, symbolCapacity, symbolCacheFlag, isIndexed, indexValueBlockCapacity, isDedupKey);
        this.readColumnOrder.add(this.columnMetadata.size() - 1);
        this.structureVersion.incrementAndGet();
    }

    public void changeColumnType(CharSequence columnName, int columnType, int symbolCapacity, boolean symbolCacheFlag, boolean isIndexed, int indexValueBlockCapacity) {
        int existingColumnIndex = TableUtils.changeColumnTypeInMetadata(columnName, columnType, symbolCapacity, symbolCacheFlag, isIndexed, indexValueBlockCapacity, this.columnNameIndexMap, this.columnMetadata);
        int readIndex = this.readColumnOrder.get(existingColumnIndex);
        this.readColumnOrder.add(readIndex);
        ++this.columnCount;
        this.structureVersion.incrementAndGet();
    }

    @Override
    public void close() {
        this.reset();
        if (this.metaMem != null) {
            this.metaMem.close(false);
        }
        Misc.free(this.roMetaMem);
    }

    public void create(TableStructure tableStruct, TableToken tableToken, Path path, int pathLen, int tableId) {
        this.create(tableStruct, tableToken, path, pathLen, tableId, true);
    }

    public void create(TableStructure tableStruct, TableToken tableToken, Path path, int pathLen, int tableId, boolean writeInitialMetadata) {
        this.copyFrom(tableStruct, tableToken, tableId);
        TableUtils.openSmallFile(this.ff, path, pathLen, this.metaMem, WalUtils.INITIAL_META_FILE_NAME, 8);
        if (writeInitialMetadata) {
            TableUtils.writeMetadata(tableStruct, 426, tableId, this.metaMem);
        }
        this.metaMem.sync(false);
        this.metaMem.close(true, (byte)1);
        if (writeInitialMetadata && tableStruct.isMatView()) {
            assert (tableStruct.getMatViewDefinition() != null);
            try (BlockFileWriter writer = new BlockFileWriter(this.ff, this.commitMode);){
                writer.of(path.trimTo(pathLen).concat("_mv").$());
                MatViewDefinition.append(tableStruct.getMatViewDefinition(), writer);
            }
            path.trimTo(pathLen);
        }
        this.switchTo(path, pathLen);
    }

    public void disableDeduplication() {
        this.structureVersion.incrementAndGet();
    }

    public void dropTable() {
        this.structureVersion.set(-2L);
        this.syncToMetaFile();
    }

    public boolean enableDeduplicationWithUpsertKeys() {
        this.structureVersion.incrementAndGet();
        return false;
    }

    @Override
    public long getMetadataVersion() {
        return this.structureVersion.get();
    }

    public IntList getReadColumnOrder() {
        return this.readColumnOrder;
    }

    public int getRealColumnCount() {
        return this.columnNameIndexMap.size();
    }

    @Override
    public int getTableId() {
        return this.tableId;
    }

    @Override
    public TableToken getTableToken() {
        return this.tableToken;
    }

    public boolean isDropped() {
        return this.structureVersion.get() == -2L;
    }

    @Override
    public boolean isWalEnabled() {
        return true;
    }

    public void notifyRenameTable(TableToken tableToken) {
        this.tableToken = tableToken;
    }

    public void open(Path path, int pathLen, TableToken tableToken) {
        this.reset();
        TableUtils.openSmallFile(this.ff, path, pathLen, this.roMetaMem, "_meta", 8);
        if (!this.readonly) {
            this.metaMem.jumpTo(4L);
            int size = this.metaMem.getInt(0L);
            this.metaMem.jumpTo(size);
        }
        this.loadSequencerMetadata(this.roMetaMem);
        this.structureVersion.set(this.roMetaMem.getLong(8L));
        this.columnCount = this.columnMetadata.size();
        this.timestampIndex = this.roMetaMem.getInt(20L);
        this.tableId = this.roMetaMem.getInt(24L);
        this.suspended = this.roMetaMem.getBool(28L);
        this.tableToken = tableToken;
        if (this.readonly) {
            this.roMetaMem.close();
        }
    }

    public void removeColumn(CharSequence columnName) {
        TableUtils.removeColumnFromMetadata(columnName, this.columnNameIndexMap, this.columnMetadata);
        this.structureVersion.incrementAndGet();
    }

    public void renameColumn(CharSequence columnName, CharSequence newName) {
        TableUtils.renameColumnInMetadata(columnName, newName, this.columnNameIndexMap, this.columnMetadata);
        this.structureVersion.incrementAndGet();
    }

    public void renameTable(CharSequence toTableName) {
        if (!Chars.equalsIgnoreCaseNc(toTableName, this.tableToken.getTableName())) {
            this.tableToken = this.tableToken.renamed(Chars.toString(toTableName));
        }
        this.structureVersion.incrementAndGet();
    }

    public void sync() {
        this.metaMem.sync(false);
    }

    public void updateTableToken(TableToken newTableToken) {
        assert (newTableToken != null);
        this.tableToken = newTableToken;
    }

    private void addColumn0(CharSequence columnName, int columnType, int symbolCapacity, boolean symbolCacheFlag, boolean isIndexed, int indexValueBlockCapacity, boolean isDedupKey) {
        String name = columnName.toString();
        if (columnType > 0) {
            this.columnNameIndexMap.put(name, this.columnMetadata.size());
        }
        this.columnMetadata.add(new TableColumnMetadata(name, columnType, isIndexed, indexValueBlockCapacity, false, null, this.columnMetadata.size(), isDedupKey, 0, symbolCacheFlag, symbolCapacity));
        ++this.columnCount;
    }

    private void copyFrom(TableStructure tableStruct, TableToken tableToken, int tableId) {
        this.reset();
        this.tableToken = tableToken;
        this.timestampIndex = tableStruct.getTimestampIndex();
        this.tableId = tableId;
        this.suspended = false;
        int n = tableStruct.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.addColumn0(tableStruct.getColumnName(i), tableStruct.getColumnType(i), tableStruct.getSymbolCapacity(i), tableStruct.getSymbolCacheFlag(i), tableStruct.isIndexed(i), tableStruct.getIndexBlockCapacity(i), tableStruct.isDedupKey(i));
            this.readColumnOrder.add(i);
        }
        this.structureVersion.set(0L);
        this.columnCount = this.columnMetadata.size();
    }

    private void loadSequencerMetadata(MemoryMR metaMem) {
        this.columnMetadata.clear();
        this.columnNameIndexMap.clear();
        this.readColumnOrder.clear();
        try {
            int timestampType;
            long memSize = Math.min(TableUtils.checkMemSize(metaMem, 29L), (long)metaMem.getInt(0L));
            TableUtils.validateMetaVersion(metaMem, 4L, 0);
            int columnCount = TableUtils.getColumnCount(metaMem, 16L);
            int timestampIndex = TableUtils.getTimestampIndex(metaMem, 20L, columnCount);
            long checkSum = columnCount;
            long offset = 29L;
            for (int i = 0; i < columnCount; ++i) {
                int type = TableUtils.getColumnType(metaMem, memSize, offset, i);
                String name = TableUtils.getColumnName(metaMem, memSize, offset += 4L, i).toString();
                offset += (long)Vm.getStorageLength(name);
                if (type > 0) {
                    this.columnNameIndexMap.put(name, i);
                }
                if (ColumnType.isSymbol(Math.abs(type))) {
                    this.columnMetadata.add(new TableColumnMetadata(name, type, true, 1024, true, null));
                } else {
                    this.columnMetadata.add(new TableColumnMetadata(name, type));
                }
                this.readColumnOrder.add(i);
                checkSum = checkSum * 31L + (long)type;
                checkSum = checkSum * 31L + (long)name.hashCode();
            }
            if (timestampIndex != -1 && !ColumnType.isTimestamp(timestampType = ((TableColumnMetadata)this.columnMetadata.getQuick(timestampIndex)).getColumnType())) {
                throw TableUtils.validationException(metaMem).put("Timestamp column must be TIMESTAMP, but found ").put(ColumnType.nameOf(timestampType));
            }
            if (memSize > offset + 8L + 4L) {
                long records;
                long optionalSectionCheckSum = metaMem.getLong(offset);
                offset += 8L;
                if (optionalSectionCheckSum == checkSum && memSize - (offset += 4L) >= (records = (long)metaMem.getInt(offset)) * 4L) {
                    this.readColumnOrder.clear();
                    int i = 0;
                    while ((long)i < records) {
                        this.readColumnOrder.add(metaMem.getInt(offset));
                        offset += 4L;
                        ++i;
                    }
                }
            }
        }
        catch (Throwable e) {
            this.columnNameIndexMap.clear();
            this.columnMetadata.clear();
            throw e;
        }
    }

    private void reset() {
        this.columnMetadata.clear();
        this.columnNameIndexMap.clear();
        this.readColumnOrder.clear();
        this.columnCount = 0;
        this.timestampIndex = -1;
        this.tableToken = null;
        this.tableId = -1;
        this.suspended = false;
    }

    private void switchTo(Path path, int pathLen) {
        TableUtils.openSmallFile(this.ff, path, pathLen, this.metaMem, "_meta", 8);
        this.syncToMetaFile();
    }

    boolean isSuspended() {
        return this.suspended;
    }

    void resumeTable() {
        this.suspended = false;
        this.syncToMetaFile();
    }

    void suspendTable() {
        this.suspended = true;
        this.syncToMetaFile();
    }

    void syncToMetaFile() {
        int i;
        this.metaMem.jumpTo(0L);
        this.metaMem.putInt(0);
        this.metaMem.putInt(0);
        this.metaMem.putLong(this.structureVersion.get());
        this.metaMem.putInt(this.columnCount);
        this.metaMem.putInt(this.timestampIndex);
        this.metaMem.putInt(this.tableId);
        this.metaMem.putBool(this.suspended);
        long checkSum = this.columnCount;
        for (i = 0; i < this.columnCount; ++i) {
            int columnType = this.getColumnType(i);
            this.metaMem.putInt(columnType);
            this.metaMem.putStr(this.getColumnName(i));
            checkSum = checkSum * 31L + (long)columnType;
            checkSum = checkSum * 31L + (long)this.getColumnName(i).hashCode();
        }
        this.metaMem.putLong(checkSum);
        this.metaMem.putInt(this.readColumnOrder.size());
        int n = this.readColumnOrder.size();
        for (i = 0; i < n; ++i) {
            this.metaMem.putInt(this.readColumnOrder.get(i));
        }
        this.metaMem.putInt(0L, (int)this.metaMem.getAppendOffset());
        this.metaMem.sync(false);
    }
}

