/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal.seq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.MemorySerializer;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMARW;
import io.questdb.cairo.wal.seq.TableTransactionLogFile;
import io.questdb.cairo.wal.seq.TransactionLogCursor;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.Unsafe;
import io.questdb.std.str.Path;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class TableTransactionLogV2
implements TableTransactionLogFile {
    public static final long MIN_TIMESTAMP_OFFSET = 28L;
    public static final long MAX_TIMESTAMP_OFFSET = 36L;
    public static final long ROW_COUNT_OFFSET = 44L;
    public static final long RESERVED_OFFSET = 52L;
    public static final long RECORD_SIZE = 60L;
    private static final Log LOG = LogFactory.getLog(TableTransactionLogV2.class);
    private static final ThreadLocal<TransactionLogCursorImpl> tlTransactionLogCursor = new ThreadLocal();
    private final CairoConfiguration configuration;
    private final FilesFacade ff;
    private final AtomicLong maxTxn = new AtomicLong();
    private final Path rootPath;
    private final MemoryCMARW txnMem = Vm.getCMARWInstance();
    private final MemoryCMARW txnPartMem = Vm.getCMARWInstance();
    private long partId = -1L;
    private int partTransactionCount;

    public TableTransactionLogV2(CairoConfiguration configuration, int seqPartTransactionCount) {
        this.configuration = configuration;
        this.ff = configuration.getFilesFacade();
        this.partTransactionCount = seqPartTransactionCount;
        this.rootPath = new Path();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long readMaxStructureVersion(Path path, long logFileFd, FilesFacade ff) {
        long lastTxn = ff.readNonNegativeLong(logFileFd, 4L);
        if (lastTxn < 0L) {
            return -1L;
        }
        int partTransactionCount = ff.readNonNegativeInt(logFileFd, 20L);
        if (partTransactionCount < 1) {
            return -1L;
        }
        if (lastTxn > 0L) {
            long prevTxn = lastTxn - 1L;
            long part = prevTxn / (long)partTransactionCount;
            int size = path.size();
            path.concat("_txn_parts").slash().put(part);
            long partFd = -1L;
            try {
                partFd = TableUtils.openRO(ff, path.$(), LOG);
                long fileReadOffset = prevTxn % (long)partTransactionCount * 60L + 0L;
                long l = ff.readNonNegativeLong(partFd, fileReadOffset);
                return l;
            }
            finally {
                if (partFd > -1L) {
                    ff.close(partFd);
                }
                path.trimTo(size);
            }
        }
        return 0L;
    }

    @Override
    public long addEntry(long structureVersion, int walId, int segmentId, int segmentTxn, long timestamp, long txnMinTimestamp, long txnMaxTimestamp, long txnRowCount) {
        this.openTxnPart();
        this.txnPartMem.putLong(structureVersion);
        this.txnPartMem.putInt(walId);
        this.txnPartMem.putInt(segmentId);
        this.txnPartMem.putInt(segmentTxn);
        this.txnPartMem.putLong(timestamp);
        this.txnPartMem.putLong(txnMinTimestamp);
        this.txnPartMem.putLong(txnMaxTimestamp);
        this.txnPartMem.putLong(txnRowCount);
        this.txnPartMem.putLong(0L);
        Unsafe.getUnsafe().storeFence();
        long maxTxn = this.maxTxn.incrementAndGet();
        this.txnMem.putLong(4L, maxTxn);
        this.sync0();
        return maxTxn;
    }

    @Override
    public void beginMetadataChangeEntry(long newStructureVersion, MemorySerializer serializer, Object instance, long timestamp) {
        this.openTxnPart();
        this.txnPartMem.putLong(newStructureVersion);
        this.txnPartMem.putInt(-1);
        this.txnPartMem.putInt(-1);
        this.txnPartMem.putInt(-1);
        this.txnPartMem.putLong(timestamp);
        this.txnPartMem.putLong(serializer.getCommandType(instance));
        this.txnPartMem.putLong(0L);
        this.txnPartMem.putLong(0L);
        this.txnPartMem.putLong(0L);
    }

    @Override
    public void close() {
        long maxTxnInFile;
        if (this.txnMem.isOpen() && (maxTxnInFile = this.txnMem.getLong(4L)) != this.maxTxn.get()) {
            LOG.error().$("Max txn in the file ").$(maxTxnInFile).$(" but in memory is ").$(this.maxTxn.get()).$();
        }
        this.txnMem.close(false);
        this.txnPartMem.close(false);
        this.rootPath.close();
    }

    @Override
    public void create(Path path, long tableCreateTimestamp) {
        this.createTxnFile(path, tableCreateTimestamp);
        this.createPartsDir(this.configuration.getMkDirMode());
    }

    @Override
    public long endMetadataChangeEntry() {
        long nextTxn = this.maxTxn.incrementAndGet();
        this.txnMem.putLong(4L, nextTxn);
        return nextTxn;
    }

    @Override
    public void fullSync() {
        this.txnMem.sync(false);
    }

    @Override
    public TransactionLogCursor getCursor(long txnLo, Path path) {
        TransactionLogCursorImpl cursor = tlTransactionLogCursor.get();
        if (cursor == null) {
            cursor = new TransactionLogCursorImpl(this.ff, txnLo, path, this.partTransactionCount);
            tlTransactionLogCursor.set(cursor);
            return cursor;
        }
        try {
            return cursor.of(this.ff, txnLo, path, this.partTransactionCount);
        }
        catch (Throwable th) {
            cursor.close();
            throw th;
        }
    }

    @Override
    public boolean isDropped() {
        long lastTxn = this.maxTxn.get();
        if (lastTxn > 0L) {
            long prevTxn = lastTxn - 1L;
            this.openTxnPart(prevTxn);
            long lastPartTxn = prevTxn % (long)this.partTransactionCount;
            return -2L == this.txnPartMem.getLong(lastPartTxn * 60L + 8L);
        }
        return false;
    }

    @Override
    public long lastTxn() {
        return this.maxTxn.get();
    }

    @Override
    public long open(Path path) {
        if (!this.txnMem.isOpen()) {
            this.txnMem.close(false);
            this.openTxnMem(path);
        }
        long lastTxn = this.txnMem.getLong(4L);
        this.maxTxn.set(lastTxn);
        this.partTransactionCount = this.txnMem.getInt(20L);
        if (this.partTransactionCount < 1) {
            throw new CairoException().put("invalid sequencer file part size [size=").put(this.partTransactionCount).put(", path=").put(path).put(']');
        }
        long maxStructureVersion = 0L;
        if (lastTxn > 0L) {
            long prevTxn = lastTxn - 1L;
            this.openTxnPart(prevTxn);
            long lastPartTxn = prevTxn % (long)this.partTransactionCount;
            maxStructureVersion = this.txnPartMem.getLong(lastPartTxn * 60L + 0L);
        }
        this.openTxnPart();
        this.setAppendPosition();
        return maxStructureVersion;
    }

    private void createPartsDir(int mkDirMode) {
        int rootLen = this.rootPath.size();
        this.rootPath.concat("_txn_parts");
        try {
            if (!this.ff.exists(this.rootPath.$()) && this.ff.mkdir(this.rootPath.$(), mkDirMode) != 0) {
                throw CairoException.critical(this.ff.errno()).put("could not create directory [path='").put(this.rootPath).put("']");
            }
        }
        finally {
            this.rootPath.trimTo(rootLen);
        }
    }

    private void createTxnFile(Path path, long tableCreateTimestamp) {
        this.openTxnMem(path);
        this.txnMem.jumpTo(0L);
        this.txnMem.putInt(1);
        this.txnMem.putLong(0L);
        this.txnMem.putLong(tableCreateTimestamp);
        this.txnMem.putInt(this.partTransactionCount);
        this.sync0();
    }

    private void openTxnMem(Path path) {
        this.rootPath.of(path);
        int rootLen = this.rootPath.size();
        this.rootPath.concat("_txnlog");
        try {
            this.txnMem.of(this.ff, this.rootPath.$(), 76L, 76L, 13);
        }
        finally {
            this.rootPath.trimTo(rootLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openTxnPart(long txn) {
        long part = txn / (long)this.partTransactionCount;
        if (this.partId != part) {
            int size = this.rootPath.size();
            try {
                this.rootPath.concat("_txn_parts").slash().put(part);
                long partSize = (long)this.partTransactionCount * 60L;
                this.txnPartMem.close(false);
                this.txnPartMem.of(this.ff, this.rootPath.$(), partSize, partSize, 13);
                this.txnPartMem.jumpTo(txn % (long)this.partTransactionCount * 60L);
                this.partId = part;
            }
            finally {
                this.rootPath.trimTo(size);
            }
        }
    }

    private void openTxnPart() {
        this.openTxnPart(this.maxTxn.get());
    }

    private void setAppendPosition() {
        this.txnPartMem.jumpTo(this.maxTxn.get() % (long)this.partTransactionCount * 60L);
    }

    private void sync0() {
        int commitMode = this.configuration.getCommitMode();
        if (commitMode != 2) {
            this.txnMem.sync(commitMode == 0);
        }
    }

    private static class TransactionLogCursorImpl
    implements TransactionLogCursor {
        private final Path rootPath = new Path();
        private long address;
        private FilesFacade ff;
        private long headerFd;
        private long partFd = -1L;
        private long partId = -1L;
        private long partMapSize;
        private int partTransactionCount;
        private long txn = -2L;
        private long txnCount = -1L;
        private long txnLo;
        private long txnOffset;

        public TransactionLogCursorImpl(FilesFacade ff, long txnLo, Path path, int partTransactionCount) {
            try {
                this.of(ff, txnLo, path, partTransactionCount);
            }
            catch (Throwable th) {
                this.close();
                throw th;
            }
        }

        @Override
        public void close() {
            if (this.headerFd > 0L) {
                this.ff.close(this.headerFd);
            }
            if (this.txnCount > -1L && this.address > 0L) {
                this.ff.munmap(this.address, this.partMapSize, 14);
                this.txnCount = 0L;
                this.address = 0L;
            }
            this.closePart();
            this.rootPath.close();
        }

        @Override
        public boolean extend() {
            boolean extended;
            long newTxnCount = this.ff.readNonNegativeLong(this.headerFd, 4L);
            boolean bl = extended = newTxnCount > this.txnCount;
            if (extended) {
                this.txnCount = newTxnCount;
            }
            return extended;
        }

        @Override
        public long getCommitTimestamp() {
            assert (this.address != 0L);
            return Unsafe.getUnsafe().getLong(this.address + this.txnOffset + 20L);
        }

        @Override
        public long getMaxTxn() {
            return this.txnCount;
        }

        @Override
        public int getPartitionSize() {
            return this.partTransactionCount;
        }

        @Override
        public int getSegmentId() {
            assert (this.address != 0L);
            return Unsafe.getUnsafe().getInt(this.address + this.txnOffset + 12L);
        }

        @Override
        public int getSegmentTxn() {
            assert (this.address != 0L);
            return Unsafe.getUnsafe().getInt(this.address + this.txnOffset + 16L);
        }

        @Override
        public long getStructureVersion() {
            assert (this.address != 0L);
            return Unsafe.getUnsafe().getLong(this.address + this.txnOffset + 0L);
        }

        @Override
        public long getTxn() {
            return this.txn;
        }

        @Override
        public long getTxnMaxTimestamp() {
            assert (this.address != 0L);
            return Unsafe.getUnsafe().getLong(this.address + this.txnOffset + 36L);
        }

        @Override
        public long getTxnMinTimestamp() {
            assert (this.address != 0L);
            return Unsafe.getUnsafe().getLong(this.address + this.txnOffset + 28L);
        }

        @Override
        public long getTxnRowCount() {
            assert (this.address != 0L);
            return Unsafe.getUnsafe().getLong(this.address + this.txnOffset + 44L);
        }

        @Override
        public int getVersion() {
            return 1;
        }

        @Override
        public int getWalId() {
            assert (this.address != 0L);
            return Unsafe.getUnsafe().getInt(this.address + this.txnOffset + 8L);
        }

        @Override
        public boolean hasNext() {
            if (this.txn >= this.txnCount) {
                this.txnCount = this.ff.readNonNegativeLong(this.headerFd, 4L);
                if (this.txn >= this.txnCount) {
                    return false;
                }
            }
            this.openPart(this.txn);
            ++this.txn;
            return true;
        }

        @Override
        public void setPosition(long txn) {
            this.txn = txn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void toMinTxn() {
            int rootLen = this.rootPath.size();
            this.rootPath.concat("_txn_parts").slash();
            long partId = this.txnLo / (long)this.partTransactionCount;
            long minTxn = partId * (long)this.partTransactionCount;
            int rootPathLen = this.rootPath.size();
            try {
                for (long part = partId - 1L; part > -1L; --part) {
                    this.rootPath.trimTo(rootPathLen).put(part);
                    if (this.ff.exists(this.rootPath.$())) {
                        minTxn = part * (long)this.partTransactionCount;
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.rootPath.trimTo(rootLen);
            }
            this.openPart(minTxn);
            this.txn = this.txnLo = minTxn;
        }

        @Override
        public void toTop() {
            if (this.txnCount > -1L) {
                this.txn = this.txnLo;
            }
        }

        private void closePart() {
            if (this.partFd > -1L) {
                this.ff.munmap(this.address, this.partMapSize, 14);
                this.ff.close(this.partFd);
                this.partFd = -1L;
                this.partId = -2L;
                this.address = 0L;
            }
        }

        @NotNull
        private TransactionLogCursorImpl of(FilesFacade ff, long txnLo, Path path, int partTransactionCount) {
            this.partTransactionCount = partTransactionCount;
            this.partMapSize = (long)partTransactionCount * 60L;
            this.ff = ff;
            this.headerFd = TableUtils.openRO(ff, path, "_txnlog", LOG);
            long newTxnCount = ff.readNonNegativeLong(this.headerFd, 4L);
            this.rootPath.of(path);
            if (newTxnCount > -1L) {
                this.txnCount = newTxnCount;
                assert (txnLo > -1L);
            } else {
                throw CairoException.critical(ff.errno()).put("cannot read sequencer transactions [path=").put(path).put(']');
            }
            this.txn = txnLo;
            this.txnLo = txnLo;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void openPart(long zeroBasedTxn) {
            long part = zeroBasedTxn / (long)this.partTransactionCount;
            if (part != this.partId) {
                this.closePart();
                int size = this.rootPath.size();
                try {
                    this.rootPath.concat("_txn_parts").slash().put(part);
                    this.partFd = TableUtils.openRO(this.ff, this.rootPath.$(), LOG);
                    this.address = this.ff.mmap(this.partFd, this.partMapSize, 0L, 1, 14);
                    this.partId = part;
                }
                finally {
                    this.rootPath.trimTo(size);
                }
            }
            this.txnOffset = zeroBasedTxn % (long)this.partTransactionCount * 60L;
        }
    }
}

