/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.Telemetry;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CommitFailedException;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cutlass.line.tcp.DefaultColumnTypes;
import io.questdb.cutlass.line.tcp.LineTcpParser;
import io.questdb.cutlass.line.tcp.SymbolCache;
import io.questdb.cutlass.line.tcp.TableStructureAdapter;
import io.questdb.cutlass.line.tcp.WalTableUpdateDetails;
import io.questdb.std.LowerCaseUtf8SequenceObjHashMap;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Pool;
import io.questdb.std.QuietCloseable;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8String;
import io.questdb.std.str.Utf8s;
import io.questdb.tasks.TelemetryTask;
import org.jetbrains.annotations.NotNull;

public class LineHttpTudCache
implements QuietCloseable {
    private final boolean autoCreateNewColumns;
    private final boolean autoCreateNewTables;
    private final MemoryMARW ddlMem = Vm.getCMARWInstance();
    private final DefaultColumnTypes defaultColumnTypes;
    private final CairoEngine engine;
    private final TableCreateException parseException = new TableCreateException();
    private final Path path = new Path();
    private final StringSink tableNameUtf16 = new StringSink();
    private final TableStructureAdapter tableStructureAdapter;
    private final LowerCaseUtf8SequenceObjHashMap<WalTableUpdateDetails> tableUpdateDetails = new LowerCaseUtf8SequenceObjHashMap();
    private final Telemetry<TelemetryTask> telemetry;
    private boolean distressed = false;

    public LineHttpTudCache(CairoEngine engine, boolean autoCreateNewColumns, boolean autoCreateNewTables, DefaultColumnTypes defaultColumnTypes, int defaultPartitionBy) {
        this.engine = engine;
        this.telemetry = engine.getTelemetry();
        this.autoCreateNewColumns = autoCreateNewColumns;
        this.autoCreateNewTables = autoCreateNewTables;
        this.defaultColumnTypes = defaultColumnTypes;
        this.tableStructureAdapter = new TableStructureAdapter(engine.getConfiguration(), this.defaultColumnTypes, defaultPartitionBy, true);
    }

    public void clear() {
        ObjList<Utf8String> keys = this.tableUpdateDetails.keys();
        int n = keys.size();
        for (int i = 0; i < n; ++i) {
            Utf8Sequence tableName = this.tableUpdateDetails.keys().get(i);
            WalTableUpdateDetails tud = this.tableUpdateDetails.get(tableName);
            if (this.distressed) {
                Misc.free(tud);
                continue;
            }
            tud.rollback();
        }
        if (this.distressed) {
            this.tableUpdateDetails.clear();
        }
    }

    @Override
    public void close() {
        ObjList<Utf8String> keys = this.tableUpdateDetails.keys();
        int n = keys.size();
        for (int i = 0; i < n; ++i) {
            Utf8Sequence tableName = this.tableUpdateDetails.keys().get(i);
            WalTableUpdateDetails tud = this.tableUpdateDetails.get(tableName);
            Misc.free(tud);
        }
        this.tableUpdateDetails.clear();
        Misc.free(this.ddlMem);
        Misc.free(this.path);
    }

    public void commitAll() throws Throwable {
        boolean droppedTableFound;
        block2: do {
            droppedTableFound = false;
            ObjList<Utf8String> keys = this.tableUpdateDetails.keys();
            int n = keys.size();
            for (int i = 0; i < n; ++i) {
                Utf8Sequence tableName = this.tableUpdateDetails.keys().get(i);
                WalTableUpdateDetails tud = this.tableUpdateDetails.get(tableName);
                try {
                    if (!tud.isDropped()) {
                        tud.commit(false);
                    }
                }
                catch (CommitFailedException e) {
                    if (!e.isTableDropped()) {
                        throw e.getReason();
                    }
                    tud.setIsDropped();
                }
                if (!tud.isDropped()) continue;
                this.tableUpdateDetails.remove(tableName);
                Misc.free(tud);
                droppedTableFound = true;
                continue block2;
            }
        } while (droppedTableFound);
    }

    public WalTableUpdateDetails getTableUpdateDetails(SecurityContext securityContext, @NotNull LineTcpParser parser, Pool<SymbolCache> symbolCachePool) throws TableCreateException {
        int key = this.tableUpdateDetails.keyIndex(parser.getMeasurementName());
        if (key < 0) {
            return this.tableUpdateDetails.valueAt(key);
        }
        this.tableNameUtf16.clear();
        Utf8s.utf8ToUtf16(parser.getMeasurementName(), this.tableNameUtf16);
        TableToken tableToken = this.getOrCreateTable(securityContext, parser, this.tableNameUtf16);
        if (!this.engine.isWalTable(tableToken)) {
            throw this.parseException.of("cannot insert in non-WAL table", null);
        }
        TelemetryTask.store(this.telemetry, (short)5, (short)102);
        this.path.of(this.engine.getConfiguration().getDbRoot());
        Utf8String nameUtf8 = Utf8String.newInstance(parser.getMeasurementName());
        WalTableUpdateDetails tud = new WalTableUpdateDetails(this.engine, securityContext, this.engine.getWalWriter(tableToken), this.defaultColumnTypes, nameUtf8, symbolCachePool, -1L, false, Long.MAX_VALUE);
        this.tableUpdateDetails.putAt(key, nameUtf8, tud);
        return tud;
    }

    public void reset() {
        ObjList<Utf8String> keys = this.tableUpdateDetails.keys();
        int n = keys.size();
        for (int i = 0; i < n; ++i) {
            Utf8Sequence tableName = this.tableUpdateDetails.keys().get(i);
            WalTableUpdateDetails tud = this.tableUpdateDetails.get(tableName);
            Misc.free(tud);
        }
        this.tableUpdateDetails.clear();
    }

    public void setDistressed() {
        this.distressed = true;
    }

    private TableToken getOrCreateTable(SecurityContext securityContext, @NotNull LineTcpParser parser, StringSink tableNameUtf16) throws TableCreateException {
        int maxFileNameLength = this.engine.getConfiguration().getMaxFileNameLength();
        if (!TableUtils.isValidTableName(tableNameUtf16, maxFileNameLength)) {
            throw this.parseException.of("invalid table name", null);
        }
        TableToken tableToken = this.engine.getTableTokenIfExists(tableNameUtf16);
        int status = this.engine.getTableStatus(this.path, tableToken);
        if (status != 0) {
            if (!this.autoCreateNewTables) {
                throw this.parseException.of("table does not exist, creating new tables is disabled", null);
            }
            if (!this.autoCreateNewColumns) {
                throw this.parseException.of("table does not exist, cannot create table, creating new columns is disabled", null);
            }
            TableStructureAdapter tsa = this.tableStructureAdapter.of(tableNameUtf16, parser);
            int n = tsa.getColumnCount();
            for (int i = 0; i < n; ++i) {
                CharSequence columnName = tsa.getColumnNameNoValidation(i);
                if (!TableUtils.isValidColumnName(columnName, maxFileNameLength)) {
                    throw this.parseException.of("invalid column name", columnName);
                }
                if (tsa.getColumnType(i) != 0) continue;
                throw this.parseException.of("invalid column type", columnName);
            }
            tableToken = this.engine.createTable(securityContext, this.ddlMem, this.path, true, tsa, false);
        }
        if (tableToken != null && tableToken.isMatView()) {
            throw this.parseException.of("cannot modify materialized view", tableToken.getTableName());
        }
        return tableToken;
    }

    public static class TableCreateException
    extends Exception {
        private String msg;
        private CharSequence token;

        public String getMsg() {
            return this.msg;
        }

        public CharSequence getToken() {
            return this.token;
        }

        TableCreateException of(String message, CharSequence token) {
            this.msg = message;
            this.token = token;
            return this;
        }
    }
}

