/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoError;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cutlass.http.HttpChunkedResponse;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpConstants;
import io.questdb.cutlass.http.HttpException;
import io.questdb.cutlass.http.HttpKeywords;
import io.questdb.cutlass.http.HttpMultipartContentProcessor;
import io.questdb.cutlass.http.HttpRequestHandler;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.cutlass.http.LocalValue;
import io.questdb.cutlass.http.ex.RetryOperationException;
import io.questdb.cutlass.http.processors.JsonQueryProcessorConfiguration;
import io.questdb.cutlass.http.processors.TextImportProcessorState;
import io.questdb.cutlass.http.processors.TextImportRequestHeaderProcessor;
import io.questdb.cutlass.http.processors.TextLoaderCompletedState;
import io.questdb.cutlass.text.TextException;
import io.questdb.cutlass.text.TextLoadWarning;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.NoSpaceLeftInResponseBufferException;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.ServerDisconnectException;
import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf16Sink;
import io.questdb.std.str.Utf8Sink;
import io.questdb.std.str.Utf8s;

public class TextImportProcessor
implements HttpMultipartContentProcessor,
HttpRequestHandler {
    static final int MESSAGE_UNKNOWN = 3;
    static final int RESPONSE_PREFIX = 1;
    private static final Log LOG = LogFactory.getLog(TextImportProcessor.class);
    private static final LocalValue<TextImportProcessorState> LV = new LocalValue();
    private static final int MESSAGE_DATA = 2;
    private static final int MESSAGE_SCHEMA = 1;
    private static final String OVERRIDDEN_FROM_TABLE = "From Table";
    private static final int RESPONSE_COLUMN = 2;
    private static final int RESPONSE_COMPLETE = 6;
    private static final int RESPONSE_DONE = 5;
    private static final int RESPONSE_ERROR = 4;
    private static final int RESPONSE_SUFFIX = 3;
    private static final int TO_STRING_COL1_PAD = 15;
    private static final int TO_STRING_COL2_PAD = 50;
    private static final int TO_STRING_COL3_PAD = 15;
    private static final int TO_STRING_COL4_PAD = 7;
    private static final int TO_STRING_COL5_PAD = 12;
    private final CairoEngine engine;
    private final TextImportRequestHeaderProcessor requestHeaderProcessor;
    private final byte requiredAuthType;
    private HttpConnectionContext transientContext;
    private TextImportProcessorState transientState;

    public TextImportProcessor(CairoEngine cairoEngine, JsonQueryProcessorConfiguration configuration) {
        this.engine = cairoEngine;
        this.requiredAuthType = configuration.getRequiredAuthType();
        this.requestHeaderProcessor = configuration.getFactoryProvider().getTextImportRequestHeaderProcessor();
    }

    @Override
    public void failRequest(HttpConnectionContext context, HttpException e) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        this.sendErrorAndThrowDisconnect(e.getFlyweightMessage());
    }

    @Override
    public HttpRequestProcessor getProcessor(HttpRequestHeader requestHeader) {
        return this;
    }

    @Override
    public byte getRequiredAuthType() {
        return this.requiredAuthType;
    }

    @Override
    public void onChunk(long lo, long hi) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        if (hi > lo) {
            try {
                this.transientState.lo = lo;
                this.transientState.hi = hi;
                this.transientState.textLoader.parse(lo, hi, this.transientContext.getSecurityContext());
                if (this.transientState.messagePart == 2 && !this.transientState.analysed) {
                    this.transientState.analysed = true;
                    this.transientState.textLoader.setState(2);
                }
            }
            catch (EntryUnavailableException e) {
                throw RetryOperationException.INSTANCE;
            }
            catch (CairoError | CairoException | TextException e) {
                this.sendErrorAndThrowDisconnect(((FlyweightMessageContainer)((Object)e)).getFlyweightMessage());
            }
        }
    }

    @Override
    public void onPartBegin(HttpRequestHeader partHeader) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        DirectUtf8Sequence contentDisposition = partHeader.getContentDispositionName();
        LOG.debug().$("part begin [name=").$(contentDisposition).$(']').$();
        if (Utf8s.equalsNcAscii("data", contentDisposition)) {
            this.requestHeaderProcessor.processRequestHeader(partHeader, this.transientContext, this.transientState);
            this.transientState.messagePart = 2;
        } else if (Utf8s.equalsNcAscii("schema", contentDisposition)) {
            this.transientState.textLoader.setState(0);
            this.transientState.messagePart = 1;
        } else if (partHeader.getContentDisposition() == null) {
            this.sendErrorAndThrowDisconnect("'Content-Disposition' multipart header missing'");
        } else {
            this.sendErrorAndThrowDisconnect("invalid value in 'Content-Disposition' multipart header");
        }
    }

    @Override
    public void onPartEnd() throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        try {
            LOG.debug().$("part end").$();
            this.transientState.textLoader.wrapUp();
            if (this.transientState.messagePart == 2) {
                this.sendResponse(this.transientContext);
            }
        }
        catch (CairoError | CairoException | TextException e) {
            this.sendErrorAndThrowDisconnect(((FlyweightMessageContainer)((Object)e)).getFlyweightMessage());
        }
    }

    @Override
    public void onRequestComplete(HttpConnectionContext context) {
        if (this.transientState != null) {
            this.transientState.clear();
        }
    }

    @Override
    public void onRequestRetry(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        this.transientContext = context;
        this.transientState = LV.get(context);
        this.onChunk(this.transientState.lo, this.transientState.hi);
    }

    @Override
    public void resumeRecv(HttpConnectionContext context) {
        this.transientContext = context;
        this.transientState = LV.get(context);
        if (this.transientState == null) {
            LOG.debug().$("new text state").$();
            this.transientState = new TextImportProcessorState(this.engine);
            LV.set(context, this.transientState);
        }
        this.transientState.json = this.isJson(context);
    }

    @Override
    public void resumeSend(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        context.resumeResponseSend();
        this.doResumeSend(LV.get(context), context.getChunkedResponse());
    }

    private static void pad(Utf8Sink b, int w, long value) {
        int len = (int)Math.log10(value);
        if (len < 0) {
            len = 0;
        }
        TextImportProcessor.replicate(b, ' ', w - len - 1);
        b.put(value);
        b.putAscii("  |");
    }

    private static Utf8Sink pad(Utf8Sink b, int w, CharSequence value) {
        int pad = value == null ? w : w - value.length();
        TextImportProcessor.replicate(b, ' ', pad);
        if (value != null) {
            if (pad < 0) {
                b.putAscii("...").put(value.subSequence(-pad + 3, value.length()));
            } else {
                b.put(value);
            }
        }
        b.putAscii("  |");
        return b;
    }

    private static void replicate(Utf8Sink b, char c, int times) {
        for (int i = 0; i < times; ++i) {
            b.put(c);
        }
    }

    private static void resumeError(TextImportProcessorState state, HttpChunkedResponse socket) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        if (state.responseState == 4) {
            socket.bookmark();
            if (state.json) {
                ((Utf8Sink)socket.putAscii('{').putAsciiQuoted("status")).putAscii(':').putQuoted(state.errorMessage).putAscii('}');
            } else {
                socket.put(state.errorMessage);
            }
            state.responseState = 5;
            socket.sendChunk(true);
        }
        socket.shutdownWrite();
        throw ServerDisconnectException.INSTANCE;
    }

    private static void resumeJson(TextImportProcessorState state, HttpChunkedResponse response) throws PeerDisconnectedException, PeerIsSlowToReadException {
        TextLoaderCompletedState completeState = state.completeState;
        RecordMetadata metadata = completeState.getMetadata();
        LongList errors = completeState.getColumnErrorCounts();
        switch (state.responseState) {
            case 1: {
                long totalRows = completeState.getParsedLineCount();
                long importedRows = completeState.getWrittenLineCount();
                ((Utf8Sink)((Utf8Sink)((Utf8Sink)((Utf8Sink)((Utf8Sink)((Utf8Sink)((Utf8Sink)((Utf8Sink)((Utf8Sink)((Utf8Sink)((Utf8Sink)response.putAscii('{').putAsciiQuoted("status")).putAscii(':').putAsciiQuoted("OK")).putAscii(',').putAsciiQuoted("location")).putAscii(':').putQuoted(completeState.getTableName()).putAscii(',').putAsciiQuoted("rowsRejected")).putAscii(':').put(totalRows - importedRows + completeState.getErrorLineCount())).putAscii(',').putAsciiQuoted("rowsImported")).putAscii(':').put(importedRows)).putAscii(',').putAsciiQuoted("header")).putAscii(':').put(completeState.isHeaderDetected())).putAscii(',').putAsciiQuoted("partitionBy")).putAscii(':').putAsciiQuoted(PartitionBy.toString(completeState.getPartitionBy()))).putAscii(',');
                int tsIdx = metadata.getTimestampIndex();
                if (tsIdx != -1) {
                    ((Utf8Sink)response.putAsciiQuoted("timestamp")).putAscii(':').putQuoted(metadata.getColumnName(tsIdx)).putAscii(',');
                }
                if (completeState.getWarnings() != 0) {
                    int warningFlags = completeState.getWarnings();
                    ((Utf8Sink)response.putAsciiQuoted("warnings")).putAscii(':').putAscii('[');
                    boolean isFirst = true;
                    if ((warningFlags & 1) != 0) {
                        isFirst = false;
                        response.putAsciiQuoted("Existing table timestamp column is used");
                    }
                    if ((warningFlags & 2) != 0) {
                        if (!isFirst) {
                            response.putAscii(',');
                        }
                        response.putAsciiQuoted("Existing table PartitionBy is used");
                    }
                    response.putAscii(']').putAscii(',');
                }
                ((Utf8Sink)response.putAsciiQuoted("columns")).putAscii(':').putAscii('[');
                state.responseState = 2;
            }
            case 2: {
                if (metadata != null) {
                    int columnCount = metadata.getColumnCount();
                    while (state.columnIndex < columnCount) {
                        response.bookmark();
                        if (state.columnIndex > 0) {
                            response.putAscii(',');
                        }
                        ((Utf8Sink)((Utf8Sink)((Utf8Sink)((Utf8Sink)((Utf8Sink)((Utf8Sink)response.putAscii('{').putAsciiQuoted("name")).putAscii(':').putQuoted(metadata.getColumnName(state.columnIndex)).putAscii(',').putAsciiQuoted("type")).putAscii(':').putAsciiQuoted(ColumnType.nameOf(metadata.getColumnType(state.columnIndex)))).putAscii(',').putAsciiQuoted("size")).putAscii(':').put(ColumnType.sizeOf(metadata.getColumnType(state.columnIndex)))).putAscii(',').putAsciiQuoted("errors")).putAscii(':').put(errors.getQuick(state.columnIndex));
                        response.putAscii('}');
                        ++state.columnIndex;
                    }
                }
                state.responseState = 3;
            }
            case 3: {
                response.bookmark();
                response.putAscii(']').putAscii('}');
                state.responseState = 6;
                response.sendChunk(true);
                break;
            }
            case 5: {
                state.responseState = 6;
                response.done();
                break;
            }
        }
    }

    private static void resumeText(TextImportProcessorState state, HttpChunkedResponse socket) throws PeerDisconnectedException, PeerIsSlowToReadException {
        TextLoaderCompletedState textLoaderCompletedState = state.completeState;
        RecordMetadata metadata = textLoaderCompletedState.getMetadata();
        LongList errors = textLoaderCompletedState.getColumnErrorCounts();
        switch (state.responseState) {
            case 1: {
                TextImportProcessor.sep(socket);
                socket.putAscii('|');
                TextImportProcessor.pad((Utf8Sink)socket, 15, "Location:");
                TextImportProcessor.pad((Utf8Sink)socket, 50, textLoaderCompletedState.getTableName());
                TextImportProcessor.pad((Utf8Sink)socket, 15, "Pattern");
                TextImportProcessor.pad((Utf8Sink)socket, 7, "Locale");
                TextImportProcessor.pad((Utf8Sink)socket, 12, "Errors").putEOL();
                socket.putAscii('|');
                TextImportProcessor.pad((Utf8Sink)socket, 15, "Partition by");
                TextImportProcessor.pad((Utf8Sink)socket, 50, PartitionBy.toString(textLoaderCompletedState.getPartitionBy()));
                TextImportProcessor.pad((Utf8Sink)socket, 15, "");
                TextImportProcessor.pad((Utf8Sink)socket, 7, "");
                if (TextLoadWarning.hasFlag(textLoaderCompletedState.getWarnings(), 2)) {
                    TextImportProcessor.pad((Utf8Sink)socket, 12, OVERRIDDEN_FROM_TABLE);
                } else {
                    TextImportProcessor.pad((Utf8Sink)socket, 12, "");
                }
                socket.putEOL();
                socket.putAscii('|');
                TextImportProcessor.pad((Utf8Sink)socket, 15, "Timestamp");
                TextImportProcessor.pad((Utf8Sink)socket, 50, textLoaderCompletedState.getTimestampCol() == null ? "NONE" : textLoaderCompletedState.getTimestampCol());
                TextImportProcessor.pad((Utf8Sink)socket, 15, "");
                TextImportProcessor.pad((Utf8Sink)socket, 7, "");
                if (TextLoadWarning.hasFlag(textLoaderCompletedState.getWarnings(), 1)) {
                    TextImportProcessor.pad((Utf8Sink)socket, 12, OVERRIDDEN_FROM_TABLE);
                } else {
                    TextImportProcessor.pad((Utf8Sink)socket, 12, "");
                }
                socket.putEOL();
                TextImportProcessor.sep(socket);
                socket.putAscii('|');
                TextImportProcessor.pad((Utf8Sink)socket, 15, "Rows handled");
                TextImportProcessor.pad((Utf8Sink)socket, 50, textLoaderCompletedState.getParsedLineCount() + textLoaderCompletedState.getErrorLineCount());
                TextImportProcessor.pad((Utf8Sink)socket, 15, "");
                TextImportProcessor.pad((Utf8Sink)socket, 7, "");
                TextImportProcessor.pad((Utf8Sink)socket, 12, "").putEOL();
                socket.putAscii('|');
                TextImportProcessor.pad((Utf8Sink)socket, 15, "Rows imported");
                TextImportProcessor.pad((Utf8Sink)socket, 50, textLoaderCompletedState.getWrittenLineCount());
                TextImportProcessor.pad((Utf8Sink)socket, 15, "");
                TextImportProcessor.pad((Utf8Sink)socket, 7, "");
                TextImportProcessor.pad((Utf8Sink)socket, 12, "").putEOL();
                TextImportProcessor.sep(socket);
                state.responseState = 2;
            }
            case 2: {
                if (metadata != null) {
                    int columnCount = metadata.getColumnCount();
                    while (state.columnIndex < columnCount) {
                        socket.bookmark();
                        socket.putAscii('|');
                        TextImportProcessor.pad((Utf8Sink)socket, 15, state.columnIndex);
                        TextImportProcessor.pad((Utf8Sink)socket, 50, metadata.getColumnName(state.columnIndex));
                        if (!metadata.isColumnIndexed(state.columnIndex)) {
                            TextImportProcessor.pad((Utf8Sink)socket, 25, ColumnType.nameOf(metadata.getColumnType(state.columnIndex)));
                        } else {
                            StringSink sink = Misc.getThreadLocalSink();
                            ((Utf16Sink)sink.put("(idx/").put(metadata.getIndexValueBlockCapacity(state.columnIndex))).put(") ");
                            sink.put(ColumnType.nameOf(metadata.getColumnType(state.columnIndex)));
                            TextImportProcessor.pad((Utf8Sink)socket, 25, sink);
                        }
                        TextImportProcessor.pad((Utf8Sink)socket, 12, errors.getQuick(state.columnIndex));
                        socket.putEOL();
                        ++state.columnIndex;
                    }
                }
                state.responseState = 3;
            }
            case 3: {
                socket.bookmark();
                TextImportProcessor.sep(socket);
                state.responseState = 6;
                socket.sendChunk(true);
                break;
            }
            case 5: {
                state.responseState = 6;
                socket.done();
                break;
            }
        }
    }

    private static void sendErr(HttpConnectionContext context, CharSequence message) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        TextImportProcessorState state = LV.get(context);
        state.responseState = 4;
        state.errorMessage = message;
        HttpChunkedResponse response = context.getChunkedResponse();
        response.status(200, state.json ? "application/json; charset=utf-8" : "text/plain; charset=utf-8");
        response.sendHeader();
        response.sendChunk(false);
        TextImportProcessor.resumeError(state, response);
    }

    private static void sep(Utf8Sink b) {
        b.putAscii('+');
        TextImportProcessor.replicate(b, '-', 113);
        b.putAscii("+\r\n");
    }

    private void doResumeSend(TextImportProcessorState state, HttpChunkedResponse socket) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        try {
            if (state.errorMessage != null) {
                TextImportProcessor.resumeError(state, socket);
            } else if (state.json) {
                TextImportProcessor.resumeJson(state, socket);
            } else {
                TextImportProcessor.resumeText(state, socket);
            }
        }
        catch (NoSpaceLeftInResponseBufferException ignored) {
            if (socket.resetToBookmark()) {
                socket.sendChunk(false);
            }
            socket.shutdownWrite();
            throw ServerDisconnectException.INSTANCE;
        }
        state.clear();
    }

    private boolean isJson(HttpConnectionContext transientContext) {
        return HttpKeywords.isJson(transientContext.getRequestHeader().getUrlParam(HttpConstants.URL_PARAM_FMT));
    }

    private void sendErrorAndThrowDisconnect(CharSequence message) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        TextImportProcessor.sendErrorAndThrowDisconnect(message, this.transientContext, this.transientState);
    }

    private void sendResponse(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        TextImportProcessorState state = LV.get(context);
        HttpChunkedResponse response = context.getChunkedResponse();
        state.snapshotStateAndCloseWriter();
        if (state.state == 0) {
            response.status(200, state.json ? "application/json; charset=utf-8" : "text/plain; charset=utf-8");
            response.sendHeader();
            this.doResumeSend(state, response);
        } else {
            TextImportProcessor.sendErr(context, state.stateMessage);
        }
    }

    static void sendErrorAndThrowDisconnect(CharSequence message, HttpConnectionContext transientContext, TextImportProcessorState transientState) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        transientState.snapshotStateAndCloseWriter();
        TextImportProcessor.sendErr(transientContext, message);
    }
}

