/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.Metrics;
import io.questdb.cutlass.line.tcp.LineTcpMeasurementEvent;
import io.questdb.cutlass.line.tcp.LineTcpMeasurementScheduler;
import io.questdb.cutlass.line.tcp.TableUpdateDetails;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.Job;
import io.questdb.mp.RingQueue;
import io.questdb.mp.Sequence;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.std.datetime.millitime.MillisecondClock;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

class LineTcpLegacyWriterJob
implements Job,
Closeable {
    private static final Log LOG = LogFactory.getLog(LineTcpLegacyWriterJob.class);
    private final ObjList<TableUpdateDetails> assignedTables;
    private final long commitInterval;
    private final Metrics metrics;
    private final MillisecondClock millisecondClock;
    private final RingQueue<LineTcpMeasurementEvent> queue;
    private final LineTcpMeasurementScheduler scheduler;
    private final Sequence sequence;
    private final int workerId;
    private long nextCommitTime;

    LineTcpLegacyWriterJob(int workerId, RingQueue<LineTcpMeasurementEvent> queue, Sequence sequence, MillisecondClock millisecondClock, long commitInterval, LineTcpMeasurementScheduler scheduler, Metrics metrics, ObjList<TableUpdateDetails> assignedTables) {
        this.workerId = workerId;
        this.queue = queue;
        this.sequence = sequence;
        this.millisecondClock = millisecondClock;
        this.commitInterval = commitInterval;
        this.nextCommitTime = millisecondClock.getTicks();
        this.scheduler = scheduler;
        this.metrics = metrics;
        this.assignedTables = assignedTables;
    }

    @Override
    public void close() {
        LOG.info().$("line protocol writer closing [workerId=").$(this.workerId).I$();
        for (int n = 0; n < this.queue.getCycle() && this.run(this.workerId, Job.TERMINATING_STATUS); ++n) {
        }
    }

    @Override
    public boolean run(int workerId, @NotNull Job.RunStatus runStatus) {
        assert (this.workerId == workerId);
        boolean busy = this.drainQueue();
        if (!busy) {
            this.commitTables();
            this.tickWriters();
        }
        return busy;
    }

    private void commitTables() {
        long wallClockMillis = this.millisecondClock.getTicks();
        if (wallClockMillis > this.nextCommitTime) {
            long minTableNextCommitTime = Long.MAX_VALUE;
            int sz = this.assignedTables.size();
            for (int n = 0; n < sz; ++n) {
                try {
                    long tableNextCommitTime = this.assignedTables.getQuick(n).commitIfIntervalElapsed(wallClockMillis);
                    wallClockMillis = this.millisecondClock.getTicks();
                    if (tableNextCommitTime >= minTableNextCommitTime) continue;
                    minTableNextCommitTime = tableNextCommitTime;
                    continue;
                }
                catch (Throwable ex) {
                    LOG.critical().$("commit failed [table=").$(this.assignedTables.getQuick(n).getTableToken()).$(",ex=").$(ex).I$();
                    this.metrics.healthMetrics().incrementUnhandledErrors();
                }
            }
            this.nextCommitTime = minTableNextCommitTime != Long.MAX_VALUE ? minTableNextCommitTime : wallClockMillis + this.commitInterval;
        }
    }

    private boolean drainQueue() {
        boolean busy = false;
        while (true) {
            long cursor;
            if ((cursor = this.sequence.next()) < 0L) {
                if (cursor == -1L) {
                    return busy;
                }
                Os.pause();
                continue;
            }
            busy = true;
            LineTcpMeasurementEvent event = this.queue.get(cursor);
            try {
                boolean closeWriter;
                TableUpdateDetails tud;
                block13: {
                    tud = event.getTableUpdateDetails();
                    closeWriter = false;
                    if (event.getWriterWorkerId() == this.workerId) {
                        try {
                            if (tud.isWriterInError()) {
                                closeWriter = true;
                                break block13;
                            }
                            if (!tud.isAssignedToJob()) {
                                this.assignedTables.add(tud);
                                tud.setAssignedToJob(true);
                                this.nextCommitTime = this.millisecondClock.getTicks();
                                LOG.info().$("assigned table to writer thread [tableName=").$(tud.getTableToken()).$(", workerId=").$(this.workerId).I$();
                            }
                            event.append();
                        }
                        catch (Throwable ex) {
                            tud.setWriterInError();
                            LOG.critical().$("closing writer because of error [table=").$(tud.getTableToken()).$(", ex=").$(ex).I$();
                            this.metrics.healthMetrics().incrementUnhandledErrors();
                            closeWriter = true;
                            event.createWriterReleaseEvent(tud, false);
                        }
                    } else if (event.getWriterWorkerId() == -3) {
                        closeWriter = true;
                    }
                }
                if (closeWriter && tud.getWriter() != null) {
                    this.scheduler.processWriterReleaseEvent(event, this.workerId);
                    this.assignedTables.remove(tud);
                    tud.setAssignedToJob(false);
                    this.nextCommitTime = this.millisecondClock.getTicks();
                }
            }
            catch (Throwable ex) {
                LOG.error().$("failed to process ILP event because of exception [ex=").$(ex).I$();
            }
            this.sequence.done(cursor);
        }
    }

    private void tickWriters() {
        int sz = this.assignedTables.size();
        for (int n = 0; n < sz; ++n) {
            this.assignedTables.getQuick(n).tick();
        }
    }
}

