/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cairo.CairoError;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.CommitFailedException;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TableWriterAPI;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.BorrowedArray;
import io.questdb.cairo.security.DenyAllSecurityContext;
import io.questdb.cutlass.line.LineTcpTimestampAdapter;
import io.questdb.cutlass.line.tcp.DefaultColumnTypes;
import io.questdb.cutlass.line.tcp.LineProtocolException;
import io.questdb.cutlass.line.tcp.LineTcpEventBuffer;
import io.questdb.cutlass.line.tcp.LineTcpParser;
import io.questdb.cutlass.line.tcp.TableUpdateDetails;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8s;
import java.io.Closeable;

public class LineTcpMeasurementEvent
implements Closeable {
    private static final Log LOG = LogFactory.getLog(LineTcpMeasurementEvent.class);
    private final boolean autoCreateNewColumns;
    private final LineTcpEventBuffer buffer;
    private final MicrosecondClock clock;
    private final DefaultColumnTypes defaultColumnTypes;
    private final int maxColumnNameLength;
    private final PrincipalOnlySecurityContext principalOnlySecurityContext = new PrincipalOnlySecurityContext();
    private final boolean stringToCharCastAllowed;
    private final LineTcpTimestampAdapter timestampAdapter;
    private boolean commitOnWriterClose;
    private TableUpdateDetails tableUpdateDetails;
    private int writerWorkerId;

    LineTcpMeasurementEvent(long bufLo, long bufSize, MicrosecondClock clock, LineTcpTimestampAdapter timestampAdapter, DefaultColumnTypes defaultColumnTypes, boolean stringToCharCastAllowed, int maxColumnNameLength, boolean autoCreateNewColumns) {
        this.maxColumnNameLength = maxColumnNameLength;
        this.autoCreateNewColumns = autoCreateNewColumns;
        this.buffer = new LineTcpEventBuffer(bufLo, bufSize);
        this.clock = clock;
        this.timestampAdapter = timestampAdapter;
        this.defaultColumnTypes = defaultColumnTypes;
        this.stringToCharCastAllowed = stringToCharCastAllowed;
    }

    @Override
    public void close() {
        this.tableUpdateDetails = Misc.free(this.tableUpdateDetails);
    }

    public TableUpdateDetails getTableUpdateDetails() {
        return this.tableUpdateDetails;
    }

    public int getWriterWorkerId() {
        return this.writerWorkerId;
    }

    public void releaseWriter() {
        this.tableUpdateDetails.releaseWriter(this.commitOnWriterClose);
    }

    void append() throws CommitFailedException {
        block33: {
            TableWriter.Row row = null;
            try {
                TableWriterAPI writer = this.tableUpdateDetails.getWriter();
                long address = this.buffer.getAddress();
                long metadataVersion = this.buffer.readLong(address);
                address += 8L;
                if (metadataVersion > writer.getMetadataVersion()) {
                    writer.commit();
                }
                long timestamp = this.buffer.readLong(address);
                address += 8L;
                if (timestamp == Long.MIN_VALUE) {
                    timestamp = this.clock.getTicks();
                }
                row = writer.newRow(timestamp);
                int nEntities = this.buffer.readInt(address);
                address += 4L;
                long writerMetadataVersion = writer.getMetadataVersion();
                block25: for (int nEntity = 0; nEntity < nEntities; ++nEntity) {
                    byte entityType;
                    int colIndex = this.buffer.readInt(address);
                    address += 4L;
                    if (colIndex > -1) {
                        entityType = this.buffer.readByte(address);
                        ++address;
                        if (metadataVersion < writerMetadataVersion && !writer.getMetadata().hasColumn(colIndex)) {
                            address += this.buffer.columnValueLength(entityType, address);
                            continue;
                        }
                    } else {
                        CharSequence columnName = this.buffer.readUtf16Chars(address, -colIndex);
                        int principalLen = this.buffer.readInt(address += (long)(-colIndex) * 2L);
                        CharSequence principal = this.buffer.readUtf16CharsB(address += 4L, principalLen);
                        entityType = this.buffer.readByte(address += (long)principalLen * 2L);
                        ++address;
                        colIndex = writer.getMetadata().getColumnIndexQuiet(columnName);
                        if (colIndex < 0) {
                            block32: {
                                row.cancel();
                                row = null;
                                int colType = this.defaultColumnTypes.MAPPED_COLUMN_TYPES[entityType];
                                try {
                                    writer.addColumn(columnName, colType, this.principalOnlySecurityContext.of(principal));
                                }
                                catch (CairoException e) {
                                    colIndex = writer.getMetadata().getColumnIndexQuiet(columnName);
                                    if (colIndex >= 0) break block32;
                                    throw e;
                                }
                            }
                            address = this.buffer.getAddressAfterHeader();
                            nEntity = -1;
                            row = writer.newRow(timestamp);
                            continue;
                        }
                    }
                    switch (entityType) {
                        case 1: {
                            CharSequence cs = this.buffer.readUtf16Chars(address);
                            row.putSym(colIndex, cs);
                            address += (long)cs.length() * 2L + 4L;
                            continue block25;
                        }
                        case 8: {
                            row.putSymIndex(colIndex, this.buffer.readInt(address));
                            address += 4L;
                            continue block25;
                        }
                        case 12: 
                        case 15: {
                            row.putLong(colIndex, this.buffer.readLong(address));
                            address += 8L;
                            continue block25;
                        }
                        case 3: 
                        case 11: {
                            row.putInt(colIndex, this.buffer.readInt(address));
                            address += 4L;
                            continue block25;
                        }
                        case 10: 
                        case 17: {
                            row.putShort(colIndex, this.buffer.readShort(address));
                            address += 2L;
                            continue block25;
                        }
                        case 9: 
                        case 18: {
                            row.putByte(colIndex, this.buffer.readByte(address));
                            ++address;
                            continue block25;
                        }
                        case 19: {
                            row.putDate(colIndex, this.buffer.readLong(address));
                            address += 8L;
                            continue block25;
                        }
                        case 16: {
                            row.putDouble(colIndex, this.buffer.readDouble(address));
                            address += 8L;
                            continue block25;
                        }
                        case 2: {
                            row.putFloat(colIndex, this.buffer.readFloat(address));
                            address += 4L;
                            continue block25;
                        }
                        case 6: {
                            row.putBool(colIndex, this.buffer.readByte(address) == 1);
                            ++address;
                            continue block25;
                        }
                        case 4: {
                            CharSequence cs = this.buffer.readUtf16Chars(address);
                            row.putStr(colIndex, cs);
                            address += (long)cs.length() * 2L + 4L;
                            continue block25;
                        }
                        case 20: {
                            row.putChar(colIndex, this.buffer.readChar(address));
                            address += 2L;
                            continue block25;
                        }
                        case 7: {
                            CharSequence cs = this.buffer.readUtf16Chars(address);
                            row.putLong256(colIndex, cs);
                            address += (long)cs.length() * 2L + 4L;
                            continue block25;
                        }
                        case 13: {
                            row.putTimestamp(colIndex, this.buffer.readLong(address));
                            address += 8L;
                            continue block25;
                        }
                        case 21: {
                            row.putLong128(colIndex, this.buffer.readLong(address), this.buffer.readLong(address + 8L));
                            address += 16L;
                            continue block25;
                        }
                        case 22: {
                            boolean ascii = this.buffer.readByte(address++) == 0;
                            Utf8Sequence s = this.buffer.readVarchar(address, ascii);
                            row.putVarchar(colIndex, s);
                            address += (long)(4 + s.size());
                            continue block25;
                        }
                        case 14: {
                            ArrayView array = this.buffer.readArray(address);
                            row.putArray(colIndex, array);
                            address += this.buffer.columnValueLength(entityType, address);
                            continue block25;
                        }
                        case 0: {
                            continue block25;
                        }
                        default: {
                            throw new UnsupportedOperationException("entityType " + entityType + " is not implemented!");
                        }
                    }
                }
                row.append();
                this.tableUpdateDetails.commitIfMaxUncommittedRowsCountReached();
            }
            catch (CairoError | CommitFailedException e) {
                throw e;
            }
            catch (Throwable th) {
                LOG.error().$("could not write line protocol measurement [tableName=").$(this.tableUpdateDetails.getTableToken()).$(", message=").$safe(th.getMessage()).$(th).I$();
                if (row == null) break block33;
                row.cancel();
            }
        }
    }

    void createMeasurementEvent(SecurityContext securityContext, TableUpdateDetails tud, LineTcpParser parser, int workerId) {
        this.writerWorkerId = -2;
        TableUpdateDetails.ThreadLocalDetails localDetails = tud.getThreadLocalDetails(workerId);
        localDetails.resetStateIfNecessary();
        this.tableUpdateDetails = tud;
        securityContext.authorizeInsert(tud.getTableToken());
        long timestamp = parser.getTimestamp();
        if (timestamp != Long.MIN_VALUE) {
            timestamp = this.timestampAdapter.getMicros(timestamp, parser.getTimestampUnit());
        }
        this.buffer.addStructureVersion(this.buffer.getAddress(), localDetails.getMetadataVersion());
        long offset = this.buffer.getAddressAfterHeader();
        int entitiesWritten = 0;
        int n = parser.getEntityCount();
        block63: for (int nEntity = 0; nEntity < n; ++nEntity) {
            int colType;
            LineTcpParser.ProtoEntity entity = parser.getEntity(nEntity);
            byte entityType = entity.getType();
            int columnWriterIndex = localDetails.getColumnWriterIndex(entity.getName());
            if (columnWriterIndex > -1) {
                if (columnWriterIndex == tud.getTimestampIndex()) {
                    timestamp = this.timestampAdapter.getMicros(entity.getLongValue(), entity.getUnit());
                    continue;
                }
                offset = this.buffer.addColumnIndex(offset, columnWriterIndex);
                colType = localDetails.getColumnType(columnWriterIndex);
            } else {
                if (columnWriterIndex != -1) continue;
                String colNameUtf16 = localDetails.getColNameUtf16();
                if (this.autoCreateNewColumns && TableUtils.isValidColumnName(colNameUtf16, this.maxColumnNameLength)) {
                    securityContext.authorizeAlterTableAddColumn(tud.getTableToken());
                    offset = this.buffer.addColumnName(offset, colNameUtf16, securityContext.getPrincipal());
                    colType = localDetails.getColumnType(localDetails.getColNameUtf8(), entity);
                } else {
                    if (!this.autoCreateNewColumns) {
                        throw LineProtocolException.newColumnsNotAllowed(colNameUtf16, this.tableUpdateDetails.getTableNameUtf16());
                    }
                    throw LineProtocolException.invalidColNameError(colNameUtf16, this.tableUpdateDetails.getTableNameUtf16());
                }
            }
            ++entitiesWritten;
            switch (entityType) {
                case 3: {
                    switch (ColumnType.tagOf(colType)) {
                        case 6: {
                            offset = this.buffer.addLong(offset, entity.getLongValue());
                            continue block63;
                        }
                        case 5: {
                            long entityValue = entity.getLongValue();
                            if (entityValue >= Integer.MIN_VALUE && entityValue <= Integer.MAX_VALUE) {
                                offset = this.buffer.addInt(offset, (int)entityValue);
                                continue block63;
                            }
                            if (entityValue == Long.MIN_VALUE) {
                                offset = this.buffer.addInt(offset, Integer.MIN_VALUE);
                                continue block63;
                            }
                            throw LineProtocolException.boundsError(entityValue, 5, (CharSequence)tud.getTableNameUtf16(), nEntity);
                        }
                        case 3: {
                            long entityValue = entity.getLongValue();
                            if (entityValue >= -32768L && entityValue <= 32767L) {
                                offset = this.buffer.addShort(offset, (short)entityValue);
                                continue block63;
                            }
                            if (entityValue == Long.MIN_VALUE) {
                                offset = this.buffer.addShort(offset, (short)0);
                                continue block63;
                            }
                            throw LineProtocolException.boundsError(entityValue, 3, (CharSequence)tud.getTableNameUtf16(), nEntity);
                        }
                        case 2: {
                            long entityValue = entity.getLongValue();
                            if (entityValue >= -128L && entityValue <= 127L) {
                                offset = this.buffer.addByte(offset, (byte)entityValue);
                                continue block63;
                            }
                            if (entityValue == Long.MIN_VALUE) {
                                offset = this.buffer.addByte(offset, (byte)0);
                                continue block63;
                            }
                            throw LineProtocolException.boundsError(entityValue, 2, (CharSequence)tud.getTableNameUtf16(), nEntity);
                        }
                        case 8: {
                            long timestampValue = LineTcpTimestampAdapter.TS_COLUMN_INSTANCE.getMicros(entity.getLongValue(), (byte)0);
                            offset = this.buffer.addTimestamp(offset, timestampValue);
                            continue block63;
                        }
                        case 7: {
                            offset = this.buffer.addDate(offset, entity.getLongValue());
                            continue block63;
                        }
                        case 10: {
                            offset = this.buffer.addDouble(offset, entity.getLongValue());
                            continue block63;
                        }
                        case 9: {
                            offset = this.buffer.addFloat(offset, entity.getLongValue());
                            continue block63;
                        }
                        case 12: {
                            offset = this.buffer.addSymbol(offset, entity.getValue(), localDetails.getSymbolLookup(columnWriterIndex));
                            continue block63;
                        }
                    }
                    throw LineProtocolException.castError(tud.getTableNameUtf16(), "integer", colType, entity.getName());
                }
                case 2: {
                    switch (ColumnType.tagOf(colType)) {
                        case 10: {
                            offset = this.buffer.addDouble(offset, entity.getFloatValue());
                            continue block63;
                        }
                        case 9: {
                            offset = this.buffer.addFloat(offset, (float)entity.getFloatValue());
                            continue block63;
                        }
                        case 12: {
                            offset = this.buffer.addSymbol(offset, entity.getValue(), localDetails.getSymbolLookup(columnWriterIndex));
                            continue block63;
                        }
                    }
                    throw LineProtocolException.castError(tud.getTableNameUtf16(), "float", colType, entity.getName());
                }
                case 4: {
                    int colTypeMeta = localDetails.getColumnTypeMeta(columnWriterIndex);
                    DirectUtf8Sequence entityValue = entity.getValue();
                    if (colTypeMeta == 0) {
                        switch (ColumnType.tagOf(colType)) {
                            case 25: {
                                try {
                                    int value = Numbers.parseIPv4Nl(entityValue);
                                    offset = this.buffer.addInt(offset, value);
                                    continue block63;
                                }
                                catch (NumericException e) {
                                    throw LineProtocolException.castError(tud.getTableNameUtf16(), "string", colType, entity.getName());
                                }
                            }
                            case 11: {
                                offset = this.buffer.addString(offset, entityValue);
                                continue block63;
                            }
                            case 26: {
                                offset = this.buffer.addVarchar(offset, entityValue);
                                continue block63;
                            }
                            case 4: {
                                if (entityValue.size() == 1 && entityValue.byteAt(0) > -1) {
                                    offset = this.buffer.addChar(offset, (char)entityValue.byteAt(0));
                                    continue block63;
                                }
                                if (this.stringToCharCastAllowed) {
                                    int encodedResult = Utf8s.utf8CharDecode(entityValue);
                                    if (Numbers.decodeLowShort(encodedResult) > 0) {
                                        offset = this.buffer.addChar(offset, (char)Numbers.decodeHighShort(encodedResult));
                                        continue block63;
                                    }
                                    throw LineProtocolException.castError(tud.getTableNameUtf16(), "string", colType, entity.getName());
                                }
                            }
                            throw LineProtocolException.castError(tud.getTableNameUtf16(), "string", colType, entity.getName());
                            case 12: {
                                offset = this.buffer.addSymbol(offset, entityValue, localDetails.getSymbolLookup(columnWriterIndex));
                                continue block63;
                            }
                            case 19: {
                                try {
                                    offset = this.buffer.addUuid(offset, entityValue);
                                    continue block63;
                                }
                                catch (NumericException e) {
                                    throw LineProtocolException.castError(tud.getTableNameUtf16(), "string", colType, entity.getName());
                                }
                            }
                        }
                        throw LineProtocolException.castError(tud.getTableNameUtf16(), "string", colType, entity.getName());
                    }
                    offset = this.buffer.addGeoHash(offset, entityValue, colTypeMeta);
                    continue block63;
                }
                case 7: {
                    switch (ColumnType.tagOf(colType)) {
                        case 13: {
                            offset = this.buffer.addLong256(offset, entity.getValue());
                            continue block63;
                        }
                        case 12: {
                            offset = this.buffer.addSymbol(offset, entity.getValue(), localDetails.getSymbolLookup(columnWriterIndex));
                            continue block63;
                        }
                    }
                    throw LineProtocolException.castError(tud.getTableNameUtf16(), "long256", colType, entity.getName());
                }
                case 6: {
                    byte entityValue = (byte)(entity.getBooleanValue() ? 1 : 0);
                    switch (ColumnType.tagOf(colType)) {
                        case 1: {
                            offset = this.buffer.addBoolean(offset, entityValue);
                            continue block63;
                        }
                        case 2: {
                            offset = this.buffer.addByte(offset, entityValue);
                            continue block63;
                        }
                        case 3: {
                            offset = this.buffer.addShort(offset, entityValue);
                            continue block63;
                        }
                        case 5: {
                            offset = this.buffer.addInt(offset, entityValue);
                            continue block63;
                        }
                        case 6: {
                            offset = this.buffer.addLong(offset, entityValue);
                            continue block63;
                        }
                        case 9: {
                            offset = this.buffer.addFloat(offset, entityValue);
                            continue block63;
                        }
                        case 10: {
                            offset = this.buffer.addDouble(offset, entityValue);
                            continue block63;
                        }
                        case 12: {
                            offset = this.buffer.addSymbol(offset, entity.getValue(), localDetails.getSymbolLookup(columnWriterIndex));
                            continue block63;
                        }
                    }
                    throw LineProtocolException.castError(tud.getTableNameUtf16(), "boolean", colType, entity.getName());
                }
                case 13: {
                    switch (ColumnType.tagOf(colType)) {
                        case 8: {
                            long timestampValue = LineTcpTimestampAdapter.TS_COLUMN_INSTANCE.getMicros(entity.getLongValue(), entity.getUnit());
                            offset = this.buffer.addTimestamp(offset, timestampValue);
                            continue block63;
                        }
                        case 7: {
                            long dateValue = LineTcpTimestampAdapter.TS_COLUMN_INSTANCE.getMicros(entity.getLongValue(), entity.getUnit());
                            offset = this.buffer.addDate(offset, dateValue / 1000L);
                            continue block63;
                        }
                        case 12: {
                            offset = this.buffer.addSymbol(offset, entity.getValue(), localDetails.getSymbolLookup(columnWriterIndex));
                            continue block63;
                        }
                    }
                    throw LineProtocolException.castError(tud.getTableNameUtf16(), "timestamp", colType, entity.getName());
                }
                case 1: 
                case 5: {
                    switch (colType) {
                        case 12: {
                            offset = this.buffer.addSymbol(offset, entity.getValue(), localDetails.getSymbolLookup(columnWriterIndex));
                            continue block63;
                        }
                        case 26: {
                            offset = this.buffer.addVarchar(offset, entity.getValue());
                            continue block63;
                        }
                        case 11: {
                            offset = this.buffer.addString(offset, entity.getValue());
                            continue block63;
                        }
                    }
                    throw LineProtocolException.castError(tud.getTableNameUtf16(), "symbol", colType, entity.getName());
                }
                case 14: {
                    BorrowedArray array = entity.getArray();
                    if (array.getType() != colType && !array.isNull()) {
                        throw LineProtocolException.castError(tud.getTableNameUtf16(), ColumnType.nameOf(array.getType()), colType, entity.getName());
                    }
                    offset = this.buffer.addArray(offset, array);
                    continue block63;
                }
                case 0: {
                    offset = this.buffer.addNull(offset);
                    continue block63;
                }
            }
        }
        this.buffer.addDesignatedTimestamp(this.buffer.getAddress() + 8L, timestamp);
        this.buffer.addNumOfColumns(this.buffer.getAddress() + 16L, entitiesWritten);
        this.writerWorkerId = tud.getWriterThreadId();
    }

    void createWriterReleaseEvent(TableUpdateDetails tableUpdateDetails, boolean commitOnWriterClose) {
        this.writerWorkerId = -3;
        this.tableUpdateDetails = tableUpdateDetails;
        this.commitOnWriterClose = commitOnWriterClose;
    }

    private static class PrincipalOnlySecurityContext
    extends DenyAllSecurityContext {
        private CharSequence principal;

        private PrincipalOnlySecurityContext() {
        }

        @Override
        public CharSequence getPrincipal() {
            return this.principal;
        }

        public PrincipalOnlySecurityContext of(CharSequence principal) {
            this.principal = principal;
            return this;
        }
    }
}

