/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.arr.BorrowedArray;
import io.questdb.cutlass.line.tcp.ArrayBinaryFormatParser;
import io.questdb.griffin.SqlKeywords;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.IntHashSet;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.QuietCloseable;
import io.questdb.std.Unsafe;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.DirectUtf8String;
import org.jetbrains.annotations.NotNull;

public class LineTcpParser
implements QuietCloseable {
    public static final byte ENTITY_TYPE_ARRAY = 14;
    public static final byte ENTITY_TYPE_BOOLEAN = 6;
    public static final byte ENTITY_TYPE_BYTE = 18;
    public static final byte ENTITY_TYPE_CACHED_TAG = 8;
    public static final byte ENTITY_TYPE_CHAR = 20;
    public static final byte ENTITY_TYPE_DATE = 19;
    public static final byte ENTITY_TYPE_DOUBLE = 16;
    public static final byte ENTITY_TYPE_FLOAT = 2;
    public static final byte ENTITY_TYPE_GEOBYTE = 9;
    public static final byte ENTITY_TYPE_GEOINT = 11;
    public static final byte ENTITY_TYPE_GEOLONG = 12;
    public static final byte ENTITY_TYPE_GEOSHORT = 10;
    public static final byte ENTITY_TYPE_INTEGER = 3;
    public static final byte ENTITY_TYPE_LONG = 15;
    public static final byte ENTITY_TYPE_LONG256 = 7;
    public static final byte ENTITY_TYPE_NONE = -1;
    public static final byte ENTITY_TYPE_NULL = 0;
    public static final byte ENTITY_TYPE_SHORT = 17;
    public static final byte ENTITY_TYPE_STRING = 4;
    public static final byte ENTITY_TYPE_SYMBOL = 5;
    public static final byte ENTITY_TYPE_TAG = 1;
    public static final byte ENTITY_TYPE_TIMESTAMP = 13;
    public static final byte ENTITY_TYPE_UUID = 21;
    public static final byte ENTITY_TYPE_VARCHAR = 22;
    public static final byte ENTITY_UNIT_NONE = 0;
    public static final byte ENTITY_UNIT_NANO = 1;
    public static final byte ENTITY_UNIT_MICRO = 2;
    public static final byte ENTITY_UNIT_MILLI = 3;
    public static final byte ENTITY_UNIT_SECOND = 4;
    public static final byte ENTITY_UNIT_MINUTE = 5;
    public static final byte ENTITY_UNIT_HOUR = 6;
    public static final long NULL_TIMESTAMP = Long.MIN_VALUE;
    public static final int N_ENTITY_TYPES = 15;
    public static final int N_MAPPED_ENTITY_TYPES = 23;
    private static final byte ENTITY_HANDLER_NAME = 1;
    private static final byte ENTITY_HANDLER_NEW_LINE = 4;
    private static final byte ENTITY_HANDLER_TABLE = 0;
    private static final byte ENTITY_HANDLER_TIMESTAMP = 3;
    private static final byte ENTITY_HANDLER_VALUE = 2;
    private static final Log LOG = LogFactory.getLog(LineTcpParser.class);
    private static final IntHashSet binaryFormatSupportType = new IntHashSet();
    private static final boolean[] controlBytes;
    private final CairoConfiguration cairoConfiguration;
    private final DirectUtf8String charSeq = new DirectUtf8String();
    private final ObjList<ProtoEntity> entityCache = new ObjList();
    private final DirectUtf8String measurementName = new DirectUtf8String();
    private boolean asciiSegment;
    private BinaryFormatStreamStep binaryFormatStreamStep = BinaryFormatStreamStep.NotINBinaryFormat;
    private long bufAt;
    private ProtoEntity currentEntity;
    private byte entityHandler = (byte)-1;
    private long entityLo;
    private ErrorCode errorCode;
    private boolean isQuotedFieldValue;
    private int nEntities;
    private int nEscapedChars;
    private int nQuoteCharacters;
    private boolean nextValueCanBeOpenQuote;
    private boolean scape;
    private boolean tagsComplete;
    private long timestamp;
    private byte timestampUnit;

    public LineTcpParser(CairoConfiguration configuration) {
        this.cairoConfiguration = configuration;
    }

    @Override
    public void close() {
        Misc.freeObjList(this.entityCache);
    }

    public long getBufferAddress() {
        return this.bufAt;
    }

    public ProtoEntity getEntity(int n) {
        assert (n < this.nEntities);
        return this.entityCache.get(n);
    }

    public int getEntityCount() {
        return this.nEntities;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public DirectUtf8Sequence getErrorFieldValue() {
        if (this.currentEntity != null) {
            return this.currentEntity.value;
        }
        return null;
    }

    public DirectUtf8Sequence getErrorTimestampValue() {
        return this.charSeq;
    }

    public DirectUtf8Sequence getLastEntityName() {
        if (this.currentEntity != null) {
            return this.currentEntity.getName();
        }
        return null;
    }

    public DirectUtf8Sequence getMeasurementName() {
        return this.measurementName;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public byte getTimestampUnit() {
        return this.timestampUnit;
    }

    public boolean hasTimestamp() {
        return this.timestamp != Long.MIN_VALUE;
    }

    public LineTcpParser of(long bufLo) {
        this.bufAt = bufLo - 1L;
        this.startNextMeasurement();
        return this;
    }

    public ParseResult parseMeasurement(long bufHi) {
        assert (this.bufAt != 0L && bufHi >= this.bufAt);
        if (this.nQuoteCharacters == 1 && this.tagsComplete && this.entityHandler == 2) {
            if (!this.prepareQuotedEntity(this.entityLo, bufHi)) {
                if (this.errorCode == ErrorCode.INVALID_FIELD_VALUE_STR_UNDERFLOW) {
                    return ParseResult.BUFFER_UNDERFLOW;
                }
                return ParseResult.ERROR;
            }
            this.nQuoteCharacters = 0;
            ++this.bufAt;
        } else if (this.binaryFormatStreamStep != BinaryFormatStreamStep.NotINBinaryFormat) {
            if (!this.expectBinaryFormat(bufHi)) {
                if (this.errorCode == ErrorCode.INVALID_FIELD_VALUE_STR_UNDERFLOW) {
                    return ParseResult.BUFFER_UNDERFLOW;
                }
                return ParseResult.ERROR;
            }
            ++this.bufAt;
            this.binaryFormatStreamStep = BinaryFormatStreamStep.NotINBinaryFormat;
        }
        while (this.bufAt < bufHi) {
            byte b = Unsafe.getUnsafe().getByte(this.bufAt);
            if (this.nEscapedChars == 0 && !controlBytes[b & 0xFF]) {
                this.nextValueCanBeOpenQuote = false;
                ++this.bufAt;
                continue;
            }
            this.asciiSegment &= b >= 0;
            boolean endOfLine = false;
            boolean appendByte = false;
            switch (b) {
                case 10: 
                case 13: {
                    endOfLine = true;
                    b = 10;
                }
                case 32: 
                case 44: 
                case 61: {
                    this.isQuotedFieldValue = false;
                    if (!this.completeEntity(b, bufHi)) {
                        if (this.errorCode == ErrorCode.EMPTY_LINE) {
                            this.entityLo = ++this.bufAt;
                            break;
                        }
                        if (this.errorCode == ErrorCode.INVALID_FIELD_VALUE_STR_UNDERFLOW) {
                            return ParseResult.BUFFER_UNDERFLOW;
                        }
                        return ParseResult.ERROR;
                    }
                    if (endOfLine) {
                        if (this.nEntities > 0) {
                            this.entityHandler = (byte)4;
                            return ParseResult.MEASUREMENT_COMPLETE;
                        }
                        this.errorCode = ErrorCode.NO_FIELDS;
                        return ParseResult.ERROR;
                    }
                    ++this.bufAt;
                    if (this.isQuotedFieldValue) break;
                    this.nEscapedChars = 0;
                    this.entityLo = this.bufAt;
                    break;
                }
                case 92: {
                    if (this.bufAt + 1L >= bufHi) {
                        return ParseResult.BUFFER_UNDERFLOW;
                    }
                    ++this.nEscapedChars;
                    ++this.bufAt;
                    b = Unsafe.getUnsafe().getByte(this.bufAt);
                    if (b == 92 && this.entityHandler != 2) {
                        return this.getError(bufHi);
                    }
                    this.asciiSegment &= b >= 0;
                    appendByte = true;
                    break;
                }
                case 34: {
                    if (this.nextValueCanBeOpenQuote && ++this.nQuoteCharacters == 1) {
                        ++this.bufAt;
                        if (!this.prepareQuotedEntity(this.bufAt - 1L, bufHi)) {
                            if (this.errorCode == ErrorCode.INVALID_FIELD_VALUE_STR_UNDERFLOW) {
                                return ParseResult.BUFFER_UNDERFLOW;
                            }
                            return ParseResult.ERROR;
                        }
                        this.errorCode = ErrorCode.NONE;
                        this.nQuoteCharacters = 0;
                        ++this.bufAt;
                        break;
                    }
                    if (this.isQuotedFieldValue) {
                        return this.getError(bufHi);
                    }
                }
                default: {
                    appendByte = true;
                    this.nextValueCanBeOpenQuote = false;
                    break;
                }
                case 0: {
                    LOG.info().$("could not parse [byte=\\0]").$();
                    return this.getError(bufHi);
                }
                case 47: {
                    if (this.entityHandler != 2) {
                        LOG.info().$("could not parse [byte=/]").$();
                        return this.getError(bufHi);
                    }
                    appendByte = true;
                    this.nextValueCanBeOpenQuote = false;
                }
            }
            if (!appendByte) continue;
            if (this.nEscapedChars > 0) {
                Unsafe.getUnsafe().putByte(this.bufAt - (long)this.nEscapedChars, b);
            }
            ++this.bufAt;
        }
        return ParseResult.BUFFER_UNDERFLOW;
    }

    public void shl(long shl) {
        this.bufAt -= shl;
        this.entityLo -= shl;
        this.measurementName.shl(shl);
        this.charSeq.shl(shl);
        for (int i = 0; i < this.nEntities; ++i) {
            this.entityCache.getQuick(i).shl(shl);
        }
    }

    public ParseResult skipMeasurement(long bufHi) {
        assert (this.bufAt != 0L && bufHi >= this.bufAt);
        while (this.bufAt < bufHi) {
            byte b = Unsafe.getUnsafe().getByte(this.bufAt);
            if (b == 10 || b == 13) {
                return ParseResult.MEASUREMENT_COMPLETE;
            }
            ++this.bufAt;
        }
        return ParseResult.BUFFER_UNDERFLOW;
    }

    public void startNextMeasurement() {
        ++this.bufAt;
        this.nEscapedChars = 0;
        this.isQuotedFieldValue = false;
        this.entityLo = this.bufAt;
        this.tagsComplete = false;
        this.nEntities = 0;
        this.currentEntity = null;
        this.entityHandler = 0;
        this.timestamp = Long.MIN_VALUE;
        this.timestampUnit = 0;
        this.errorCode = ErrorCode.NONE;
        this.nQuoteCharacters = 0;
        this.scape = false;
        this.nextValueCanBeOpenQuote = false;
        this.asciiSegment = true;
        this.binaryFormatStreamStep = BinaryFormatStreamStep.NotINBinaryFormat;
    }

    private boolean completeEntity(byte endOfEntityByte, long bufHi) {
        switch (this.entityHandler) {
            case 0: {
                return this.expectTableName(endOfEntityByte);
            }
            case 1: {
                return this.expectEntityName(endOfEntityByte, bufHi);
            }
            case 2: {
                return this.expectEntityValue(endOfEntityByte, bufHi);
            }
            case 3: {
                return this.expectTimestamp(endOfEntityByte);
            }
            case 4: {
                return this.expectEndOfLine(endOfEntityByte);
            }
        }
        return false;
    }

    private boolean expectBinaryFormat(long bufHi) {
        assert (this.binaryFormatStreamStep != BinaryFormatStreamStep.NotINBinaryFormat);
        if (this.binaryFormatStreamStep == BinaryFormatStreamStep.INBinaryFormat) {
            if (!this.currentEntity.parseBinaryFormat(bufHi)) {
                return false;
            }
            this.binaryFormatStreamStep = BinaryFormatStreamStep.ExpectFieldSeparator;
        }
        if (this.bufAt + 1L < bufHi) {
            long next = this.bufAt + 1L;
            byte expectSeparator = Unsafe.getUnsafe().getByte(next);
            if (expectSeparator == 32) {
                this.entityHandler = (byte)3;
                ++this.bufAt;
                this.entityLo = this.bufAt + 1L;
                return true;
            }
            if (expectSeparator == 10 || expectSeparator == 13) {
                this.entityHandler = (byte)3;
                this.entityLo = this.bufAt + 1L;
                return true;
            }
            if (expectSeparator == 44) {
                this.entityHandler = 1;
                ++this.bufAt;
                this.entityLo = this.bufAt + 1L;
                return true;
            }
            this.entityLo = this.bufAt;
            this.errorCode = ErrorCode.INVALID_FIELD_SEPARATOR;
            return false;
        }
        this.errorCode = ErrorCode.INVALID_FIELD_VALUE_STR_UNDERFLOW;
        return false;
    }

    private boolean expectEndOfLine(byte endOfEntityByte) {
        assert (endOfEntityByte == 10);
        return true;
    }

    private boolean expectEntityName(byte endOfEntityByte, long bufHi) {
        boolean emptyEntity;
        if (endOfEntityByte == 61) {
            if (this.bufAt - this.entityLo - (long)this.nEscapedChars == 0L) {
                this.errorCode = this.tagsComplete ? ErrorCode.INCOMPLETE_FIELD : ErrorCode.INCOMPLETE_TAG;
                return false;
            }
            this.currentEntity = this.popEntity();
            ++this.nEntities;
            this.currentEntity.setName();
            this.entityHandler = (byte)2;
            if (this.tagsComplete) {
                if (this.bufAt + 3L < bufHi) {
                    long candidateQuoteIdx = this.bufAt + 1L;
                    byte b = Unsafe.getUnsafe().getByte(candidateQuoteIdx);
                    if (b == 34) {
                        this.nEscapedChars = 0;
                        ++this.nQuoteCharacters;
                        this.bufAt += 2L;
                        return this.prepareQuotedEntity(candidateQuoteIdx, bufHi);
                    }
                    this.nextValueCanBeOpenQuote = false;
                } else {
                    this.nextValueCanBeOpenQuote = true;
                }
            }
            return true;
        }
        boolean bl = emptyEntity = this.bufAt == this.entityLo;
        if (emptyEntity) {
            if (endOfEntityByte == 32) {
                if (this.tagsComplete) {
                    this.entityHandler = (byte)3;
                } else {
                    this.tagsComplete = true;
                }
                return true;
            }
            if (endOfEntityByte == 10) {
                return true;
            }
        } else if (this.tagsComplete && (endOfEntityByte == 10 || endOfEntityByte == 13) && this.currentEntity != null && this.currentEntity.getType() == 1) {
            return this.expectTimestamp(endOfEntityByte);
        }
        if (!emptyEntity) {
            this.currentEntity = this.popEntity();
            ++this.nEntities;
            this.currentEntity.setName();
        }
        this.errorCode = this.tagsComplete ? ErrorCode.MISSING_FIELD_VALUE : ErrorCode.MISSING_TAG_VALUE;
        return false;
    }

    private boolean expectEntityValue(byte endOfEntityByte, long bufHi) {
        boolean endOfSet;
        boolean bl = endOfSet = endOfEntityByte == 32;
        if (endOfSet || endOfEntityByte == 44 || endOfEntityByte == 10) {
            if (this.currentEntity.setValueAndUnit()) {
                if (endOfSet) {
                    if (this.tagsComplete) {
                        this.entityHandler = (byte)3;
                    } else {
                        this.entityHandler = 1;
                        this.tagsComplete = true;
                    }
                } else {
                    this.entityHandler = 1;
                }
                return true;
            }
            this.errorCode = this.tagsComplete ? ErrorCode.INVALID_FIELD_VALUE : ErrorCode.INVALID_TAG_VALUE;
            return false;
        }
        if (endOfEntityByte == 61 && this.bufAt == this.entityLo && this.tagsComplete) {
            this.binaryFormatStreamStep = BinaryFormatStreamStep.INBinaryFormat;
            ++this.bufAt;
            if (this.expectBinaryFormat(bufHi)) {
                this.binaryFormatStreamStep = BinaryFormatStreamStep.NotINBinaryFormat;
                return true;
            }
            return false;
        }
        this.errorCode = ErrorCode.INVALID_FIELD_SEPARATOR;
        return false;
    }

    private boolean expectTableName(byte endOfEntityByte) {
        boolean bl = this.tagsComplete = endOfEntityByte == 32;
        if (endOfEntityByte == 44 || this.tagsComplete) {
            long hi = this.bufAt - (long)this.nEscapedChars;
            this.measurementName.of(this.entityLo, hi, this.asciiSegment);
            this.asciiSegment = true;
            this.entityHandler = 1;
            return true;
        }
        this.errorCode = this.entityLo == this.bufAt ? ErrorCode.EMPTY_LINE : ErrorCode.NO_FIELDS;
        return false;
    }

    private boolean expectTimestamp(byte endOfEntityByte) {
        try {
            if (endOfEntityByte == 10) {
                long entityHi = this.bufAt - (long)this.nEscapedChars;
                if (this.entityLo < entityHi) {
                    this.charSeq.of(this.entityLo, entityHi, this.asciiSegment);
                    this.asciiSegment = true;
                    int charSeqLen = this.charSeq.size();
                    byte last = this.charSeq.byteAt(charSeqLen - 1);
                    switch (last) {
                        case 110: {
                            this.timestampUnit = 1;
                            this.timestamp = Numbers.parseLong(this.charSeq.decHi());
                            break;
                        }
                        case 116: {
                            this.timestampUnit = (byte)2;
                            this.timestamp = Numbers.parseLong(this.charSeq.decHi());
                            break;
                        }
                        case 109: {
                            this.timestampUnit = (byte)3;
                            this.timestamp = Numbers.parseLong(this.charSeq.decHi());
                            break;
                        }
                        default: {
                            this.timestamp = Numbers.parseLong(this.charSeq);
                        }
                    }
                }
                this.entityHandler = (byte)-1;
                return true;
            }
            this.errorCode = ErrorCode.INVALID_FIELD_SEPARATOR;
            return false;
        }
        catch (NumericException ex) {
            this.timestampUnit = 0;
            this.errorCode = ErrorCode.INVALID_TIMESTAMP;
            return false;
        }
    }

    private ParseResult getError(long bufHi) {
        switch (this.entityHandler) {
            case 1: {
                if (this.bufAt > this.entityLo && this.bufAt < bufHi) {
                    this.currentEntity = this.popEntity();
                    ++this.nEntities;
                    this.currentEntity.setName(Math.min(this.bufAt + 1L, bufHi));
                }
                this.errorCode = ErrorCode.INVALID_COLUMN_NAME;
                break;
            }
            case 0: {
                this.errorCode = ErrorCode.INVALID_TABLE_NAME;
                break;
            }
            case 2: {
                this.errorCode = ErrorCode.INVALID_FIELD_VALUE;
            }
        }
        return ParseResult.ERROR;
    }

    private ProtoEntity popEntity() {
        ProtoEntity currentEntity;
        if (this.entityCache.size() <= this.nEntities) {
            currentEntity = new ProtoEntity();
            this.entityCache.add(currentEntity);
        } else {
            currentEntity = this.entityCache.get(this.nEntities);
            currentEntity.clear();
        }
        return currentEntity;
    }

    private boolean prepareQuotedEntity(long openQuoteIdx, long bufHi) {
        this.entityLo = openQuoteIdx;
        while (this.bufAt < bufHi) {
            byte b = Unsafe.getUnsafe().getByte(this.bufAt);
            boolean copyByte = true;
            this.asciiSegment &= b >= 0;
            switch (b) {
                case 92: {
                    if (!this.scape) {
                        ++this.nEscapedChars;
                        copyByte = false;
                    }
                    this.scape = !this.scape;
                    break;
                }
                case 34: {
                    if (!this.scape) {
                        this.isQuotedFieldValue = true;
                        --this.nQuoteCharacters;
                        if (this.nEscapedChars > 0) {
                            Unsafe.getUnsafe().putByte(this.bufAt - (long)this.nEscapedChars, b);
                        }
                        return true;
                    }
                    this.scape = false;
                    break;
                }
                case 10: {
                    if (!this.scape) {
                        this.errorCode = ErrorCode.INVALID_FIELD_VALUE;
                        return false;
                    }
                    this.scape = false;
                    break;
                }
                default: {
                    this.scape = false;
                }
            }
            this.nextValueCanBeOpenQuote = false;
            if (copyByte && this.nEscapedChars > 0) {
                Unsafe.getUnsafe().putByte(this.bufAt - (long)this.nEscapedChars, b);
            }
            ++this.bufAt;
        }
        this.errorCode = ErrorCode.INVALID_FIELD_VALUE_STR_UNDERFLOW;
        return false;
    }

    static {
        char[] chars = new char[]{'\n', '\r', '=', ',', ' ', '\\', '\"', '\u0000', '/'};
        controlBytes = new boolean[256];
        for (char ch : chars) {
            LineTcpParser.controlBytes[ch] = true;
        }
        for (int i = 128; i < 256; ++i) {
            LineTcpParser.controlBytes[i] = true;
        }
        binaryFormatSupportType.add(6);
        binaryFormatSupportType.add(2);
        binaryFormatSupportType.add(16);
        binaryFormatSupportType.add(3);
        binaryFormatSupportType.add(15);
        binaryFormatSupportType.add(13);
        binaryFormatSupportType.add(14);
    }

    private static enum BinaryFormatStreamStep {
        NotINBinaryFormat,
        ExpectFieldSeparator,
        INBinaryFormat;

    }

    public class ProtoEntity
    implements QuietCloseable {
        private final ArrayBinaryFormatParser arrayBinaryParser = new ArrayBinaryFormatParser();
        private final DirectUtf8String name = new DirectUtf8String();
        private final DirectUtf8String value = new DirectUtf8String();
        private boolean booleanValue;
        private double floatValue;
        private long longValue;
        private byte type = (byte)-1;
        private byte unit = 0;

        @Override
        public void close() {
            Misc.free(this.arrayBinaryParser);
        }

        @NotNull
        public BorrowedArray getArray() {
            return this.arrayBinaryParser.getArray();
        }

        public boolean getBooleanValue() {
            return this.booleanValue;
        }

        public double getFloatValue() {
            return this.floatValue;
        }

        public long getLongValue() {
            return this.longValue;
        }

        public DirectUtf8Sequence getName() {
            return this.name;
        }

        public byte getType() {
            return this.type;
        }

        public byte getUnit() {
            return this.unit;
        }

        public DirectUtf8Sequence getValue() {
            return this.value;
        }

        public void shl(long shl) {
            this.name.shl(shl);
            this.value.shl(shl);
            this.arrayBinaryParser.shl(shl);
        }

        private void clear() {
            this.type = (byte)-1;
            this.unit = 0;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean parse(byte last, int valueLen) {
            switch (last) {
                case 105: {
                    if (valueLen > 1 && this.value.byteAt(1) != 120) {
                        return this.parseLong((byte)3);
                    }
                    if (valueLen > 3 && this.value.byteAt(0) == 48 && (this.value.byteAt(1) | 0x20) == 120) {
                        this.value.decHi();
                        this.type = (byte)7;
                        return true;
                    }
                    this.type = (byte)5;
                    return false;
                }
                case 110: {
                    if (valueLen > 1) {
                        this.unit = 1;
                        return this.parseLong((byte)13);
                    }
                }
                case 109: {
                    if (valueLen > 1) {
                        this.unit = (byte)3;
                        return this.parseLong((byte)13);
                    }
                    this.type = (byte)5;
                    return false;
                }
                case 116: {
                    if (valueLen > 1) {
                        this.unit = (byte)2;
                        return this.parseLong((byte)13);
                    }
                }
                case 69: 
                case 70: 
                case 84: 
                case 101: 
                case 102: {
                    if (valueLen == 1) {
                        if (last == 101) {
                            this.type = (byte)5;
                            return false;
                        }
                        this.booleanValue = (last | 0x20) == 116;
                        this.type = (byte)6;
                        return true;
                    }
                    LineTcpParser.this.charSeq.of(this.value.lo(), this.value.hi(), LineTcpParser.this.asciiSegment);
                    LineTcpParser.this.asciiSegment = true;
                    if (SqlKeywords.isTrueKeyword(LineTcpParser.this.charSeq)) {
                        this.booleanValue = true;
                        this.type = (byte)6;
                        return true;
                    }
                    if (SqlKeywords.isFalseKeyword(LineTcpParser.this.charSeq)) {
                        this.booleanValue = false;
                        this.type = (byte)6;
                        return true;
                    }
                    this.type = (byte)5;
                    return false;
                }
                case 34: {
                    byte b = this.value.byteAt(0);
                    if (valueLen > 1 && b == 34) {
                        this.value.squeeze();
                        this.type = (byte)4;
                        return true;
                    }
                    this.type = (byte)5;
                    return false;
                }
            }
            try {
                this.floatValue = Numbers.parseDouble(this.value.lo(), this.value.size());
                this.type = (byte)2;
                return true;
            }
            catch (NumericException ex) {
                this.type = (byte)5;
                return false;
            }
        }

        private boolean parseBinaryFormat(long bufHi) {
            try {
                while (LineTcpParser.this.bufAt < bufHi) {
                    if (this.type == -1) {
                        this.type = Unsafe.getUnsafe().getByte(LineTcpParser.this.bufAt);
                        if (!binaryFormatSupportType.contains(this.type)) {
                            LineTcpParser.this.errorCode = ErrorCode.UNSUPPORTED_BINARY_FORMAT;
                            return false;
                        }
                        if (this.type == 14) {
                            this.arrayBinaryParser.reset();
                        }
                        LineTcpParser.this.entityLo = ++LineTcpParser.this.bufAt;
                        continue;
                    }
                    switch (this.type) {
                        case 6: {
                            this.booleanValue = Unsafe.getUnsafe().getByte(LineTcpParser.this.entityLo) == 1;
                            return true;
                        }
                        case 2: {
                            if (LineTcpParser.this.bufAt - LineTcpParser.this.entityLo + 1L == 4L) {
                                this.floatValue = Unsafe.getUnsafe().getFloat(LineTcpParser.this.entityLo);
                                return true;
                            }
                            ++LineTcpParser.this.bufAt;
                            break;
                        }
                        case 16: {
                            if (LineTcpParser.this.bufAt - LineTcpParser.this.entityLo + 1L == 8L) {
                                this.type = (byte)2;
                                this.floatValue = Unsafe.getUnsafe().getDouble(LineTcpParser.this.entityLo);
                                return true;
                            }
                            ++LineTcpParser.this.bufAt;
                            break;
                        }
                        case 3: {
                            if (LineTcpParser.this.bufAt - LineTcpParser.this.entityLo + 1L == 4L) {
                                this.longValue = Unsafe.getUnsafe().getInt(LineTcpParser.this.entityLo);
                                return true;
                            }
                            ++LineTcpParser.this.bufAt;
                            break;
                        }
                        case 15: {
                            if (LineTcpParser.this.bufAt - LineTcpParser.this.entityLo + 1L == 8L) {
                                this.type = (byte)3;
                                this.longValue = Unsafe.getUnsafe().getLong(LineTcpParser.this.entityLo);
                                return true;
                            }
                            ++LineTcpParser.this.bufAt;
                            break;
                        }
                        case 13: {
                            if (LineTcpParser.this.bufAt - LineTcpParser.this.entityLo + 1L == 9L) {
                                this.unit = Unsafe.getUnsafe().getByte(LineTcpParser.this.entityLo);
                                this.longValue = Unsafe.getUnsafe().getLong(LineTcpParser.this.entityLo + 1L);
                                return true;
                            }
                            ++LineTcpParser.this.bufAt;
                            break;
                        }
                        case 14: {
                            if (LineTcpParser.this.bufAt - LineTcpParser.this.entityLo + 1L == (long)this.arrayBinaryParser.getNextExpectSize()) {
                                if (this.arrayBinaryParser.processNextBinaryPart(LineTcpParser.this.entityLo)) {
                                    return true;
                                }
                                LineTcpParser.this.entityLo = LineTcpParser.this.bufAt + 1L;
                            }
                            ++LineTcpParser.this.bufAt;
                        }
                    }
                }
                LineTcpParser.this.errorCode = ErrorCode.INVALID_FIELD_VALUE_STR_UNDERFLOW;
                return false;
            }
            catch (ArrayBinaryFormatParser.ParseException e) {
                LineTcpParser.this.errorCode = e.errorCode();
                return false;
            }
        }

        private boolean parseLong(byte entityType) {
            try {
                LineTcpParser.this.charSeq.of(this.value.lo(), this.value.hi() - 1L, true);
                this.longValue = Numbers.parseLong(LineTcpParser.this.charSeq);
                this.value.decHi();
                this.type = entityType;
            }
            catch (NumericException notANumber) {
                this.unit = 0;
                this.type = (byte)5;
                return false;
            }
            return true;
        }

        private void setName() {
            this.name.of(LineTcpParser.this.entityLo, LineTcpParser.this.bufAt - (long)LineTcpParser.this.nEscapedChars, LineTcpParser.this.asciiSegment);
            LineTcpParser.this.asciiSegment = true;
        }

        private void setName(long hi) {
            this.name.of(LineTcpParser.this.entityLo, hi - (long)LineTcpParser.this.nEscapedChars, LineTcpParser.this.asciiSegment);
            LineTcpParser.this.asciiSegment = true;
        }

        private boolean setValueAndUnit() {
            assert (this.type == -1);
            long bufHi = LineTcpParser.this.bufAt - (long)LineTcpParser.this.nEscapedChars;
            int valueLen = (int)(bufHi - LineTcpParser.this.entityLo);
            this.value.of(LineTcpParser.this.entityLo, bufHi, LineTcpParser.this.asciiSegment);
            LineTcpParser.this.asciiSegment = true;
            if (LineTcpParser.this.tagsComplete) {
                if (valueLen > 0) {
                    byte lastByte = this.value.byteAt(valueLen - 1);
                    return this.parse(lastByte, valueLen);
                }
                this.type = 0;
                return true;
            }
            this.type = 1;
            return true;
        }
    }

    public static enum ErrorCode {
        EMPTY_LINE,
        NO_FIELDS,
        INCOMPLETE_TAG,
        INCOMPLETE_FIELD,
        INVALID_FIELD_SEPARATOR,
        INVALID_TIMESTAMP,
        INVALID_TAG_VALUE,
        INVALID_FIELD_VALUE,
        INVALID_FIELD_VALUE_STR_UNDERFLOW,
        INVALID_TABLE_NAME,
        INVALID_COLUMN_NAME,
        MISSING_FIELD_VALUE,
        MISSING_TAG_VALUE,
        UNSUPPORTED_BINARY_FORMAT,
        ARRAY_INVALID_TYPE,
        ARRAY_TOO_MANY_DIMENSIONS,
        ARRAY_TOO_LARGE,
        NONE;

    }

    public static enum ParseResult {
        MEASUREMENT_COMPLETE,
        BUFFER_UNDERFLOW,
        ERROR;

    }
}

