/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TableWriterAPI;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.griffin.RecordToRowCopier;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlUtil;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.QuietCloseable;

public final class InsertRowImpl
implements QuietCloseable {
    private final RecordToRowCopier copier;
    private final RowFactory rowFactory;
    private final Function timestampFunction;
    private final int timestampFunctionPosition;
    private final int tupleIndex;
    private final VirtualRecord virtualRecord;

    public InsertRowImpl(VirtualRecord virtualRecord, RecordToRowCopier copier, Function timestampFunction, int timestampFunctionPosition, int tupleIndex) {
        int type;
        this.virtualRecord = virtualRecord;
        this.copier = copier;
        this.timestampFunction = timestampFunction;
        this.timestampFunctionPosition = timestampFunctionPosition;
        this.tupleIndex = tupleIndex;
        this.rowFactory = timestampFunction != null ? (ColumnType.isString(type = timestampFunction.getType()) || ColumnType.isVarchar(type) ? this::getRowWithStringTimestamp : this::getRowWithTimestamp) : this::getRowWithoutTimestamp;
    }

    public void append(TableWriterAPI writer) {
        TableWriter.Row row = this.rowFactory.getRow(writer);
        try {
            this.copier.copy(this.virtualRecord, row);
            row.append();
        }
        catch (Throwable e) {
            row.cancel();
            throw e;
        }
    }

    @Override
    public void close() {
        Misc.free(this.timestampFunction);
        Misc.free(this.virtualRecord);
    }

    public void initContext(SqlExecutionContext executionContext) throws SqlException {
        ObjList<? extends Function> functions = this.virtualRecord.getFunctions();
        Function.init(functions, null, executionContext, null);
        if (this.timestampFunction != null) {
            this.timestampFunction.init(null, executionContext);
        }
    }

    private TableWriter.Row getRowWithStringTimestamp(TableWriterAPI tableWriter) {
        CharSequence timestampValue = this.timestampFunction.getStrA(null);
        if (timestampValue != null) {
            try {
                return tableWriter.newRow(SqlUtil.parseFloorPartialTimestamp(this.timestampFunction.getStrA(null), this.tupleIndex, this.timestampFunction.getType(), 8));
            }
            catch (CairoException e) {
                if (!e.isCritical()) {
                    e.position(this.timestampFunctionPosition);
                }
                throw e;
            }
        }
        throw CairoException.nonCritical().put("designated timestamp column cannot be NULL");
    }

    private TableWriter.Row getRowWithTimestamp(TableWriterAPI tableWriter) {
        try {
            return tableWriter.newRow(this.timestampFunction.getTimestamp(null));
        }
        catch (CairoException e) {
            if (!e.isCritical()) {
                e.position(this.timestampFunctionPosition);
            }
            throw e;
        }
    }

    private TableWriter.Row getRowWithoutTimestamp(TableWriterAPI tableWriter) {
        return tableWriter.newRow();
    }

    @FunctionalInterface
    private static interface RowFactory {
        public TableWriter.Row getRow(TableWriterAPI var1);
    }
}

