/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.TableToken;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.ops.CreateTableOperationFuture;
import io.questdb.griffin.engine.ops.Operation;
import io.questdb.std.Mutable;
import io.questdb.std.str.StringSink;

public final class QueryBuilder
implements Mutable {
    private final SqlCompiler compiler;
    private final StringSink sink = new StringSink();

    QueryBuilder(SqlCompiler compiler) {
        this.compiler = compiler;
    }

    public QueryBuilder $(CharSequence value) {
        this.sink.put(value);
        return this;
    }

    public QueryBuilder $(char value) {
        this.sink.put(value);
        return this;
    }

    public QueryBuilder $(int value) {
        this.sink.put(value);
        return this;
    }

    @Override
    public void clear() {
        this.sink.clear();
    }

    public CompiledQuery compile(SqlExecutionContext executionContext) throws SqlException {
        return this.compiler.compile(this.sink, executionContext);
    }

    public TableToken createTable(SqlExecutionContext executionContext) throws SqlException {
        try (Operation op = this.compiler.compile(this.sink, executionContext).getOperation();){
            TableToken tableToken;
            block12: {
                CreateTableOperationFuture fut = (CreateTableOperationFuture)op.execute(executionContext, null);
                try {
                    fut.await();
                    tableToken = fut.getTableToken();
                    if (fut == null) break block12;
                }
                catch (Throwable throwable) {
                    if (fut != null) {
                        try {
                            fut.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                fut.close();
            }
            return tableToken;
        }
    }

    public String toString() {
        return this.sink.toString();
    }
}

