/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.array;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.DerivedArrayView;
import io.questdb.cairo.sql.ArrayFunction;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.MultiArgFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.DoubleConstant;
import io.questdb.std.IntList;
import io.questdb.std.Interval;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public class DoubleArrayAccessFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "[](D[]LV)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int i;
        int n;
        int i2;
        DoubleArrayAccessFunctionFactory.validateIndexArgs(args, argPositions);
        Function arrayArg = args.getQuick(0);
        ObjList<Function> argsCopy = null;
        IntList argPositionsCopy = null;
        if (arrayArg instanceof SliceDoubleArrayFunction) {
            boolean canInline = true;
            SliceDoubleArrayFunction sliceFn = (SliceDoubleArrayFunction)arrayArg;
            ObjList<Function> rangeArgs = sliceFn.allArgs;
            int n2 = rangeArgs.size();
            for (i2 = 0; i2 < n2; ++i2) {
                if (!ColumnType.isInterval(rangeArgs.getQuick(i2).getType())) continue;
                canInline = false;
                break;
            }
            if (canInline) {
                arrayArg = sliceFn.arrayArg;
                argsCopy = new ObjList(rangeArgs.size() + args.size());
                argsCopy.addAll(rangeArgs);
                argPositionsCopy = new IntList();
                argPositionsCopy.addAll(sliceFn.allArgPositions);
                n = args.size();
                for (i = 1; i < n; ++i) {
                    argsCopy.add(args.getQuick(i));
                    argPositionsCopy.add(argPositions.getQuick(i));
                }
            }
        }
        if (argsCopy == null) {
            argsCopy = new ObjList<Function>(args);
            argPositionsCopy = new IntList(argPositions);
        }
        int nDims = ColumnType.decodeArrayDimensionality(arrayArg.getType());
        int nArgs = argsCopy.size() - 1;
        if (nArgs > nDims) {
            throw SqlException.position(argPositionsCopy.get(nDims + 1)).put("too many array access arguments [nDims=").put(nDims).put(", nArgs=").put(nArgs).put(']');
        }
        int resultNDims = nDims;
        n = argsCopy.size();
        for (i = 1; i < n; ++i) {
            int argType = argsCopy.getQuick(i).getType();
            if (!DoubleArrayAccessFunctionFactory.isIndexArg(argType)) continue;
            --resultNDims;
        }
        if (resultNDims == 0) {
            boolean indexArgsAreConstant = true;
            int n3 = argsCopy.size();
            for (i2 = 1; i2 < n3; ++i2) {
                if (argsCopy.getQuick(i2).isConstant()) continue;
                indexArgsAreConstant = false;
                break;
            }
            if (indexArgsAreConstant) {
                IntList indexArgs = new IntList(argsCopy.size() - 1);
                int n4 = argsCopy.size();
                for (int i3 = 1; i3 < n4; ++i3) {
                    long index = argsCopy.getQuick(i3).getLong(null);
                    if (index == Long.MIN_VALUE) {
                        return DoubleConstant.NULL;
                    }
                    indexArgs.add((int)index);
                    Misc.free(argsCopy.getQuick(i3));
                }
                argPositionsCopy.removeIndex(0);
                return new AccessDoubleArrayConstantIndexFunction(arrayArg, indexArgs, argPositionsCopy);
            }
            return new AccessDoubleArrayFunction(arrayArg, argsCopy, argPositionsCopy);
        }
        return new SliceDoubleArrayFunction(arrayArg, resultNDims, argsCopy, argPositionsCopy);
    }

    private static int flatIndexDelta(ArrayView array, int dim, int pgIndexAtDim) {
        int strideAtDim = array.getStride(dim);
        int dimLen = array.getDimLen(dim);
        int indexAtDim = pgIndexAtDim < 0 ? pgIndexAtDim + dimLen : pgIndexAtDim - 1;
        if (indexAtDim < 0 || indexAtDim >= dimLen) {
            return Integer.MIN_VALUE;
        }
        return strideAtDim * indexAtDim;
    }

    private static boolean isIndexArg(int argType) {
        return ColumnType.isAssignableFrom(argType, 6);
    }

    private static void validateIndexArgs(ObjList<Function> args, IntList argPositions) throws SqlException {
        int n = args.size();
        for (int i = 1; i < n; ++i) {
            int index;
            Function arg = args.getQuick(i);
            int argType = arg.getType();
            if (!DoubleArrayAccessFunctionFactory.isIndexArg(argType) && !ColumnType.isInterval(argType)) {
                throw SqlException.position(argPositions.get(i)).put("invalid type for array access [type=").put(argType).put(']');
            }
            if (!arg.isConstant()) continue;
            if (ColumnType.isInterval(argType)) {
                Interval range = arg.getInterval(null);
                long lo = range.getLo();
                long hi = range.getHi();
                if (lo != 0L && hi != 0L) continue;
                throw SqlException.position(argPositions.getQuick(i)).put("array slice bounds must be non-zero [dim=").put(i).put(", lowerBound=").put(lo).put(", upperBound=").put(hi).put(']');
            }
            long indexLong = arg.getLong(null);
            if (indexLong == Long.MIN_VALUE || (long)(index = (int)indexLong) == indexLong) continue;
            throw SqlException.position(argPositions.getQuick(i)).put("int overflow on array index [dim=").put(i).put(", index=").put(indexLong).put(']');
        }
    }

    private static class SliceDoubleArrayFunction
    extends ArrayFunction
    implements MultiArgFunction {
        private final IntList allArgPositions;
        private final ObjList<Function> allArgs;
        private final Function arrayArg;
        private final DerivedArrayView derivedArray = new DerivedArrayView();

        public SliceDoubleArrayFunction(Function arrayArg, int resultNDims, ObjList<Function> allArgs, IntList allArgPositions) {
            this.arrayArg = arrayArg;
            this.allArgs = allArgs;
            this.allArgPositions = allArgPositions;
            this.type = ColumnType.encodeArrayType((short)10, resultNDims);
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.allArgs;
        }

        @Override
        public ArrayView getArray(Record rec) {
            ArrayView array = this.arrayArg.getArray(rec);
            this.derivedArray.of(array);
            if (this.derivedArray.isNull()) {
                return this.derivedArray;
            }
            int dim = 0;
            int n = this.allArgs.size();
            for (int i = 1; i < n; ++i) {
                Function rangeFn = this.allArgs.getQuick(i);
                int argPos = this.allArgPositions.getQuick(i);
                int dimLen = this.derivedArray.getDimLen(dim);
                if (ColumnType.isInterval(rangeFn.getType())) {
                    Interval range = rangeFn.getInterval(rec);
                    long loLong = range.getLo();
                    long hiLong = range.getHi();
                    if (loLong == Integer.MIN_VALUE || hiLong == Integer.MIN_VALUE) {
                        this.derivedArray.ofNull();
                        return this.derivedArray;
                    }
                    int lo = this.toIndex(loLong, dim, dimLen, argPos, "lower");
                    int hi = this.toIndex(hiLong, dim, dimLen, argPos, "upper");
                    this.derivedArray.slice(dim++, lo, hi);
                    continue;
                }
                long pgIndexLong = rangeFn.getLong(rec);
                if (pgIndexLong == Long.MIN_VALUE) {
                    this.derivedArray.ofNull();
                    return this.derivedArray;
                }
                if (pgIndexLong == 0L) {
                    throw CairoException.nonCritical().position(argPos).put("array index must be non-zero [dim=").put(dim + 1).put(", index=").put(pgIndexLong).put(']');
                }
                int pgIndex = (int)pgIndexLong;
                if ((long)pgIndex != pgIndexLong) {
                    throw CairoException.nonCritical().position(argPos).put("int overflow on array index [dim=").put(i).put(", index=").put(pgIndexLong).put(']');
                }
                int index = pgIndex < 0 ? pgIndex + dimLen : pgIndex - 1;
                this.derivedArray.subArray(dim, index);
                if (!this.derivedArray.isNull()) continue;
                return this.derivedArray;
            }
            return this.derivedArray;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arrayArg).val('[');
            String comma = "";
            int n = this.allArgs.size();
            for (int i = 1; i < n; ++i) {
                sink.val(comma).val(this.allArgs.getQuick(i));
                comma = ",";
            }
            sink.val(']');
        }

        private int toIndex(long indexLong, int dim, int dimLen, int argPos, String boundName) {
            if (indexLong == Long.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            int index = (int)indexLong;
            assert ((long)index == indexLong) : "int overflow on interval " + boundName + " bound: " + indexLong;
            if (index < 0) {
                if ((index += dimLen) < 0) {
                    index = 0;
                }
            } else if (index > 0) {
                --index;
            } else {
                throw CairoException.nonCritical().position(argPos).put("array slice bounds must be non-zero [dim=").put(dim + 1).put(", ").put(boundName).put("Bound=").put(index).put(']');
            }
            return index;
        }
    }

    private static class AccessDoubleArrayConstantIndexFunction
    extends DoubleFunction
    implements UnaryFunction {
        private final Function arrayArg;
        private final IntList indexArgPositions;
        private final IntList indexArgs;

        private AccessDoubleArrayConstantIndexFunction(Function arrayArg, IntList indexArgs, IntList indexArgPositions) {
            this.arrayArg = arrayArg;
            this.indexArgs = indexArgs;
            this.indexArgPositions = indexArgPositions;
        }

        @Override
        public Function getArg() {
            return this.arrayArg;
        }

        @Override
        public double getDouble(Record rec) {
            ArrayView array = this.arrayArg.getArray(rec);
            if (array.isNull()) {
                return Double.NaN;
            }
            int flatIndex = 0;
            int n = this.indexArgs.size();
            for (int dim = 0; dim < n; ++dim) {
                int pgIndexAtDim = this.indexArgs.get(dim);
                if (pgIndexAtDim == 0) {
                    throw CairoException.nonCritical().position(this.indexArgPositions.get(dim)).put("array index must be non-zero [dim=").put(dim + 1).put(", index=").put(pgIndexAtDim).put(']');
                }
                int indexDelta = DoubleArrayAccessFunctionFactory.flatIndexDelta(array, dim, pgIndexAtDim);
                if (indexDelta == Integer.MIN_VALUE) {
                    return Double.NaN;
                }
                flatIndex += indexDelta;
            }
            return array.getDouble(flatIndex);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arrayArg).val('[');
            String comma = "";
            int n = this.indexArgs.size();
            for (int i = 0; i < n; ++i) {
                sink.val(comma).val(this.indexArgs.getQuick(i));
                comma = ",";
            }
            sink.val(']');
        }
    }

    private static class AccessDoubleArrayFunction
    extends DoubleFunction
    implements MultiArgFunction {
        private final IntList allArgPositions;
        private final ObjList<Function> allArgs;
        private final Function arrayArg;

        private AccessDoubleArrayFunction(Function arrayArg, ObjList<Function> allArgs, IntList allArgPositions) {
            this.arrayArg = arrayArg;
            this.allArgs = allArgs;
            this.allArgPositions = allArgPositions;
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.allArgs;
        }

        @Override
        public double getDouble(Record rec) {
            ArrayView array = this.arrayArg.getArray(rec);
            if (array.isNull()) {
                return Double.NaN;
            }
            int flatIndex = 0;
            int n = this.allArgs.size();
            for (int i = 1; i < n; ++i) {
                long pgIndexAtDimLong = this.allArgs.getQuick(i).getLong(rec);
                if (pgIndexAtDimLong == Long.MIN_VALUE) {
                    return Double.NaN;
                }
                if (pgIndexAtDimLong == 0L) {
                    throw CairoException.nonCritical().position(this.allArgPositions.getQuick(i)).put("array index must be non-zero [dim=").put(i).put(", index=").put(pgIndexAtDimLong).put(']');
                }
                int pgIndexAtDim = (int)pgIndexAtDimLong;
                if ((long)pgIndexAtDim != pgIndexAtDimLong) {
                    throw CairoException.nonCritical().position(this.allArgPositions.getQuick(i)).put("int overflow on array index [dim=").put(i).put(", index=").put(pgIndexAtDimLong).put(']');
                }
                int indexDelta = DoubleArrayAccessFunctionFactory.flatIndexDelta(array, i - 1, pgIndexAtDim);
                if (indexDelta == Integer.MIN_VALUE) {
                    return Double.NaN;
                }
                flatIndex += indexDelta;
            }
            return array.getDouble(flatIndex);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arrayArg).val('[');
            String comma = "";
            int n = this.allArgs.size();
            for (int i = 1; i < n; ++i) {
                sink.val(comma).val(this.allArgs.getQuick(i));
                comma = ",";
            }
            sink.val(']');
        }
    }
}

