/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.array;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.DirectArray;
import io.questdb.cairo.arr.FlatArrayView;
import io.questdb.cairo.sql.ArrayFunction;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public class DoubleArraySubtractScalarFunctionFactory
implements FunctionFactory {
    private static final String OPERATOR_NAME = "-";

    @Override
    public String getSignature() {
        return "-(D[]D)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        return new Func(args.getQuick(0), args.getQuick(1), configuration);
    }

    private static class Func
    extends ArrayFunction
    implements BinaryFunction {
        private final DirectArray array;
        private final Function arrayArg;
        private final Function scalarArg;

        public Func(Function arrayArg, Function scalarArg, CairoConfiguration configuration) {
            this.arrayArg = arrayArg;
            this.scalarArg = scalarArg;
            this.type = arrayArg.getType();
            this.array = new DirectArray(configuration);
        }

        @Override
        public void close() {
            BinaryFunction.super.close();
            Misc.free(this.array);
        }

        @Override
        public ArrayView getArray(Record rec) {
            ArrayView arr = this.arrayArg.getArray(rec);
            if (arr.isNull()) {
                this.array.ofNull();
                return this.array;
            }
            double scalarValue = this.scalarArg.getDouble(rec);
            MemoryA memory = this.array.copyShapeAndStartMemoryA(arr);
            if (arr.isVanilla()) {
                FlatArrayView flatView = arr.flatView();
                int n = arr.getHi();
                for (int i = arr.getLo(); i < n; ++i) {
                    memory.putDouble(flatView.getDoubleAtAbsIndex(i) - scalarValue);
                }
            } else {
                Func.calculateRecursive(arr, 0, 0, scalarValue, memory);
            }
            return this.array;
        }

        @Override
        public Function getLeft() {
            return this.arrayArg;
        }

        @Override
        public String getName() {
            return DoubleArraySubtractScalarFunctionFactory.OPERATOR_NAME;
        }

        @Override
        public Function getRight() {
            return this.scalarArg;
        }

        @Override
        public boolean isOperator() {
            return true;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        private static void calculateRecursive(ArrayView view, int dim, int flatIndex, double scalarValue, MemoryA memOut) {
            boolean atDeepestDim;
            int count = view.getDimLen(dim);
            int stride = view.getStride(dim);
            boolean bl = atDeepestDim = dim == view.getDimCount() - 1;
            if (atDeepestDim) {
                for (int i = 0; i < count; ++i) {
                    memOut.putDouble(view.getDouble(flatIndex) - scalarValue);
                    flatIndex += stride;
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    Func.calculateRecursive(view, dim + 1, flatIndex, scalarValue, memOut);
                    flatIndex += stride;
                }
            }
        }
    }
}

