/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.griffin.engine.functions.eq.AbstractEqBinaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class EqDoubleArrayFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "=(D[]D[])";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int rightNDims;
        Function left = args.getQuick(0);
        Function right = args.getQuick(1);
        int leftNDims = ColumnType.decodeArrayDimensionality(left.getType());
        if (leftNDims == (rightNDims = ColumnType.decodeArrayDimensionality(right.getType()))) {
            return new DoubleArrayEqualsFunction(left, right);
        }
        left.close();
        right.close();
        return BooleanConstant.FALSE;
    }

    private static class DoubleArrayEqualsFunction
    extends AbstractEqBinaryFunction
    implements BinaryFunction {
        public DoubleArrayEqualsFunction(Function left, Function right) {
            super(left, right);
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != this.left.getArray(rec).arrayEquals(this.right.getArray(rec));
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public final String getName() {
            if (this.negated) {
                return "!=";
            }
            return "=";
        }

        @Override
        public Function getRight() {
            return this.right;
        }
    }
}

