/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.TernaryFunction;
import io.questdb.griffin.engine.functions.VarcharFunction;
import io.questdb.griffin.engine.functions.constants.VarcharConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8Sink;
import io.questdb.std.str.Utf8StringSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceVarcharFunctionFactory
implements FunctionFactory {
    private static final String SIGNATURE = "replace(\u00d8\u00d8\u00d8)";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function replaceWith = args.getQuick(2);
        if (replaceWith.isConstant() && replaceWith.getVarcharSize(null) < 0) {
            return VarcharConstant.NULL;
        }
        Function lookFor = args.getQuick(1);
        if (lookFor.isConstant()) {
            if (lookFor.getVarcharSize(null) < 0) {
                return VarcharConstant.NULL;
            }
            if (lookFor.getVarcharSize(null) == 0) {
                return args.getQuick(0);
            }
        }
        int maxSize = configuration.getStrFunctionMaxBufferLength();
        Function value = args.getQuick(0);
        if (value.isConstant()) {
            Utf8Sequence valueValue = value.getVarcharA(null);
            if (valueValue == null) {
                return value;
            }
            if (lookFor.isConstant() && replaceWith.isConstant()) {
                try {
                    return new VarcharConstant(ReplaceVarcharFunctionFactory.replace(valueValue, lookFor.getVarcharA(null), replaceWith.getVarcharA(null), new Utf8StringSink(4), maxSize));
                }
                catch (CairoException cairoException) {
                    // empty catch block
                }
            }
        }
        return new Func(value, lookFor, replaceWith, maxSize);
    }

    static void checkSizeLimit(int size, int maxSize) {
        if (size > maxSize) {
            throw CairoException.nonCritical().put("breached memory limit set for ").put(SIGNATURE).put(" [maxSize=").put(maxSize).put(", requiredSize=").put(size).put(']');
        }
    }

    @Nullable
    static <T extends Utf8Sink> T replace(@NotNull Utf8Sequence value, Utf8Sequence lookFor, Utf8Sequence replaceWith, T sink, int maxSize) throws CairoException {
        int valueSize = value.size();
        if (valueSize < 1) {
            return sink;
        }
        if (lookFor == null || replaceWith == null) {
            return null;
        }
        ReplaceVarcharFunctionFactory.checkSizeLimit(valueSize, maxSize);
        int lookForSize = lookFor.size();
        if (lookForSize < 1) {
            sink.putAny(value);
            return sink;
        }
        int replaceWithSize = replaceWith.size();
        int i = 0;
        int curLen = 0;
        block0: while (i <= valueSize - lookForSize) {
            byte bi = value.byteAt(i);
            int k = 0;
            byte bk = bi;
            while (true) {
                if (bk != lookFor.byteAt(k)) {
                    ++i;
                    ReplaceVarcharFunctionFactory.checkSizeLimit(++curLen, maxSize);
                    sink.putAny(bi);
                    continue block0;
                }
                if (++k == lookForSize) break;
                bk = value.byteAt(i + k);
            }
            i += lookForSize;
            ReplaceVarcharFunctionFactory.checkSizeLimit(curLen += replaceWithSize, maxSize);
            sink.putAny(replaceWith);
        }
        ReplaceVarcharFunctionFactory.checkSizeLimit(++curLen, maxSize);
        sink.putAny(value, i, valueSize);
        return sink;
    }

    private static class Func
    extends VarcharFunction
    implements TernaryFunction {
        private final Function lookFor;
        private final int maxSize;
        private final Function replaceWith;
        private final Utf8StringSink sinkA = new Utf8StringSink();
        private final Utf8StringSink sinkB = new Utf8StringSink();
        private final Function value;

        public Func(Function value, Function lookFor, Function replaceWith, int maxSize) {
            this.value = value;
            this.lookFor = lookFor;
            this.replaceWith = replaceWith;
            this.maxSize = maxSize;
        }

        @Override
        public Function getCenter() {
            return this.lookFor;
        }

        @Override
        public Function getLeft() {
            return this.value;
        }

        @Override
        public Function getRight() {
            return this.replaceWith;
        }

        @Override
        public Utf8Sequence getVarcharA(Record rec) {
            Utf8Sequence value = this.value.getVarcharA(rec);
            if (value != null) {
                this.sinkA.clear();
                return ReplaceVarcharFunctionFactory.replace(value, this.lookFor.getVarcharA(rec), this.replaceWith.getVarcharA(rec), this.sinkA, this.maxSize);
            }
            return null;
        }

        @Override
        public Utf8Sequence getVarcharB(Record rec) {
            Utf8Sequence value = this.value.getVarcharB(rec);
            if (value != null) {
                this.sinkB.clear();
                return ReplaceVarcharFunctionFactory.replace(value, this.lookFor.getVarcharB(rec), this.replaceWith.getVarcharB(rec), this.sinkB, this.maxSize);
            }
            return null;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("replace(").val(this.value).val(',').val(this.lookFor).val(',').val(this.replaceWith).val(')');
        }
    }
}

