/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.griffin.engine.groupby.GroupByAllocator;
import io.questdb.std.Unsafe;
import io.questdb.std.str.AsciiCharSequence;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StableAwareUtf8StringHolder
implements Utf8Sequence {
    private static final long HEADER_SIZE = 9L;
    private static final long IS_ASCII_OFFSET = 8L;
    private static final int MIN_CAPACITY = 8;
    private static final long SIZE_OFFSET = 4L;
    private GroupByAllocator allocator;
    private AsciiCharSequence asciiCharSequence;
    private boolean direct;
    private long ptr;

    @Override
    @NotNull
    public CharSequence asAsciiCharSequence() {
        if (this.asciiCharSequence == null) {
            this.asciiCharSequence = new AsciiCharSequence();
        }
        this.asciiCharSequence.of(this);
        return this.asciiCharSequence;
    }

    @Override
    public byte byteAt(int index) {
        if (this.direct) {
            long directPtr = Unsafe.getUnsafe().getLong(this.ptr + 9L);
            assert (directPtr != 0L);
            return Unsafe.getUnsafe().getByte(directPtr + (long)index);
        }
        return Unsafe.getUnsafe().getByte(this.ptr + 9L + (long)index);
    }

    public void clearAndSet(@Nullable Utf8Sequence us) {
        this.clear();
        if (us == null) {
            return;
        }
        if (us.isStable()) {
            this.direct = true;
            this.checkCapacity(8);
            Unsafe.getUnsafe().putLong(this.ptr + 9L, us.ptr());
            Unsafe.getUnsafe().putInt(this.ptr + 4L, us.size());
            Unsafe.getUnsafe().putBoolean(null, this.ptr + 8L, us.isAscii());
        } else {
            int thatSize = us.size();
            this.checkCapacity(thatSize);
            long lo = this.ptr + 9L;
            us.writeTo(lo, 0, thatSize);
            Unsafe.getUnsafe().putInt(this.ptr + 4L, thatSize);
            Unsafe.getUnsafe().putBoolean(null, this.ptr + 8L, us.isAscii());
        }
    }

    public long colouredPtr() {
        return this.ptr | (this.direct ? Long.MIN_VALUE : 0L);
    }

    @Override
    public boolean isAscii() {
        return this.ptr == 0L || Unsafe.getUnsafe().getBoolean(null, this.ptr + 8L);
    }

    public StableAwareUtf8StringHolder of(long colouredPtr) {
        this.ptr = colouredPtr & Long.MAX_VALUE;
        this.direct = (colouredPtr & Long.MIN_VALUE) != 0L;
        return this;
    }

    @Override
    public long ptr() {
        return this.ptr;
    }

    public void setAllocator(GroupByAllocator allocator) {
        this.allocator = allocator;
    }

    @Override
    public int size() {
        return this.ptr != 0L ? Unsafe.getUnsafe().getInt(this.ptr + 4L) : 0;
    }

    private int capacity() {
        return this.ptr != 0L ? Unsafe.getUnsafe().getInt(this.ptr) : 0;
    }

    private void checkCapacity(int bytes) {
        int newCapacity;
        int capacity = this.capacity();
        int len = this.size();
        int requiredCapacity = len + bytes;
        if (requiredCapacity > 0 && requiredCapacity <= capacity) {
            return;
        }
        for (newCapacity = Math.max(capacity, 8); newCapacity < requiredCapacity; newCapacity *= 2) {
        }
        long newSize = (long)newCapacity + 9L;
        if (this.ptr == 0L) {
            this.ptr = this.allocator.malloc(newSize);
            Unsafe.getUnsafe().putInt(this.ptr, newCapacity);
            Unsafe.getUnsafe().putInt(this.ptr + 4L, 0);
            Unsafe.getUnsafe().putBoolean(null, this.ptr + 8L, true);
        } else {
            this.ptr = this.allocator.realloc(this.ptr, (long)capacity + 9L, newSize);
            Unsafe.getUnsafe().putInt(this.ptr, newCapacity);
        }
        assert (this.ptr != 0L);
        assert ((this.ptr & Long.MIN_VALUE) == 0L);
    }

    private void clear() {
        if (this.ptr != 0L) {
            Unsafe.getUnsafe().putInt(this.ptr + 4L, 0);
            Unsafe.getUnsafe().putBoolean(null, this.ptr + 8L, true);
            this.direct = false;
        }
    }
}

