/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.orderby;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.DirectLongLongAscList;
import io.questdb.std.DirectLongLongDescList;
import io.questdb.std.DirectLongLongSortedList;
import io.questdb.std.Misc;

class LongTopKRecordCursor
implements RecordCursor {
    private final int columnIndex;
    private final DirectLongLongSortedList.Cursor rowIdCursor;
    private final DirectLongLongSortedList sortedList;
    private RecordCursor baseCursor;
    private Record baseRecord;
    private SqlExecutionCircuitBreaker circuitBreaker;
    private boolean initialized;
    private boolean isOpen;

    public LongTopKRecordCursor(int columnIndex, int lo, boolean ascending) {
        this.columnIndex = columnIndex;
        this.isOpen = true;
        this.sortedList = ascending ? new DirectLongLongAscList(lo, 19) : new DirectLongLongDescList(lo, 19);
        this.rowIdCursor = this.sortedList.getCursor();
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.isOpen = false;
            Misc.free(this.sortedList);
            this.baseCursor = Misc.free(this.baseCursor);
            this.baseRecord = null;
        }
    }

    @Override
    public Record getRecord() {
        return this.baseRecord;
    }

    @Override
    public Record getRecordB() {
        return this.baseCursor.getRecordB();
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.baseCursor.getSymbolTable(columnIndex);
    }

    @Override
    public boolean hasNext() {
        this.setupTopK();
        if (this.rowIdCursor.hasNext()) {
            this.circuitBreaker.statefulThrowExceptionIfTripped();
            this.baseCursor.recordAt(this.baseRecord, this.rowIdCursor.index());
            return true;
        }
        return false;
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return this.baseCursor.newSymbolTable(columnIndex);
    }

    public void of(RecordCursor baseCursor, SqlExecutionContext executionContext) {
        this.baseCursor = baseCursor;
        this.baseRecord = baseCursor.getRecord();
        if (!this.isOpen) {
            this.isOpen = true;
            this.sortedList.reopen();
        }
        this.circuitBreaker = executionContext.getCircuitBreaker();
        this.initialized = false;
    }

    @Override
    public long preComputedStateSize() {
        return RecordCursor.fromBool(this.initialized) + this.baseCursor.preComputedStateSize();
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        this.baseCursor.recordAt(record, atRowId);
    }

    @Override
    public long size() {
        return this.initialized ? (long)this.sortedList.size() : -1L;
    }

    @Override
    public void toTop() {
        this.rowIdCursor.toTop();
        if (!this.initialized) {
            this.sortedList.clear();
            this.baseCursor.toTop();
        }
    }

    private void setupTopK() {
        if (!this.initialized) {
            this.topK();
            this.initialized = true;
        }
    }

    private void topK() {
        this.baseCursor.longTopK(this.sortedList, this.columnIndex);
        this.rowIdCursor.toTop();
    }
}

