/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.StatefulAtom;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.Plannable;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.PerWorkerLocks;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.GroupByAllocator;
import io.questdb.griffin.engine.groupby.GroupByAllocatorFactory;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdater;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdaterFactory;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.groupby.SimpleMapValue;
import io.questdb.griffin.engine.table.AsyncJitFilteredRecordCursorFactory;
import io.questdb.jit.CompiledFilter;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncGroupByNotKeyedAtom
implements StatefulAtom,
Closeable,
Plannable {
    private final ObjList<Function> bindVarFunctions;
    private final MemoryCARW bindVarMemory;
    private final CompiledFilter compiledFilter;
    private final GroupByAllocator ownerAllocator;
    private final Function ownerFilter;
    private final GroupByFunctionsUpdater ownerFunctionUpdater;
    private final ObjList<GroupByFunction> ownerGroupByFunctions;
    private final SimpleMapValue ownerMapValue;
    private final ObjList<GroupByAllocator> perWorkerAllocators;
    private final ObjList<Function> perWorkerFilters;
    private final ObjList<GroupByFunctionsUpdater> perWorkerFunctionUpdaters;
    private final ObjList<ObjList<GroupByFunction>> perWorkerGroupByFunctions;
    private final PerWorkerLocks perWorkerLocks;
    private final ObjList<SimpleMapValue> perWorkerMapValues;

    public AsyncGroupByNotKeyedAtom(@NotNull BytecodeAssembler asm, @NotNull CairoConfiguration configuration, @NotNull ObjList<GroupByFunction> ownerGroupByFunctions, @Nullable ObjList<ObjList<GroupByFunction>> perWorkerGroupByFunctions, int valueCount, @Nullable CompiledFilter compiledFilter, @Nullable MemoryCARW bindVarMemory, @Nullable ObjList<Function> bindVarFunctions, @Nullable Function ownerFilter, @Nullable ObjList<Function> perWorkerFilters, int workerCount) {
        assert (perWorkerFilters == null || perWorkerFilters.size() == workerCount);
        assert (perWorkerGroupByFunctions == null || perWorkerGroupByFunctions.size() == workerCount);
        int slotCount = Math.min(workerCount, configuration.getPageFrameReduceQueueCapacity());
        try {
            int i;
            this.compiledFilter = compiledFilter;
            this.bindVarMemory = bindVarMemory;
            this.bindVarFunctions = bindVarFunctions;
            this.ownerFilter = ownerFilter;
            this.perWorkerFilters = perWorkerFilters;
            this.ownerGroupByFunctions = ownerGroupByFunctions;
            this.perWorkerGroupByFunctions = perWorkerGroupByFunctions;
            Class<GroupByFunctionsUpdater> updaterClass = GroupByFunctionsUpdaterFactory.getInstanceClass(asm, ownerGroupByFunctions.size());
            this.ownerFunctionUpdater = GroupByFunctionsUpdaterFactory.getInstance(updaterClass, ownerGroupByFunctions);
            if (perWorkerGroupByFunctions != null) {
                this.perWorkerFunctionUpdaters = new ObjList(slotCount);
                for (i = 0; i < slotCount; ++i) {
                    this.perWorkerFunctionUpdaters.extendAndSet(i, GroupByFunctionsUpdaterFactory.getInstance(updaterClass, perWorkerGroupByFunctions.getQuick(i)));
                }
            } else {
                this.perWorkerFunctionUpdaters = null;
            }
            this.perWorkerLocks = new PerWorkerLocks(configuration, slotCount);
            this.ownerMapValue = new SimpleMapValue(valueCount);
            this.perWorkerMapValues = new ObjList(slotCount);
            for (i = 0; i < slotCount; ++i) {
                this.perWorkerMapValues.extendAndSet(i, new SimpleMapValue(valueCount));
            }
            this.ownerAllocator = GroupByAllocatorFactory.createAllocator(configuration);
            this.perWorkerAllocators = new ObjList(slotCount);
            for (i = 0; i < slotCount; ++i) {
                this.perWorkerAllocators.extendAndSet(i, GroupByAllocatorFactory.createAllocator(configuration));
            }
            this.clear();
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    @Override
    public void clear() {
        int i;
        GroupByFunctionsUpdater functionUpdater = this.getFunctionUpdater(-1);
        functionUpdater.updateEmpty(this.ownerMapValue);
        this.ownerMapValue.setNew(true);
        int n = this.perWorkerMapValues.size();
        for (i = 0; i < n; ++i) {
            SimpleMapValue value = this.perWorkerMapValues.getQuick(i);
            functionUpdater.updateEmpty(value);
            value.setNew(true);
        }
        if (this.perWorkerGroupByFunctions != null) {
            n = this.perWorkerGroupByFunctions.size();
            for (i = 0; i < n; ++i) {
                Misc.clearObjList(this.perWorkerGroupByFunctions.getQuick(i));
            }
        }
        Misc.free(this.ownerAllocator);
        Misc.freeObjListAndKeepObjects(this.perWorkerAllocators);
    }

    @Override
    public void close() {
        Misc.free(this.compiledFilter);
        Misc.free(this.bindVarMemory);
        Misc.freeObjList(this.bindVarFunctions);
        Misc.free(this.ownerFilter);
        Misc.freeObjList(this.perWorkerFilters);
        Misc.free(this.ownerAllocator);
        Misc.freeObjList(this.perWorkerAllocators);
        if (this.perWorkerGroupByFunctions != null) {
            int n = this.perWorkerGroupByFunctions.size();
            for (int i = 0; i < n; ++i) {
                Misc.freeObjList(this.perWorkerGroupByFunctions.getQuick(i));
            }
        }
    }

    public ObjList<Function> getBindVarFunctions() {
        return this.bindVarFunctions;
    }

    public MemoryCARW getBindVarMemory() {
        return this.bindVarMemory;
    }

    public CompiledFilter getCompiledFilter() {
        return this.compiledFilter;
    }

    public Function getFilter(int slotId) {
        if (slotId == -1 || this.perWorkerFilters == null) {
            return this.ownerFilter;
        }
        return this.perWorkerFilters.getQuick(slotId);
    }

    public GroupByFunctionsUpdater getFunctionUpdater(int slotId) {
        if (slotId == -1 || this.perWorkerFunctionUpdaters == null) {
            GroupByUtils.setAllocator(this.ownerGroupByFunctions, this.ownerAllocator);
            return this.ownerFunctionUpdater;
        }
        GroupByUtils.setAllocator(this.perWorkerGroupByFunctions.getQuick(slotId), this.perWorkerAllocators.getQuick(slotId));
        return this.perWorkerFunctionUpdaters.getQuick(slotId);
    }

    public SimpleMapValue getMapValue(int slotId) {
        if (slotId == -1) {
            return this.ownerMapValue;
        }
        return this.perWorkerMapValues.getQuick(slotId);
    }

    public SimpleMapValue getOwnerMapValue() {
        return this.ownerMapValue;
    }

    public ObjList<SimpleMapValue> getPerWorkerMapValues() {
        return this.perWorkerMapValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
        boolean current;
        if (this.ownerFilter != null) {
            this.ownerFilter.init(symbolTableSource, executionContext);
        }
        if (this.perWorkerFilters != null) {
            current = executionContext.getCloneSymbolTables();
            executionContext.setCloneSymbolTables(true);
            try {
                Function.init(this.perWorkerFilters, symbolTableSource, executionContext, this.ownerFilter);
            }
            finally {
                executionContext.setCloneSymbolTables(current);
            }
        }
        if (this.perWorkerGroupByFunctions != null) {
            current = executionContext.getCloneSymbolTables();
            executionContext.setCloneSymbolTables(true);
            try {
                int n = this.perWorkerGroupByFunctions.size();
                for (int i = 0; i < n; ++i) {
                    Function.init(this.perWorkerGroupByFunctions.getQuick(i), symbolTableSource, executionContext, null);
                }
            }
            finally {
                executionContext.setCloneSymbolTables(current);
            }
        }
        if (this.bindVarFunctions != null) {
            Function.init(this.bindVarFunctions, symbolTableSource, executionContext, null);
            AsyncJitFilteredRecordCursorFactory.prepareBindVarMemory(executionContext, symbolTableSource, this.bindVarFunctions, this.bindVarMemory);
        }
    }

    public int maybeAcquire(int workerId, boolean owner, SqlExecutionCircuitBreaker circuitBreaker) {
        if (workerId == -1 && owner) {
            return -1;
        }
        return this.perWorkerLocks.acquireSlot(workerId, circuitBreaker);
    }

    public void release(int slotId) {
        this.perWorkerLocks.releaseSlot(slotId);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val(this.ownerFilter);
    }

    public void toTop() {
        if (this.perWorkerGroupByFunctions != null) {
            int n = this.perWorkerGroupByFunctions.size();
            for (int i = 0; i < n; ++i) {
                GroupByUtils.toTop(this.perWorkerGroupByFunctions.getQuick(i));
            }
        }
    }
}

