/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.VirtualFunctionRecordCursor;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public class VirtualRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory base;
    private final VirtualFunctionRecordCursor cursor;
    private final ObjList<Function> functions;
    private final VirtualRecordCursorFactorySymbolTableSource internalSymbolTableSource;
    private final RecordMetadata priorityMetadata;
    private final boolean supportsRandomAccess;

    public VirtualRecordCursorFactory(RecordMetadata virtualMetadata, RecordMetadata priorityMetadata, ObjList<Function> functions, RecordCursorFactory base, int virtualColumnReservedSlots, boolean allowMemoization) {
        super(virtualMetadata);
        this.base = base;
        this.functions = functions;
        int functionCount = functions.size();
        boolean supportsRandomAccess = base.recordCursorSupportsRandomAccess();
        ObjList<Function> memoizedFunctions = new ObjList<Function>();
        int randomCount = 0;
        for (int i = 0; i < functionCount; ++i) {
            Function function = functions.getQuick(i);
            if (supportsRandomAccess && !function.supportsRandomAccess()) {
                supportsRandomAccess = false;
            }
            if (function.isRandom()) {
                ++randomCount;
            }
            if (!allowMemoization || !function.shouldMemoize()) continue;
            memoizedFunctions.add(function);
        }
        this.supportsRandomAccess = supportsRandomAccess && randomCount == 0;
        this.cursor = new VirtualFunctionRecordCursor(functions, memoizedFunctions, this.supportsRandomAccess, virtualColumnReservedSlots);
        this.internalSymbolTableSource = new VirtualRecordCursorFactorySymbolTableSource(this.cursor, virtualColumnReservedSlots);
        this.priorityMetadata = priorityMetadata;
    }

    @Override
    public boolean followedLimitAdvice() {
        return this.base.followedLimitAdvice();
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.base.followedOrderByAdvice();
    }

    @Override
    public String getBaseColumnName(int idx) {
        return this.priorityMetadata.getColumnName(idx);
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor cursor = this.base.getCursor(executionContext);
        try {
            this.internalSymbolTableSource.of(cursor);
            Function.init(this.functions, this.internalSymbolTableSource, executionContext, null);
            this.cursor.of(cursor);
            return this.cursor;
        }
        catch (Throwable th) {
            cursor.close();
            throw th;
        }
    }

    @Override
    public int getScanDirection() {
        return this.base.getScanDirection();
    }

    @Override
    public boolean implementsLimit() {
        return this.base.implementsLimit();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return this.supportsRandomAccess;
    }

    @Override
    public boolean supportsUpdateRowId(TableToken tableToken) {
        return this.base.supportsUpdateRowId(tableToken);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("VirtualRecord");
        sink.optAttr((CharSequence)"functions", this.functions, true);
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    public boolean usesIndex() {
        return this.base.usesIndex();
    }

    @Override
    protected void _close() {
        Misc.freeObjList(this.functions);
        Misc.free(this.base);
    }

    private static class VirtualRecordCursorFactorySymbolTableSource
    implements SymbolTableSource {
        private final RecordCursor own;
        private final int virtualColumnReservedSlots;
        private RecordCursor base;

        public VirtualRecordCursorFactorySymbolTableSource(RecordCursor own, int virtualColumnReservedSlots) {
            this.own = own;
            this.virtualColumnReservedSlots = virtualColumnReservedSlots;
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            if (columnIndex < this.virtualColumnReservedSlots) {
                return this.own.getSymbolTable(columnIndex);
            }
            return this.base.getSymbolTable(columnIndex - this.virtualColumnReservedSlots);
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            if (columnIndex < this.virtualColumnReservedSlots) {
                return this.own.newSymbolTable(columnIndex);
            }
            return this.base.newSymbolTable(columnIndex - this.virtualColumnReservedSlots);
        }

        public void of(RecordCursor base) {
            this.base = base;
        }
    }
}

