/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table.parquet;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.vm.api.MemoryCR;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.griffin.engine.table.parquet.ParquetCompression;
import io.questdb.griffin.engine.table.parquet.ParquetVersion;
import io.questdb.griffin.engine.table.parquet.PartitionDescriptor;
import io.questdb.std.Os;
import io.questdb.std.str.Path;
import io.questdb.std.str.Utf8Sequence;

public class PartitionEncoder {
    public static void encode(PartitionDescriptor descriptor, Path destPath) {
        PartitionEncoder.encodeWithOptions(descriptor, destPath, ParquetCompression.COMPRESSION_UNCOMPRESSED, true, false, 0L, 0L, ParquetVersion.PARQUET_VERSION_V1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encodeWithOptions(PartitionDescriptor descriptor, Path destPath, long compressionCodec, boolean statisticsEnabled, boolean rawArrayEncoding, long rowGroupSize, long dataPageSize, int version) {
        Utf8Sequence tableName = descriptor.getTableName();
        int columnCount = descriptor.getColumnCount();
        long partitionSize = descriptor.getPartitionRowCount();
        int timestampIndex = descriptor.getTimestampIndex();
        try {
            PartitionEncoder.encodePartition(tableName.ptr(), tableName.size(), columnCount, descriptor.getColumnNamesPtr(), descriptor.getColumnNamesLen(), descriptor.getColumnDataPtr(), descriptor.getColumnDataLen(), timestampIndex, partitionSize, destPath.ptr(), destPath.size(), compressionCodec, statisticsEnabled, rawArrayEncoding, rowGroupSize, dataPageSize, version);
        }
        finally {
            descriptor.clear();
        }
    }

    public static void populateFromTableReader(TableReader tableReader, PartitionDescriptor descriptor, int partitionIndex) {
        long partitionSize = tableReader.openPartition(partitionIndex);
        assert (partitionSize != 0L);
        int timestampIndex = tableReader.getMetadata().getTimestampIndex();
        descriptor.of(tableReader.getTableToken().getTableName(), partitionSize, timestampIndex);
        TableReaderMetadata metadata = tableReader.getMetadata();
        int columnCount = metadata.getColumnCount();
        int columnBase = tableReader.getColumnBase(partitionIndex);
        for (int i = 0; i < columnCount; ++i) {
            CharSequence columnName = metadata.getColumnName(i);
            int columnType = metadata.getColumnType(i);
            if (columnType <= 0) continue;
            int columnId = metadata.getColumnMetadata(i).getWriterIndex();
            long colTop = Math.min(tableReader.getColumnTop(columnBase, i), partitionSize);
            int primaryIndex = TableReader.getPrimaryColumnIndex(columnBase, i);
            MemoryCR primaryMem = tableReader.getColumn(primaryIndex);
            if (ColumnType.isSymbol(columnType)) {
                SymbolMapReader symbolMapReader = tableReader.getSymbolMapReader(i);
                MemoryR symbolValuesMem = symbolMapReader.getSymbolValuesColumn();
                MemoryR symbolOffsetsMem = symbolMapReader.getSymbolOffsetsColumn();
                descriptor.addColumn(columnName, columnType, columnId, colTop, primaryMem.addressOf(0L), primaryMem.size(), symbolValuesMem.addressOf(0L), symbolValuesMem.size(), symbolOffsetsMem.addressOf(64L), symbolMapReader.getSymbolCount());
                continue;
            }
            if (ColumnType.isVarSize(columnType)) {
                MemoryCR secondaryMem = tableReader.getColumn(primaryIndex + 1);
                descriptor.addColumn(columnName, columnType, columnId, colTop, primaryMem.addressOf(0L), primaryMem.size(), secondaryMem.addressOf(0L), secondaryMem.size(), 0L, 0L);
                continue;
            }
            descriptor.addColumn(columnName, columnType, columnId, colTop, primaryMem.addressOf(0L), primaryMem.size(), 0L, 0L, 0L, 0L);
        }
    }

    private static native void encodePartition(long var0, int var2, int var3, long var4, int var6, long var7, long var9, int var11, long var12, long var14, int var16, long var17, boolean var19, boolean var20, long var21, long var23, int var25) throws CairoException;

    static {
        Os.init();
    }
}

