/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.KqueueAccessor;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.KqueueFacade;
import io.questdb.network.NetworkError;
import io.questdb.std.Files;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import java.io.Closeable;

public final class Kqueue
implements Closeable {
    private static final Log LOG = LogFactory.getLog(Kqueue.class);
    private final int bufferSize;
    private final int capacity;
    private final long changeList;
    private final long eventList;
    private final long kq;
    private final KqueueFacade kqf;
    private long readAddress;
    private long writeAddress;

    public Kqueue(KqueueFacade kqf, int capacity) {
        try {
            this.kqf = kqf;
            this.capacity = capacity;
            this.bufferSize = KqueueAccessor.SIZEOF_KEVENT * capacity;
            this.changeList = this.writeAddress = Unsafe.calloc(this.bufferSize, 36);
            this.eventList = this.readAddress = Unsafe.calloc(this.bufferSize, 36);
            this.kq = Files.createUniqueFd(kqf.kqueue());
            if (this.kq < 0L) {
                throw NetworkError.instance(kqf.getNetworkFacade().errno(), "could not create kqueue");
            }
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
    }

    @Override
    public void close() {
        this.kqf.getNetworkFacade().close(this.kq, LOG);
        Unsafe.free(this.changeList, this.bufferSize, 36);
        Unsafe.free(this.eventList, this.bufferSize, 36);
    }

    public int getData() {
        return Unsafe.getUnsafe().getInt(this.readAddress + (long)KqueueAccessor.DATA_OFFSET);
    }

    public long getFd() {
        int osFd = Unsafe.getUnsafe().getInt(this.readAddress + (long)KqueueAccessor.FD_OFFSET);
        int uniqueFd = Unsafe.getUnsafe().getInt(this.readAddress + (long)KqueueAccessor.DATA_OFFSET + 4L);
        return Numbers.encodeLowHighInts(uniqueFd, osFd);
    }

    public int getFilter() {
        return Unsafe.getUnsafe().getShort(this.readAddress + (long)KqueueAccessor.FILTER_OFFSET);
    }

    public int listen(long sfd) {
        this.writeAddress = this.changeList;
        this.commonFd(sfd, 0);
        Unsafe.getUnsafe().putShort(this.writeAddress + (long)KqueueAccessor.FILTER_OFFSET, KqueueAccessor.EVFILT_READ);
        Unsafe.getUnsafe().putShort(this.writeAddress + (long)KqueueAccessor.FLAGS_OFFSET, KqueueAccessor.EV_ADD);
        return this.register(1);
    }

    public int poll(int timeout) {
        return this.kqf.kevent(this.kq, 0L, 0, this.eventList, this.capacity, timeout);
    }

    public void readFD(long fd, int data) {
        this.commonFd(fd, data);
        Unsafe.getUnsafe().putShort(this.writeAddress + (long)KqueueAccessor.FILTER_OFFSET, KqueueAccessor.EVFILT_READ);
        Unsafe.getUnsafe().putShort(this.writeAddress + (long)KqueueAccessor.FLAGS_OFFSET, (short)(KqueueAccessor.EV_ADD | KqueueAccessor.EV_ONESHOT));
    }

    public int register(int n) {
        return this.kqf.kevent(this.kq, this.changeList, n, 0L, 0, 0);
    }

    public int removeListen(long sfd) {
        this.writeAddress = this.changeList;
        this.commonFd(sfd, 0);
        Unsafe.getUnsafe().putShort(this.writeAddress + (long)KqueueAccessor.FILTER_OFFSET, KqueueAccessor.EVFILT_READ);
        Unsafe.getUnsafe().putShort(this.writeAddress + (long)KqueueAccessor.FLAGS_OFFSET, KqueueAccessor.EV_DELETE);
        return this.register(1);
    }

    public void removeReadFD(long fd) {
        this.commonFd(fd, 0);
        Unsafe.getUnsafe().putShort(this.writeAddress + (long)KqueueAccessor.FILTER_OFFSET, KqueueAccessor.EVFILT_READ);
        Unsafe.getUnsafe().putShort(this.writeAddress + (long)KqueueAccessor.FLAGS_OFFSET, KqueueAccessor.EV_DELETE);
    }

    public void removeWriteFD(long fd) {
        this.commonFd(fd, 0);
        Unsafe.getUnsafe().putShort(this.writeAddress + (long)KqueueAccessor.FILTER_OFFSET, KqueueAccessor.EVFILT_WRITE);
        Unsafe.getUnsafe().putShort(this.writeAddress + (long)KqueueAccessor.FLAGS_OFFSET, KqueueAccessor.EV_DELETE);
    }

    public void setReadOffset(int offset) {
        this.readAddress = this.eventList + (long)offset;
    }

    public void setWriteOffset(int offset) {
        this.writeAddress = this.changeList + (long)offset;
    }

    public void writeFD(long fd, int data) {
        this.commonFd(fd, data);
        Unsafe.getUnsafe().putShort(this.writeAddress + (long)KqueueAccessor.FILTER_OFFSET, KqueueAccessor.EVFILT_WRITE);
        Unsafe.getUnsafe().putShort(this.writeAddress + (long)KqueueAccessor.FLAGS_OFFSET, (short)(KqueueAccessor.EV_ADD | KqueueAccessor.EV_ONESHOT));
    }

    private void commonFd(long fd, int data) {
        Unsafe.getUnsafe().putLong(this.writeAddress + (long)KqueueAccessor.FD_OFFSET, Files.toOsFd(fd));
        Unsafe.getUnsafe().putInt(this.writeAddress + (long)KqueueAccessor.DATA_OFFSET, data);
        Unsafe.getUnsafe().putInt(this.writeAddress + (long)KqueueAccessor.DATA_OFFSET + 4L, Numbers.decodeLowInt(fd));
    }
}

