/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import com.sun.management.OperatingSystemMXBean;
import io.questdb.std.Chars;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.ex.FatalError;
import io.questdb.std.ex.KerberosException;
import io.questdb.std.str.Path;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.nio.file.Paths;
import java.util.concurrent.locks.LockSupport;
import org.jetbrains.annotations.NotNull;

public final class Os {
    public static final int ARCH_AARCH64 = 1;
    public static final int ARCH_X86_64 = 2;
    public static final int DARWIN = 1;
    public static final int FREEBSD = 4;
    public static final int LINUX = 2;
    public static final long PARK_NANOS_MAX = 5000000000L;
    public static final int WINDOWS = 3;
    public static final int _32Bit = -2;
    public static final int arch;
    public static final String archName;
    public static final String name;
    public static final int type;

    private Os() {
    }

    public static native long compareAndSwap(long var0, long var2, long var4);

    public static native long currentTimeMicros();

    public static native long currentTimeNanos();

    public static native int errno();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long forkExec(CharSequence args) {
        ObjList<Path> paths = Chars.splitLpsz(args);
        int n = paths.size();
        try {
            long l;
            long argv = Unsafe.malloc((long)(n + 1) * 8L, 19);
            try {
                long p = argv;
                for (int i = 0; i < n; ++i) {
                    Unsafe.getUnsafe().putLong(p, paths.getQuick(i).ptr());
                    p += 8L;
                }
                Unsafe.getUnsafe().putLong(p, 0L);
                l = Os.forkExec(argv);
            }
            catch (Throwable throwable) {
                Unsafe.free(argv, n + 1, 19);
                throw throwable;
            }
            Unsafe.free(argv, n + 1, 19);
            return l;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                paths.getQuick(i).close();
            }
        }
    }

    public static int forkExecPid(long forkExecT) {
        return Unsafe.getUnsafe().getInt(forkExecT + 8L);
    }

    public static int forkExecReadFd(long forkExecT) {
        return Unsafe.getUnsafe().getInt(forkExecT);
    }

    public static int forkExecWriteFd(long forkExecT) {
        return Unsafe.getUnsafe().getInt(forkExecT + 4L);
    }

    public static native void free(long var0);

    public static byte[] generateKerberosToken(CharSequence spn) throws KerberosException {
        try (Path sink = new Path().of(spn);){
            long struct = Os.generateKrbToken(sink.$().ptr());
            int status = Unsafe.getUnsafe().getInt(struct);
            int bufLen = Unsafe.getUnsafe().getInt(struct + 4L);
            long ptoken = Unsafe.getUnsafe().getLong(struct + 8L);
            if (status != 0) {
                Os.freeKrbToken(struct);
                throw new KerberosException(status);
            }
            byte[] token = new byte[bufLen];
            for (int i = 0; i < bufLen; ++i) {
                token[i] = Unsafe.getUnsafe().getByte(ptoken + (long)i);
            }
            Os.freeKrbToken(struct);
            byte[] byArray = token;
            return byArray;
        }
    }

    public static native int getEnvironmentType();

    public static long getMemorySizeFromMXBean() {
        OperatingSystemMXBean bean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        if (bean == null) {
            return -1L;
        }
        return bean.getTotalPhysicalMemorySize();
    }

    public static native int getPid();

    public static native long getRss();

    public static void init() {
    }

    public static boolean isFreeBSD() {
        return type == 4;
    }

    public static boolean isLinux() {
        return type == 2;
    }

    public static boolean isOSX() {
        return type == 1;
    }

    public static boolean isPosix() {
        return type != 3;
    }

    public static native boolean isRustReleaseBuild();

    public static boolean isWindows() {
        return type == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLib(String lib, @NotNull InputStream libStream) {
        try {
            File tempLib = null;
            try {
                int dot = lib.indexOf(46);
                tempLib = File.createTempFile(lib.substring(0, dot), lib.substring(dot));
                try (FileOutputStream out = new FileOutputStream(tempLib);){
                    int read;
                    byte[] buf = new byte[4096];
                    while ((read = libStream.read(buf)) != -1) {
                        out.write(buf, 0, read);
                    }
                }
                finally {
                    tempLib.deleteOnExit();
                }
                System.load(tempLib.getAbsolutePath());
            }
            catch (IOException e) {
                throw new FatalError("Internal error: cannot unpack " + String.valueOf(tempLib), e);
            }
        }
        finally {
            Misc.free(libStream);
        }
    }

    public static native long malloc(long var0);

    public static void park() {
        LockSupport.parkNanos(5000000000L);
    }

    public static void pause() {
        try {
            Thread.sleep(0L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static native long realloc(long var0, long var2);

    public static int setCurrentThreadAffinity(int cpu) {
        if (cpu == -1) {
            return 0;
        }
        return Os.setCurrentThreadAffinity0(cpu);
    }

    public static void sleep(long millis) {
        long t2;
        long t = System.currentTimeMillis();
        for (long deadline = millis; deadline > 0L; deadline -= t2 - t) {
            try {
                Thread.sleep(deadline);
                break;
            }
            catch (InterruptedException e) {
                t2 = System.currentTimeMillis();
                t = t2;
                continue;
            }
        }
    }

    public static native long smokeTest(long var0, long var2);

    private static native long forkExec(long var0);

    private static native void freeKrbToken(long var0);

    private static native long generateKrbToken(long var0);

    private static native void initRust();

    private static void loadLib(String lib) {
        InputStream is = Os.class.getResourceAsStream(lib);
        if (is == null) {
            throw new FatalError("Internal error: cannot find " + lib + ", broken package?");
        }
        Os.loadLib(lib, is);
    }

    private static native int setCurrentThreadAffinity0(int var0);

    private static boolean tryLoadFromDistribution(String cxxLibName, String rustLibName) {
        String libsDir = System.getProperty("questdb.libs.dir");
        if (libsDir == null) {
            return false;
        }
        try {
            System.load(Paths.get(libsDir, cxxLibName).toAbsolutePath().toString());
            System.load(Paths.get(libsDir, rustLibName).toAbsolutePath().toString());
        }
        catch (Throwable e) {
            System.err.println("Failed to load libraries from " + libsDir + ": " + e.getMessage());
            return false;
        }
        return true;
    }

    static {
        if ("aarch64".equals(System.getProperty("os.arch"))) {
            arch = 1;
            archName = "aarch64";
        } else {
            arch = 2;
            archName = "x86-64";
        }
        if ("64".equals(System.getProperty("sun.arch.data.model"))) {
            String outputLibExt;
            String osName = System.getProperty("os.name");
            if (osName.contains("Linux")) {
                name = "linux";
                outputLibExt = ".so";
                type = 2;
            } else if (osName.contains("Mac")) {
                name = "darwin";
                outputLibExt = ".dylib";
                type = 1;
            } else if (osName.contains("Windows")) {
                name = "windows";
                outputLibExt = ".dll";
                type = 3;
            } else if (osName.contains("FreeBSD")) {
                name = "freebsd";
                outputLibExt = ".so";
                type = 4;
            } else {
                throw new Error("Unsupported OS: " + osName);
            }
            String prdLibRoot = "/io/questdb/bin/" + name + "-" + archName + "/";
            String devCXXLibRoot = "/io/questdb/bin-local/";
            String cxxLibName = "libquestdb" + outputLibExt;
            String devCXXLib = devCXXLibRoot + cxxLibName;
            String devRustLibRoot = "/io/questdb/rust/";
            String rustLibName = type == 3 ? "questdbr" + outputLibExt : "libquestdbr" + outputLibExt;
            boolean loaded = Os.tryLoadFromDistribution(cxxLibName, rustLibName);
            if (!loaded) {
                InputStream libCXXStream = Os.class.getResourceAsStream(devCXXLib);
                if (libCXXStream == null) {
                    Os.loadLib(prdLibRoot + cxxLibName);
                } else {
                    System.err.println("Loading DEV CXX library: " + devCXXLib);
                    Os.loadLib(devCXXLib, libCXXStream);
                }
                String devRustLib = devRustLibRoot + rustLibName;
                InputStream libRustStream = Os.class.getResourceAsStream(devRustLib);
                if (libRustStream == null) {
                    Os.loadLib(prdLibRoot + rustLibName);
                } else {
                    Os.loadLib(devRustLib, libRustStream);
                }
            }
            Os.initRust();
        } else {
            type = -2;
            name = System.getProperty("os.name");
        }
    }
}

