/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.datetime;

import io.questdb.std.ConcurrentIntHashMap;
import io.questdb.std.LongList;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.TimeZoneRules;
import io.questdb.std.datetime.Transition;
import io.questdb.std.datetime.TransitionRule;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.zone.ZoneOffsetTransitionRule;
import java.time.zone.ZoneRules;
import java.util.function.IntFunction;

public abstract class AbstractTimeZoneRules
implements TimeZoneRules {
    private static final int L1_CACHE_YEAR_HI = 2051;
    private static final int L1_CACHE_YEAR_LO = 2000;
    private static final long LAST_RULES_OFFSET = Unsafe.getFieldOffset(ZoneRules.class, "lastRules");
    private static final long SAVING_INSTANT_TRANSITIONS_OFFSET = Unsafe.getFieldOffset(ZoneRules.class, "savingsInstantTransitions");
    private static final long SAVING_LOCAL_TRANSITIONS_OFFSET = Unsafe.getFieldOffset(ZoneRules.class, "savingsLocalTransitions");
    private static final long STANDARD_OFFSETS_OFFSET = Unsafe.getFieldOffset(ZoneRules.class, "standardOffsets");
    private static final long WALL_OFFSETS_OFFSET = Unsafe.getFieldOffset(ZoneRules.class, "wallOffsets");
    private final IntFunction<Transition[]> computeTransitionsRef;
    private final long cutoffTransition;
    private final long firstWall;
    private final LongList historicTransitions = new LongList();
    private final long lastWall;
    private final long localCutoffTransition;
    private final LongList localHistoricTransitions = new LongList();
    private final long multiplier;
    private final int ruleCount;
    private final TransitionRule[] rules;
    private final long standardOffset;
    private final Transition[][] transitionsL1Cache;
    private final ConcurrentIntHashMap<Transition[]> transitionsL2Cache;
    private final int[] wallOffsets;

    public AbstractTimeZoneRules(ZoneRules rules, long multiplier) {
        this.multiplier = multiplier;
        this.computeTransitionsRef = this::computeTransitions;
        long[] savingsInstantTransitions = (long[])Unsafe.getUnsafe().getObject(rules, SAVING_INSTANT_TRANSITIONS_OFFSET);
        if (savingsInstantTransitions.length == 0) {
            ZoneOffset[] standardOffsets = (ZoneOffset[])Unsafe.getUnsafe().getObject(rules, STANDARD_OFFSETS_OFFSET);
            this.standardOffset = (long)standardOffsets[0].getTotalSeconds() * multiplier;
        } else {
            this.standardOffset = Long.MIN_VALUE;
            int n = savingsInstantTransitions.length;
            for (int i = 0; i < n; ++i) {
                this.historicTransitions.add(savingsInstantTransitions[i] * multiplier);
            }
        }
        this.cutoffTransition = this.historicTransitions.getLast();
        ZoneOffsetTransitionRule[] lastRules = (ZoneOffsetTransitionRule[])Unsafe.getUnsafe().getObject(rules, LAST_RULES_OFFSET);
        this.rules = new TransitionRule[lastRules.length];
        int n = lastRules.length;
        for (int i = 0; i < n; ++i) {
            TransitionRule tr;
            int timeDef;
            ZoneOffsetTransitionRule zr = lastRules[i];
            switch (zr.getTimeDefinition()) {
                case UTC: {
                    timeDef = 0;
                    break;
                }
                case STANDARD: {
                    timeDef = 1;
                    break;
                }
                default: {
                    timeDef = 2;
                }
            }
            this.rules[i] = tr = new TransitionRule(zr.getOffsetBefore().getTotalSeconds(), zr.getOffsetAfter().getTotalSeconds(), zr.getStandardOffset().getTotalSeconds(), zr.getDayOfWeek() == null ? -1 : zr.getDayOfWeek().getValue(), zr.getDayOfMonthIndicator(), zr.getMonth().getValue(), zr.isMidnightEndOfDay(), zr.getLocalTime().getHour(), zr.getLocalTime().getMinute(), zr.getLocalTime().getSecond(), timeDef);
        }
        this.ruleCount = lastRules.length;
        ZoneOffset[] wallOffsets = (ZoneOffset[])Unsafe.getUnsafe().getObject(rules, WALL_OFFSETS_OFFSET);
        this.wallOffsets = new int[wallOffsets.length];
        int n2 = wallOffsets.length;
        for (int i = 0; i < n2; ++i) {
            this.wallOffsets[i] = wallOffsets[i].getTotalSeconds();
        }
        this.firstWall = (long)this.wallOffsets[0] * multiplier;
        this.lastWall = (long)this.wallOffsets[wallOffsets.length - 1] * multiplier;
        LocalDateTime[] savingsLocalTransitions = (LocalDateTime[])Unsafe.getUnsafe().getObject(rules, SAVING_LOCAL_TRANSITIONS_OFFSET);
        int n3 = savingsLocalTransitions.length;
        for (int i = 0; i < n3; ++i) {
            this.localHistoricTransitions.add(savingsLocalTransitions[i].toInstant(ZoneOffset.UTC).getEpochSecond() * multiplier);
        }
        this.localCutoffTransition = this.localHistoricTransitions.getLast();
        int cutoffYear = this.getYear(this.cutoffTransition);
        if (this.ruleCount > 0 && cutoffYear < 2051) {
            this.transitionsL1Cache = new Transition[51][];
            int n4 = this.transitionsL1Cache.length;
            for (int i = Math.max(0, cutoffYear - 2000); i < n4; ++i) {
                this.transitionsL1Cache[i] = this.computeTransitions(i + 2000);
            }
        } else {
            this.transitionsL1Cache = null;
        }
        this.transitionsL2Cache = this.ruleCount > 0 ? new ConcurrentIntHashMap() : null;
    }

    @Override
    public long getDstGapOffset(long localEpoch) {
        if (this.standardOffset != Long.MIN_VALUE) {
            return 0L;
        }
        if (this.ruleCount > 0 && localEpoch > this.localCutoffTransition) {
            return this.gapOffsetFromRules(localEpoch);
        }
        if (localEpoch > this.localCutoffTransition) {
            return 0L;
        }
        return this.gapOffsetFromHistory(localEpoch);
    }

    @Override
    public long getLocalOffset(long localEpoch, int year) {
        if (this.standardOffset != Long.MIN_VALUE) {
            return this.standardOffset;
        }
        if (this.ruleCount > 0 && localEpoch > this.localCutoffTransition) {
            return this.localOffsetFromRules(localEpoch, year);
        }
        if (localEpoch > this.localCutoffTransition) {
            return this.lastWall;
        }
        return this.localOffsetFromHistory(localEpoch);
    }

    @Override
    public long getLocalOffset(long localEpoch) {
        int y = this.getYear(localEpoch);
        return this.getLocalOffset(localEpoch, y);
    }

    @Override
    public long getNextDST(long utcEpoch, int year) {
        if (this.standardOffset != Long.MIN_VALUE) {
            return Long.MAX_VALUE;
        }
        if (this.ruleCount > 0 && utcEpoch >= this.cutoffTransition) {
            return this.dstFromRules(utcEpoch, year);
        }
        if (utcEpoch < this.cutoffTransition) {
            return this.dstFromHistory(utcEpoch);
        }
        return Long.MAX_VALUE;
    }

    @Override
    public long getNextDST(long utcEpoch) {
        int y = this.getYear(utcEpoch);
        return this.getNextDST(utcEpoch, y);
    }

    @Override
    public long getOffset(long utcEpoch, int year) {
        if (this.standardOffset != Long.MIN_VALUE) {
            return this.standardOffset;
        }
        if (this.ruleCount > 0 && utcEpoch > this.cutoffTransition) {
            return this.offsetFromRules(utcEpoch, year);
        }
        if (utcEpoch > this.cutoffTransition) {
            return this.lastWall;
        }
        return this.offsetFromHistory(utcEpoch);
    }

    @Override
    public long getOffset(long utcEpoch) {
        int y = this.getYear(utcEpoch);
        return this.getOffset(utcEpoch, y);
    }

    @Override
    public boolean hasFixedOffset() {
        return this.standardOffset != Long.MIN_VALUE;
    }

    private Transition[] computeTransitions(int year) {
        Transition[] transitions = new Transition[this.ruleCount];
        boolean leap = this.isLeapYear(year);
        for (int i = 0; i < this.ruleCount; ++i) {
            long timestamp;
            TransitionRule zr = this.rules[i];
            int offsetBefore = zr.offsetBefore;
            int dom = zr.dom;
            int month = zr.month;
            int dow = zr.dow;
            if (dom < 0) {
                timestamp = this.toEpoch(year, leap, month, this.getDaysPerMonth(month, leap) + 1 + dom, zr.hour, zr.minute) + (long)zr.second * this.multiplier;
                if (dow > -1) {
                    timestamp = this.previousOrSameDayOfWeek(timestamp, dow);
                }
            } else {
                assert (month > 0);
                timestamp = this.toEpoch(year, leap, month, dom, zr.hour, zr.minute) + (long)zr.second * this.multiplier;
                if (dow > -1) {
                    timestamp = this.nextOrSameDayOfWeek(timestamp, dow);
                }
            }
            if (zr.midnightEOD) {
                timestamp = this.addDays(timestamp, 1);
            }
            switch (zr.timeDef) {
                case 0: {
                    timestamp += (long)(offsetBefore - ZoneOffset.UTC.getTotalSeconds()) * this.multiplier;
                    break;
                }
                case 1: {
                    timestamp += (long)(offsetBefore - zr.standardOffset) * this.multiplier;
                    break;
                }
            }
            transitions[i] = new Transition((long)zr.offsetBefore * this.multiplier, (long)zr.offsetAfter * this.multiplier, timestamp - (long)offsetBefore * this.multiplier);
        }
        return transitions;
    }

    private long dstFromHistory(long utcEpoch) {
        int index = this.historicTransitions.binarySearch(utcEpoch, -1);
        if (index == -1) {
            return Long.MAX_VALUE;
        }
        if (index < 0) {
            index = -index - 2;
        }
        return this.historicTransitions.getQuick(index + 1);
    }

    private long dstFromRules(long utcEpoch, int year) {
        for (int i = 0; i < this.ruleCount; ++i) {
            long date = this.getDSTFromRule(year, i);
            if (utcEpoch >= date) continue;
            return date;
        }
        if (this.ruleCount > 0) {
            return this.getDSTFromRule(year + 1, 0);
        }
        return Long.MAX_VALUE;
    }

    private long gapOffsetFromHistory(long localEpoch) {
        int offsetAfter;
        int offsetBefore;
        int index = this.localHistoricTransitions.binarySearch(localEpoch, -1);
        if (index == -1) {
            return 0L;
        }
        if (index < 0) {
            index = -index - 2;
        }
        if ((index & 1) == 0 && (offsetBefore = this.wallOffsets[index / 2]) < (offsetAfter = this.wallOffsets[index / 2 + 1])) {
            return localEpoch - this.localHistoricTransitions.get(index);
        }
        return 0L;
    }

    private long gapOffsetFromRules(long localEpoch) {
        int year = this.getYear(localEpoch);
        for (Transition tr : this.getTransitions(year)) {
            long localBefore = tr.transition + tr.offsetBefore;
            long localAfter = tr.transition + tr.offsetAfter;
            if (localEpoch < localBefore || localEpoch >= localAfter) continue;
            return localEpoch - localBefore;
        }
        return 0L;
    }

    private long getDSTFromRule(int year, int i) {
        Transition[] transitions = this.getTransitions(year);
        return transitions[i].transition;
    }

    private Transition[] getTransitions(int year) {
        if (year >= 2000 && year < 2051) {
            return this.transitionsL1Cache[year - 2000];
        }
        Transition[] transitions = this.transitionsL2Cache.get(year);
        if (transitions != null) {
            return transitions;
        }
        return this.transitionsL2Cache.computeIfAbsent(year, this.computeTransitionsRef);
    }

    private long localOffsetFromHistory(long localEpoch) {
        int index = this.localHistoricTransitions.binarySearch(localEpoch, -1);
        if (index == -1) {
            return this.firstWall;
        }
        if (index < 0) {
            index = -index - 2;
        }
        index = index + 1 & 0xFFFFFFFE;
        return (long)this.wallOffsets[index / 2] * this.multiplier;
    }

    private long localOffsetFromRules(long localEpoch, int year) {
        Transition[] transitions = this.getTransitions(year);
        long offsetAfterUs = 0L;
        for (Transition tr : transitions) {
            long localTransition = tr.transition + tr.offsetBefore;
            long gapDuration = Math.max(tr.offsetAfter - tr.offsetBefore, 0L);
            if (localEpoch < localTransition || localEpoch < localTransition + gapDuration) {
                return tr.offsetBefore;
            }
            offsetAfterUs = tr.offsetAfter;
        }
        return offsetAfterUs;
    }

    private long offsetFromHistory(long utcEpoch) {
        int index = this.historicTransitions.binarySearch(utcEpoch, -1);
        if (index == -1) {
            return this.firstWall;
        }
        if (index < 0) {
            index = -index - 2;
        }
        return (long)this.wallOffsets[index + 1] * this.multiplier;
    }

    private long offsetFromRules(long utcEpoch, int year) {
        Transition[] transitions = this.getTransitions(year);
        long offsetAfterUs = 0L;
        for (Transition tr : transitions) {
            if (utcEpoch < tr.transition) {
                return tr.offsetBefore;
            }
            offsetAfterUs = tr.offsetAfter;
        }
        return offsetAfterUs;
    }

    protected abstract long addDays(long var1, int var3);

    protected abstract int getDaysPerMonth(int var1, boolean var2);

    protected abstract int getYear(long var1);

    protected abstract boolean isLeapYear(int var1);

    protected abstract long nextOrSameDayOfWeek(long var1, int var3);

    protected abstract long previousOrSameDayOfWeek(long var1, int var3);

    protected abstract long toEpoch(int var1, boolean var2, int var3, int var4, int var5, int var6);
}

