/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.cairo.CairoException;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Unsafe;
import io.questdb.std.str.AsciiCharSequence;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.StableStringSource;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8s;
import org.jetbrains.annotations.NotNull;

public class Utf8SplitString
implements DirectUtf8Sequence,
Mutable {
    private final AsciiCharSequence asciiCharSequence = new AsciiCharSequence();
    private final StableStringSource stableSource;
    private boolean ascii;
    private long dataLim;
    private long dataLo;
    private long prefixLo;
    private int size;

    public Utf8SplitString() {
        this.stableSource = StableStringSource.UNSTABLE_SOURCE;
    }

    public Utf8SplitString(StableStringSource stableSource) {
        this.stableSource = stableSource;
    }

    @Override
    @NotNull
    public CharSequence asAsciiCharSequence() {
        return this.asciiCharSequence.of(this);
    }

    @Override
    public byte byteAt(int index) {
        return Unsafe.getUnsafe().getByte(this.dataLo + (long)index);
    }

    @Override
    public void clear() {
        this.dataLo = 0L;
        this.prefixLo = 0L;
        this.ascii = false;
    }

    @Override
    public int intAt(int offset) {
        return Unsafe.getUnsafe().getInt(this.dataLo + (long)offset);
    }

    @Override
    public boolean isAscii() {
        return this.ascii;
    }

    @Override
    public boolean isStable() {
        return this.stableSource.isStable();
    }

    @Override
    public long longAt(int offset) {
        return Unsafe.getUnsafe().getLong(this.dataLo + (long)offset);
    }

    public Utf8SplitString of(long prefixLo, long dataLo, long dataLim, int size, boolean ascii) {
        if (dataLim < dataLo + (long)size) {
            throw CairoException.critical(0).put("varchar is outside of file boundary [dataLim=").put(dataLim).put(", dataLo=").put(dataLo).put(", size=").put(size).put(']');
        }
        this.prefixLo = prefixLo;
        this.dataLo = dataLo;
        this.dataLim = dataLim;
        this.size = size;
        this.ascii = ascii;
        return this;
    }

    @Override
    public long ptr() {
        return this.dataLo;
    }

    @Override
    public short shortAt(int offset) {
        return Unsafe.getUnsafe().getShort(this.dataLo + (long)offset);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public long tailPadding() {
        return this.dataLim - this.dataLo - (long)this.size;
    }

    @NotNull
    public String toString() {
        StringSink utf16Sink = Misc.getThreadLocalSink();
        Utf8s.utf8ToUtf16(this, utf16Sink);
        return ((Object)utf16Sink).toString();
    }

    @Override
    public long zeroPaddedSixPrefix() {
        return Unsafe.getUnsafe().getLong(this.prefixLo) & 0xFFFFFFFFFFFFL;
    }
}

