/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Unsafe;
import io.questdb.std.bytes.Bytes;
import io.questdb.std.str.AsciiCharSequence;
import io.questdb.std.str.MutableUtf8Sink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8s;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Utf8StringSink
implements MutableUtf8Sink {
    private final AsciiCharSequence asciiCharSequence = new AsciiCharSequence();
    private final int initialCapacity;
    private boolean ascii;
    private byte[] buffer;
    private int pos;

    public Utf8StringSink() {
        this(32);
    }

    public Utf8StringSink(int initialCapacity) {
        this.initialCapacity = initialCapacity;
        this.buffer = new byte[initialCapacity];
        this.pos = 0;
        this.ascii = true;
    }

    @Override
    @NotNull
    public CharSequence asAsciiCharSequence() {
        return this.asciiCharSequence.of(this);
    }

    @Override
    public byte byteAt(int index) {
        return this.buffer[index];
    }

    @Override
    public void clear() {
        this.clear(0);
    }

    public void clear(int pos) {
        this.pos = pos;
        this.ascii = true;
    }

    public long getCapacity() {
        return this.buffer.length;
    }

    @Override
    public int intAt(int offset) {
        return Unsafe.byteArrayGetInt(this.buffer, offset);
    }

    @Override
    public boolean isAscii() {
        return this.ascii;
    }

    @Override
    public long longAt(int offset) {
        return Unsafe.byteArrayGetLong(this.buffer, offset);
    }

    @Override
    public Utf8StringSink put(@Nullable Utf8Sequence us) {
        if (us != null) {
            this.ascii &= us.isAscii();
            int s = us.size();
            this.checkCapacity(s);
            for (int i = 0; i < s; ++i) {
                this.buffer[this.pos + i] = us.byteAt(i);
            }
            this.pos += s;
        }
        return this;
    }

    @Override
    public Utf8StringSink put(byte b) {
        assert (b < 0) : "b is ascii";
        this.ascii = false;
        return this.putByte0(b);
    }

    @Override
    public Utf8StringSink putAny(byte b) {
        this.ascii &= b >= 0;
        return this.putByte0(b);
    }

    @Override
    public Utf8StringSink putAscii(char c) {
        return this.putByte0((byte)c);
    }

    @Override
    public Utf8StringSink putNonAscii(long lo, long hi) {
        this.ascii = false;
        this.checkCapacity(Bytes.checkedLoHiSize(lo, hi, this.pos));
        for (long p = lo; p < hi; ++p) {
            this.buffer[this.pos++] = Unsafe.getUnsafe().getByte(p);
        }
        return this;
    }

    public Utf8StringSink repeat(@NotNull CharSequence value, int n) {
        for (int i = 0; i < n; ++i) {
            this.put(value);
        }
        return this;
    }

    public Utf8StringSink repeat(char value, int n) {
        if (value < '\u0080') {
            return this.putByte0Repeat((byte)value, n);
        }
        for (int i = 0; i < n; ++i) {
            this.put(value);
        }
        return this;
    }

    public void resetCapacity() {
        this.buffer = new byte[this.initialCapacity];
        this.clear();
    }

    @Override
    public short shortAt(int offset) {
        return Unsafe.byteArrayGetShort(this.buffer, offset);
    }

    @Override
    public int size() {
        return this.pos;
    }

    @NotNull
    public String toString() {
        return Utf8s.stringFromUtf8Bytes(this);
    }

    private void checkCapacity(int extra) {
        assert (extra >= 0);
        int size = this.pos + extra;
        if (this.buffer.length >= size) {
            return;
        }
        size = Math.max(this.pos * 2, size);
        byte[] n = new byte[size];
        System.arraycopy(this.buffer, 0, n, 0, this.pos);
        this.buffer = n;
    }

    @NotNull
    private Utf8StringSink putByte0(byte b) {
        this.checkCapacity(1);
        this.buffer[this.pos++] = b;
        return this;
    }

    @NotNull
    private Utf8StringSink putByte0Repeat(byte b, int n) {
        this.checkCapacity(n);
        for (int i = 0; i < n; ++i) {
            this.buffer[this.pos++] = b;
        }
        return this;
    }
}

