/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring6.processor;

import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeDefinition;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.spring6.context.IThymeleafBindStatus;
import org.thymeleaf.spring6.processor.AbstractSpringFieldTagProcessor;
import org.thymeleaf.spring6.requestdata.RequestDataValueProcessorUtils;
import org.thymeleaf.spring6.util.SpringValueFormatter;
import org.thymeleaf.standard.util.StandardProcessorUtils;

public final class SpringInputGeneralFieldTagProcessor
extends AbstractSpringFieldTagProcessor {
    public static final String TEXT_INPUT_TYPE_ATTR_VALUE = "text";
    public static final String HIDDEN_INPUT_TYPE_ATTR_VALUE = "hidden";
    public static final String DATETIME_INPUT_TYPE_ATTR_VALUE = "datetime";
    public static final String DATETIMELOCAL_INPUT_TYPE_ATTR_VALUE = "datetime-local";
    public static final String DATE_INPUT_TYPE_ATTR_VALUE = "date";
    public static final String MONTH_INPUT_TYPE_ATTR_VALUE = "month";
    public static final String TIME_INPUT_TYPE_ATTR_VALUE = "time";
    public static final String WEEK_INPUT_TYPE_ATTR_VALUE = "week";
    public static final String NUMBER_INPUT_TYPE_ATTR_VALUE = "number";
    public static final String RANGE_INPUT_TYPE_ATTR_VALUE = "range";
    public static final String EMAIL_INPUT_TYPE_ATTR_VALUE = "email";
    public static final String URL_INPUT_TYPE_ATTR_VALUE = "url";
    public static final String SEARCH_INPUT_TYPE_ATTR_VALUE = "search";
    public static final String TEL_INPUT_TYPE_ATTR_VALUE = "tel";
    public static final String COLOR_INPUT_TYPE_ATTR_VALUE = "color";
    private static final String[] ALL_TYPE_ATTR_VALUES = new String[]{null, "text", "hidden", "datetime", "datetime-local", "date", "month", "time", "week", "number", "range", "email", "url", "search", "tel", "color"};

    public SpringInputGeneralFieldTagProcessor(String dialectPrefix) {
        super(dialectPrefix, "input", "type", ALL_TYPE_ATTR_VALUES, true);
    }

    @Override
    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IThymeleafBindStatus bindStatus, IElementTagStructureHandler structureHandler) {
        String name = bindStatus.getExpression();
        name = name == null ? "" : name;
        String id = this.computeId(context, tag, name, false);
        String type = tag.getAttributeValue(this.typeAttributeDefinition.getAttributeName());
        String value = SpringInputGeneralFieldTagProcessor.applyConversion(type) ? SpringValueFormatter.getDisplayString(bindStatus.getValue(), bindStatus.getEditor(), true) : SpringValueFormatter.getDisplayString(bindStatus.getActualValue(), true);
        StandardProcessorUtils.setAttribute((IElementTagStructureHandler)structureHandler, (AttributeDefinition)this.idAttributeDefinition, (String)"id", (String)id);
        StandardProcessorUtils.setAttribute((IElementTagStructureHandler)structureHandler, (AttributeDefinition)this.nameAttributeDefinition, (String)"name", (String)name);
        StandardProcessorUtils.setAttribute((IElementTagStructureHandler)structureHandler, (AttributeDefinition)this.valueAttributeDefinition, (String)"value", (String)RequestDataValueProcessorUtils.processFormFieldValue(context, name, value, type));
    }

    private static boolean applyConversion(String type) {
        return type == null || !NUMBER_INPUT_TYPE_ATTR_VALUE.equalsIgnoreCase(type) && !RANGE_INPUT_TYPE_ATTR_VALUE.equalsIgnoreCase(type);
    }
}

