/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.ai.tools.impl;

import com.usthe.sureness.subject.SubjectSum;
import org.apache.hertzbeat.ai.config.McpContextHolder;
import org.apache.hertzbeat.ai.tools.AlertTools;
import org.apache.hertzbeat.ai.utils.UtilityClass;
import org.apache.hertzbeat.alert.dto.AlertSummary;
import org.apache.hertzbeat.alert.service.AlertService;
import org.apache.hertzbeat.common.entity.alerter.SingleAlert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.ai.tool.annotation.ToolParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class AlertToolsImpl
implements AlertTools {
    private static final Logger log = LoggerFactory.getLogger(AlertToolsImpl.class);
    @Autowired
    private AlertService alertService;

    @Override
    @Tool(name="query_alerts", description="HertzBeat: Query alerts with comprehensive filtering and pagination options.\n\nALERT TYPES:\n- Pass alertType='single' for individual alert instances\n- Pass alertType='group' for grouped/aggregated alerts\n- Pass alertType='both' to get both types (separate sections)\n\nSTATUS FILTERING:\n- 'firing': Currently active alerts requiring attention\n- 'resolved': Previously active alerts that have been cleared\n- 'all': Both firing and resolved alerts (default)\n\nSEARCH & FILTERING:\n- search: Search in alert content, labels, or descriptions\n- sort: Order by 'startAt' (trigger time), 'triggerTimes' (frequency), 'status'\n- order: 'asc' (oldest first) or 'desc' (newest first, default)\n\nPAGINATION:\n- pageIndex: Page number starting from 0\n- pageSize: Number of alerts per page (default: 10, max recommended: 50)\n\nEXAMPLE AND COMMON USE CASES:\n- Recent active alerts: alertType='single', status='firing', sort='startAt', order='desc'\n- Historical analysis: alertType='single', status='resolved', pageSize=50\n- Alert grouping overview: alertType='group', status='all'\n- Search specific issues: search='cpu', alertType='single', status='firing'\n- Find abnormal monitors: status='firing' to get active alerts indicating monitor issues\n- Monitor-specific alerts: use search parameter with monitor ID or name to find related alerts\n- Frequent alerts analysis: sort='triggerTimes', order='desc' to find most frequently triggered alerts\n- Recent recurring issues: status='all', sort='triggerTimes', order='desc', pageSize=20\n")
    public String queryAlerts(@ToolParam(description="Alert type: 'single' (individual alerts), 'group' (grouped alerts), 'both' (default: single)", required=false) String alertType, @ToolParam(description="Alert status: 'firing' (active), 'resolved' (cleared), 'all' (default: all)", required=false) String status, @ToolParam(description="Search term for alert content or labels", required=false) String search, @ToolParam(description="Sort field: 'startAt', 'triggerTimes', 'status' (default: startAt)", required=false) String sort, @ToolParam(description="Sort order: 'asc' or 'desc' (default: desc)", required=false) String order, @ToolParam(description="Page index starting from 0 (default: 0)", required=false) Integer pageIndex, @ToolParam(description="Page size, 1-50 recommended (default: 10)", required=false) Integer pageSize) {
        try {
            log.info("Querying alerts: alertType={}, status={}, search={}, sort={}, order={}", new Object[]{alertType, status, search, sort, order});
            SubjectSum subjectSum = McpContextHolder.getSubject();
            log.debug("Current subject in query_alerts tool: {}", (Object)subjectSum);
            if (alertType == null || alertType.trim().isEmpty()) {
                alertType = "single";
            }
            if (status == null || status.trim().isEmpty()) {
                status = "all";
            }
            if (sort == null || sort.trim().isEmpty()) {
                sort = "startAt";
            }
            if (order == null || order.trim().isEmpty()) {
                order = "desc";
            }
            if (pageIndex == null) {
                pageIndex = 0;
            }
            if (pageSize == null) {
                pageSize = 10;
            }
            StringBuilder response = new StringBuilder();
            response.append("ALERT QUERY RESULTS\n");
            response.append("===================\n\n");
            if ("single".equalsIgnoreCase(alertType) || "both".equalsIgnoreCase(alertType)) {
                Page singleResult = this.alertService.getSingleAlerts(status, search, sort, order, pageIndex.intValue(), pageSize.intValue());
                response.append("SINGLE ALERTS:\n");
                response.append("Found ").append(singleResult.getContent().size()).append(" single alerts (Total: ").append(singleResult.getTotalElements()).append("):\n\n");
                for (SingleAlert alert : singleResult.getContent()) {
                    response.append("Alert ID: ").append(alert.getId()).append("\n");
                    response.append("Status: ").append(alert.getStatus()).append("\n");
                    response.append("Content: ").append(alert.getContent() != null ? alert.getContent() : "No content").append("\n");
                    response.append("Trigger Times: ").append(alert.getTriggerTimes()).append("\n");
                    if (alert.getStartAt() != null) {
                        response.append("Started At: ").append(UtilityClass.formatTimestamp(alert.getStartAt())).append("\n");
                    }
                    if (alert.getActiveAt() != null) {
                        response.append("Active At: ").append(UtilityClass.formatTimestamp(alert.getActiveAt())).append("\n");
                    }
                    if (alert.getEndAt() != null) {
                        response.append("Ended At: ").append(UtilityClass.formatTimestamp(alert.getEndAt())).append("\n");
                    }
                    if (alert.getLabels() != null && !alert.getLabels().isEmpty()) {
                        response.append("Labels: ").append(alert.getLabels()).append("\n");
                    }
                    response.append("\n");
                }
                if (singleResult.getContent().isEmpty()) {
                    response.append("No single alerts found matching the specified criteria.\n");
                }
            }
            if ("group".equalsIgnoreCase(alertType) || "both".equalsIgnoreCase(alertType)) {
                if ("both".equalsIgnoreCase(alertType)) {
                    response.append("\n");
                }
                Page groupResult = this.alertService.getGroupAlerts(status, search, sort, order, pageIndex.intValue(), pageSize.intValue());
                response.append("GROUP ALERTS:\n");
                response.append("Found ").append(groupResult.getContent().size()).append(" group alerts (Total: ").append(groupResult.getTotalElements()).append("):\n\n");
                for (SingleAlert alert : groupResult.getContent()) {
                    response.append("Group Alert ID: ").append(alert.getId()).append("\n");
                    response.append("Status: ").append(alert.getStatus()).append("\n");
                    response.append("Group Key: ").append(alert.getGroupKey() != null ? alert.getGroupKey() : "No group key").append("\n");
                    if (alert.getGmtCreate() != null) {
                        response.append("Created At: ").append(alert.getGmtCreate()).append("\n");
                    }
                    if (alert.getGmtUpdate() != null) {
                        response.append("Updated At: ").append(alert.getGmtUpdate()).append("\n");
                    }
                    if (alert.getCommonLabels() != null && !alert.getCommonLabels().isEmpty()) {
                        response.append("Common Labels: ").append(alert.getCommonLabels()).append("\n");
                    }
                    if (alert.getCommonAnnotations() != null && !alert.getCommonAnnotations().isEmpty()) {
                        response.append("Annotations: ").append(alert.getCommonAnnotations()).append("\n");
                    }
                    response.append("\n");
                }
                if (groupResult.getContent().isEmpty()) {
                    response.append("No group alerts found matching the specified criteria.\n");
                }
            }
            return response.toString();
        }
        catch (Exception e) {
            log.error("Failed to query alerts: {}", (Object)e.getMessage(), (Object)e);
            return "Error retrieving alerts: " + e.getMessage();
        }
    }

    @Override
    @Tool(name="get_alerts_summary", description="HertzBeat: Get alerts summary statistics including total counts, status distribution, and recent trends.\nReturns comprehensive overview of the current alerting status across all monitors.\n")
    public String getAlertsSummary() {
        try {
            log.info("Getting alerts summary");
            SubjectSum subjectSum = McpContextHolder.getSubject();
            log.debug("Current subject in get_alerts_summary tool: {}", (Object)subjectSum);
            AlertSummary summary = this.alertService.getAlertsSummary();
            StringBuilder response = new StringBuilder();
            response.append("ALERTS SUMMARY\n");
            response.append("==============\n\n");
            if (summary != null) {
                response.append("Total Alerts: ").append(summary.getTotal()).append("\n");
                response.append("Handled Alerts: ").append(summary.getDealNum()).append("\n");
                response.append("Handling Rate: ").append(String.format("%.1f", Float.valueOf(summary.getRate()))).append("%\n\n");
                response.append("Priority Breakdown (Unhandled):\n");
                response.append("- Critical: ").append(summary.getPriorityCriticalNum()).append("\n");
                response.append("- Emergency: ").append(summary.getPriorityEmergencyNum()).append("\n");
                response.append("- Warning: ").append(summary.getPriorityWarningNum()).append("\n\n");
                long totalUnhandled = summary.getPriorityCriticalNum() + summary.getPriorityEmergencyNum() + summary.getPriorityWarningNum();
                response.append("Total Unhandled Alerts: ").append(totalUnhandled).append("\n");
                if (totalUnhandled > 0L) {
                    response.append("\nUnhandled Alert Distribution:\n");
                    response.append("- Critical: ").append(String.format("%.1f", (double)summary.getPriorityCriticalNum() * 100.0 / (double)totalUnhandled)).append("%\n");
                    response.append("- Emergency: ").append(String.format("%.1f", (double)summary.getPriorityEmergencyNum() * 100.0 / (double)totalUnhandled)).append("%\n");
                    response.append("- Warning: ").append(String.format("%.1f", (double)summary.getPriorityWarningNum() * 100.0 / (double)totalUnhandled)).append("%\n");
                }
            } else {
                response.append("No alert summary data available.");
            }
            return response.toString();
        }
        catch (Exception e) {
            log.error("Failed to get alerts summary: {}", (Object)e.getMessage(), (Object)e);
            return "Error retrieving alerts summary: " + e.getMessage();
        }
    }
}

