/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.stream.cardinality;

import com.clearspring.analytics.hash.MurmurHash;
import com.clearspring.analytics.stream.cardinality.CardinalityMergeException;
import com.clearspring.analytics.stream.cardinality.ICardinality;
import com.clearspring.analytics.util.IBuilder;
import java.util.Arrays;

public class LogLog
implements ICardinality {
    protected static final double[] mAlpha = new double[]{0.0, 0.44567926005415, 1.2480639342271, 2.8391255240079, 6.0165231584811, 12.369319965552, 25.073991603109, 50.482891762521, 101.30047482549, 202.93553337953, 406.20559693552, 812.74569741657, 1625.8258887309, 3251.9862249084, 6504.307147186, 13008.949929672, 26018.222470181, 52036.68413528, 104073.41696276, 208139.24771523, 416265.57100022, 832478.53851627, 1669443.2499579, 3356902.8702907, 6863377.8429508, 1.1978069823687E7, 3.1333767455026E7, 5.2114301457757E7, 7.2080129928986E7, 6.8945006880409E7, 3.1538957552704E7, 3299942.4347441};
    protected final int k;
    protected int m;
    protected double Ca;
    protected byte[] M;
    protected int Rsum = 0;

    public LogLog(int k) {
        if (k >= mAlpha.length - 1) {
            throw new IllegalArgumentException(String.format("Max k (%d) exceeded: k=%d", mAlpha.length - 1, k));
        }
        this.k = k;
        this.m = 1 << k;
        this.Ca = mAlpha[k];
        this.M = new byte[this.m];
    }

    public LogLog(byte[] M) {
        this.M = M;
        this.m = M.length;
        this.k = Integer.numberOfTrailingZeros(this.m);
        assert (this.m == 1 << this.k) : "Invalid array size: M.length must be a power of 2";
        this.Ca = mAlpha[this.k];
        for (byte b : M) {
            this.Rsum += b;
        }
    }

    @Override
    public byte[] getBytes() {
        return this.M;
    }

    @Override
    public int sizeof() {
        return this.m;
    }

    @Override
    public long cardinality() {
        double Ravg = (double)this.Rsum / (double)this.m;
        return (long)(this.Ca * Math.pow(2.0, Ravg));
    }

    @Override
    public boolean offerHashed(long hashedLong) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offerHashed(int hashedInt) {
        boolean modified = false;
        int j = hashedInt >>> 32 - this.k;
        byte r = (byte)(Integer.numberOfLeadingZeros(hashedInt << this.k | 1 << this.k - 1) + 1);
        if (this.M[j] < r) {
            this.Rsum += r - this.M[j];
            this.M[j] = r;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean offer(Object o) {
        int x = MurmurHash.hash(o);
        return this.offerHashed(x);
    }

    protected static int rho(int x, int k) {
        return Integer.numberOfLeadingZeros(x << k | 1 << k - 1) + 1;
    }

    @Override
    public ICardinality merge(ICardinality ... estimators) throws LogLogMergeException {
        if (estimators == null) {
            return new LogLog(this.M);
        }
        byte[] mergedBytes = Arrays.copyOf(this.M, this.M.length);
        for (ICardinality estimator : estimators) {
            if (!this.getClass().isInstance(estimator)) {
                throw new LogLogMergeException("Cannot merge estimators of different class");
            }
            if (estimator.sizeof() != this.sizeof()) {
                throw new LogLogMergeException("Cannot merge estimators of different sizes");
            }
            LogLog ll = (LogLog)estimator;
            for (int i = 0; i < mergedBytes.length; ++i) {
                mergedBytes[i] = (byte)Math.max(mergedBytes[i], ll.M[i]);
            }
        }
        return new LogLog(mergedBytes);
    }

    public static LogLog mergeEstimators(LogLog ... estimators) throws LogLogMergeException {
        if (estimators == null || estimators.length == 0) {
            return null;
        }
        return (LogLog)estimators[0].merge(Arrays.copyOfRange(estimators, 1, estimators.length));
    }

    public static class Builder
    implements IBuilder<ICardinality> {
        protected final int k;

        public Builder() {
            this(16);
        }

        public Builder(int k) {
            this.k = k;
        }

        @Override
        public LogLog build() {
            return new LogLog(this.k);
        }

        @Override
        public int sizeof() {
            return 1 << this.k;
        }
    }

    protected static class LogLogMergeException
    extends CardinalityMergeException {
        public LogLogMergeException(String message) {
            super(message);
        }
    }
}

