/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.transport;

import com.trilead.ssh2.ConnectionInfo;
import com.trilead.ssh2.DHGexParameters;
import com.trilead.ssh2.ExtendedServerHostKeyVerifier;
import com.trilead.ssh2.ServerHostKeyVerifier;
import com.trilead.ssh2.compression.CompressionFactory;
import com.trilead.ssh2.compression.ICompressor;
import com.trilead.ssh2.crypto.CryptoWishList;
import com.trilead.ssh2.crypto.KeyMaterial;
import com.trilead.ssh2.crypto.cipher.BlockCipher;
import com.trilead.ssh2.crypto.cipher.BlockCipherFactory;
import com.trilead.ssh2.crypto.dh.DhGroupExchange;
import com.trilead.ssh2.crypto.dh.GenericDhExchange;
import com.trilead.ssh2.crypto.digest.HMAC;
import com.trilead.ssh2.crypto.digest.MACs;
import com.trilead.ssh2.log.Logger;
import com.trilead.ssh2.packets.PacketKexDHInit;
import com.trilead.ssh2.packets.PacketKexDHReply;
import com.trilead.ssh2.packets.PacketKexDhGexGroup;
import com.trilead.ssh2.packets.PacketKexDhGexInit;
import com.trilead.ssh2.packets.PacketKexDhGexReply;
import com.trilead.ssh2.packets.PacketKexDhGexRequest;
import com.trilead.ssh2.packets.PacketKexDhGexRequestOld;
import com.trilead.ssh2.packets.PacketKexInit;
import com.trilead.ssh2.packets.PacketNewKeys;
import com.trilead.ssh2.signature.DSASHA1Verify;
import com.trilead.ssh2.signature.ECDSASHA2Verify;
import com.trilead.ssh2.signature.Ed25519Verify;
import com.trilead.ssh2.signature.RSASHA1Verify;
import com.trilead.ssh2.signature.RSASHA256Verify;
import com.trilead.ssh2.signature.RSASHA512Verify;
import com.trilead.ssh2.signature.SSHSignature;
import com.trilead.ssh2.transport.ClientServerHello;
import com.trilead.ssh2.transport.KexParameters;
import com.trilead.ssh2.transport.KexState;
import com.trilead.ssh2.transport.NegotiateException;
import com.trilead.ssh2.transport.NegotiatedParameters;
import com.trilead.ssh2.transport.TransportManager;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class KexManager {
    private static final Logger log;
    private static final boolean supportsEc;
    private static final Set<String> HOSTKEY_ALGS;
    private static final Set<String> KEX_ALGS;
    private static final String EXT_INFO_C = "ext-info-c";
    private static final String KEX_STRICT_C_OPENSSH = "kex-strict-c-v00@openssh.com";
    private static final String KEX_STRICT_S_OPENSSH = "kex-strict-s-v00@openssh.com";
    private KexState kxs;
    private int kexCount = 0;
    private KeyMaterial km;
    byte[] sessionId;
    private ClientServerHello csh;
    private final Object accessLock = new Object();
    private ConnectionInfo lastConnInfo = null;
    private boolean connectionClosed = false;
    private boolean ignore_next_kex_packet = false;
    private final TransportManager tm;
    private CryptoWishList nextKEXcryptoWishList;
    private DHGexParameters nextKEXdhgexParameters;
    private ServerHostKeyVerifier verifier;
    private final String hostname;
    private final int port;
    private final SecureRandom rnd;

    public KexManager(TransportManager tm, ClientServerHello csh, CryptoWishList initialCwl, String hostname, int port, ServerHostKeyVerifier keyVerifier, SecureRandom rnd) {
        this.tm = tm;
        this.csh = csh;
        this.nextKEXcryptoWishList = initialCwl;
        this.nextKEXdhgexParameters = new DHGexParameters();
        this.hostname = hostname;
        this.port = port;
        this.verifier = keyVerifier;
        this.rnd = rnd;
    }

    public ConnectionInfo getOrWaitForConnectionInfo(int minKexCount) throws IOException {
        Object object = this.accessLock;
        synchronized (object) {
            while (true) {
                if (this.lastConnInfo != null && this.lastConnInfo.keyExchangeCounter >= minKexCount) {
                    return this.lastConnInfo;
                }
                if (this.connectionClosed) {
                    throw new IOException("Key exchange was not finished, connection is closed.", this.tm.getReasonClosedCause());
                }
                try {
                    this.accessLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private String getFirstMatch(String[] client, String[] server) throws NegotiateException {
        if (client == null || server == null) {
            throw new IllegalArgumentException();
        }
        if (client.length == 0) {
            return null;
        }
        for (String aClient : client) {
            for (String aServer : server) {
                if (!aClient.equals(aServer)) continue;
                return aClient;
            }
        }
        throw new NegotiateException();
    }

    private boolean compareFirstOfNameList(String[] a, String[] b) {
        if (a == null || b == null) {
            throw new IllegalArgumentException();
        }
        if (a.length == 0 && b.length == 0) {
            return true;
        }
        if (a.length == 0 || b.length == 0) {
            return false;
        }
        return a[0].equals(b[0]);
    }

    private boolean containsAlgo(String[] algos, String targetAlgo) {
        if (algos == null || targetAlgo == null) {
            return false;
        }
        for (String algo : algos) {
            if (!targetAlgo.equals(algo)) continue;
            return true;
        }
        return false;
    }

    private boolean isGuessOK(KexParameters cpar, KexParameters spar) {
        if (cpar == null || spar == null) {
            throw new IllegalArgumentException();
        }
        if (!this.compareFirstOfNameList(cpar.kex_algorithms, spar.kex_algorithms)) {
            return false;
        }
        return this.compareFirstOfNameList(cpar.server_host_key_algorithms, spar.server_host_key_algorithms);
    }

    private NegotiatedParameters mergeKexParameters(KexParameters client, KexParameters server) {
        NegotiatedParameters np = new NegotiatedParameters();
        try {
            np.kex_algo = this.getFirstMatch(client.kex_algorithms, server.kex_algorithms);
            np.isStrictKex = this.containsAlgo(server.kex_algorithms, KEX_STRICT_S_OPENSSH);
            log.log(20, "kex_algo=" + np.kex_algo);
            np.server_host_key_algo = this.getFirstMatch(client.server_host_key_algorithms, server.server_host_key_algorithms);
            log.log(20, "server_host_key_algo=" + np.server_host_key_algo);
            np.enc_algo_client_to_server = this.getFirstMatch(client.encryption_algorithms_client_to_server, server.encryption_algorithms_client_to_server);
            np.enc_algo_server_to_client = this.getFirstMatch(client.encryption_algorithms_server_to_client, server.encryption_algorithms_server_to_client);
            log.log(20, "enc_algo_client_to_server=" + np.enc_algo_client_to_server);
            log.log(20, "enc_algo_server_to_client=" + np.enc_algo_server_to_client);
            np.mac_algo_client_to_server = this.getFirstMatch(client.mac_algorithms_client_to_server, server.mac_algorithms_client_to_server);
            np.mac_algo_server_to_client = this.getFirstMatch(client.mac_algorithms_server_to_client, server.mac_algorithms_server_to_client);
            log.log(20, "mac_algo_client_to_server=" + np.mac_algo_client_to_server);
            log.log(20, "mac_algo_server_to_client=" + np.mac_algo_server_to_client);
            np.comp_algo_client_to_server = this.getFirstMatch(client.compression_algorithms_client_to_server, server.compression_algorithms_client_to_server);
            np.comp_algo_server_to_client = this.getFirstMatch(client.compression_algorithms_server_to_client, server.compression_algorithms_server_to_client);
            log.log(20, "comp_algo_client_to_server=" + np.comp_algo_client_to_server);
            log.log(20, "comp_algo_server_to_client=" + np.comp_algo_server_to_client);
        }
        catch (NegotiateException e) {
            return null;
        }
        try {
            np.lang_client_to_server = this.getFirstMatch(client.languages_client_to_server, server.languages_client_to_server);
        }
        catch (NegotiateException e1) {
            np.lang_client_to_server = null;
        }
        try {
            np.lang_server_to_client = this.getFirstMatch(client.languages_server_to_client, server.languages_server_to_client);
        }
        catch (NegotiateException e2) {
            np.lang_server_to_client = null;
        }
        if (this.isGuessOK(client, server)) {
            np.guessOK = true;
        }
        return np;
    }

    public synchronized void initiateKEX(CryptoWishList cwl, DHGexParameters dhgex) throws IOException {
        this.nextKEXcryptoWishList = cwl.clone();
        this.filterHostKeyTypes(this.nextKEXcryptoWishList);
        KexManager.addExtraKexAlgorithms(this.nextKEXcryptoWishList);
        this.nextKEXdhgexParameters = dhgex;
        if (this.kxs == null) {
            PacketKexInit kp;
            this.kxs = new KexState();
            this.kxs.dhgexParameters = this.nextKEXdhgexParameters;
            this.kxs.localKEX = kp = new PacketKexInit(this.nextKEXcryptoWishList);
            this.tm.sendKexMessage(kp.getPayload());
        }
    }

    private static void addExtraKexAlgorithms(CryptoWishList cwl) {
        String[] oldKexAlgorithms = cwl.kexAlgorithms;
        ArrayList<String> kexAlgorithms = new ArrayList<String>(oldKexAlgorithms.length + 2);
        for (String algo : oldKexAlgorithms) {
            if (algo.equals(EXT_INFO_C) || algo.equals(KEX_STRICT_C_OPENSSH)) continue;
            kexAlgorithms.add(algo);
        }
        kexAlgorithms.add(EXT_INFO_C);
        kexAlgorithms.add(KEX_STRICT_C_OPENSSH);
        cwl.kexAlgorithms = kexAlgorithms.toArray(new String[0]);
    }

    private void filterHostKeyTypes(CryptoWishList cwl) {
        ExtendedServerHostKeyVerifier extendedVerifier;
        List<String> knownAlgorithms;
        if (this.verifier instanceof ExtendedServerHostKeyVerifier && (knownAlgorithms = (extendedVerifier = (ExtendedServerHostKeyVerifier)this.verifier).getKnownKeyAlgorithmsForHost(this.hostname, this.port)) != null && knownAlgorithms.size() > 0) {
            ArrayList<String> filteredAlgorithms = new ArrayList<String>(knownAlgorithms.size());
            for (String capableAlgo : cwl.serverHostKeyAlgorithms) {
                for (String knownAlgo : knownAlgorithms) {
                    if (!capableAlgo.equals(knownAlgo)) continue;
                    filteredAlgorithms.add(knownAlgo);
                }
            }
            if (filteredAlgorithms.size() > 0) {
                cwl.serverHostKeyAlgorithms = filteredAlgorithms.toArray(new String[0]);
            }
        }
    }

    private void establishKeyMaterial() throws IOException {
        try {
            int mac_cs_key_len = MACs.getKeyLen(this.kxs.np.mac_algo_client_to_server);
            int enc_cs_key_len = BlockCipherFactory.getKeySize(this.kxs.np.enc_algo_client_to_server);
            int enc_cs_block_len = BlockCipherFactory.getBlockSize(this.kxs.np.enc_algo_client_to_server);
            int mac_sc_key_len = MACs.getKeyLen(this.kxs.np.mac_algo_server_to_client);
            int enc_sc_key_len = BlockCipherFactory.getKeySize(this.kxs.np.enc_algo_server_to_client);
            int enc_sc_block_len = BlockCipherFactory.getBlockSize(this.kxs.np.enc_algo_server_to_client);
            this.km = KeyMaterial.create(this.kxs.hashAlgo, this.kxs.H, this.kxs.K, this.sessionId, enc_cs_key_len, enc_cs_block_len, mac_cs_key_len, enc_sc_key_len, enc_sc_block_len, mac_sc_key_len);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Could not establish key material: " + e.getMessage());
        }
    }

    private void finishKex() throws IOException {
        ICompressor comp;
        HMAC mac;
        BlockCipher cbc;
        if (this.sessionId == null) {
            this.sessionId = this.kxs.H;
        }
        this.establishKeyMaterial();
        PacketNewKeys ign = new PacketNewKeys();
        this.tm.sendKexMessage(ign.getPayload());
        try {
            cbc = BlockCipherFactory.createCipher(this.kxs.np.enc_algo_client_to_server, true, this.km.enc_key_client_to_server, this.km.initial_iv_client_to_server);
            mac = new HMAC(this.kxs.np.mac_algo_client_to_server, this.km.integrity_key_client_to_server);
            comp = CompressionFactory.createCompressor(this.kxs.np.comp_algo_client_to_server);
        }
        catch (IllegalArgumentException e1) {
            throw new IOException("Fatal error during MAC startup!");
        }
        this.tm.changeSendCipher(cbc, mac);
        this.tm.changeSendCompression(comp);
        this.tm.kexFinished();
    }

    public static String[] getDefaultServerHostkeyAlgorithmList() {
        return HOSTKEY_ALGS.toArray(new String[0]);
    }

    public static void checkServerHostkeyAlgorithmsList(String[] algos) {
        for (String algo : algos) {
            if (HOSTKEY_ALGS.contains(algo)) continue;
            throw new IllegalArgumentException("Unknown server host key algorithm '" + algo + "'");
        }
    }

    public static String[] getDefaultKexAlgorithmList() {
        return KEX_ALGS.toArray(new String[0]);
    }

    public static void checkKexAlgorithmList(String[] algos) {
        for (String algo : algos) {
            if (KEX_ALGS.contains(algo)) continue;
            throw new IllegalArgumentException("Unknown kex algorithm '" + algo + "'");
        }
    }

    private boolean verifySignature(byte[] sig, byte[] hostkey) throws IOException {
        SSHSignature sshSignature;
        if (this.kxs.np.server_host_key_algo.equals(Ed25519Verify.get().getKeyFormat())) {
            sshSignature = Ed25519Verify.get();
        } else if (this.kxs.np.server_host_key_algo.equals(ECDSASHA2Verify.ECDSASHA2NISTP256Verify.get().getKeyFormat())) {
            sshSignature = ECDSASHA2Verify.ECDSASHA2NISTP256Verify.get();
        } else if (this.kxs.np.server_host_key_algo.equals(ECDSASHA2Verify.ECDSASHA2NISTP384Verify.get().getKeyFormat())) {
            sshSignature = ECDSASHA2Verify.ECDSASHA2NISTP384Verify.get();
        } else if (this.kxs.np.server_host_key_algo.equals(ECDSASHA2Verify.ECDSASHA2NISTP521Verify.get().getKeyFormat())) {
            sshSignature = ECDSASHA2Verify.ECDSASHA2NISTP521Verify.get();
        } else if (this.kxs.np.server_host_key_algo.equals(RSASHA512Verify.get().getKeyFormat())) {
            sshSignature = RSASHA512Verify.get();
        } else if (this.kxs.np.server_host_key_algo.equals(RSASHA256Verify.get().getKeyFormat())) {
            sshSignature = RSASHA256Verify.get();
        } else if (this.kxs.np.server_host_key_algo.equals(RSASHA1Verify.get().getKeyFormat())) {
            sshSignature = RSASHA1Verify.get();
        } else if (this.kxs.np.server_host_key_algo.equals(DSASHA1Verify.get().getKeyFormat())) {
            sshSignature = DSASHA1Verify.get();
        } else {
            throw new IOException("Unknown server host key algorithm '" + this.kxs.np.server_host_key_algo + "'");
        }
        PublicKey publicKey = sshSignature.decodePublicKey(hostkey);
        log.log(50, "Verifying " + sshSignature.getKeyFormat() + " signature");
        return sshSignature.verifySignature(this.kxs.H, sig, publicKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void handleMessage(byte[] msg, int msglen) throws IOException {
        if (msg == null) {
            Object object = this.accessLock;
            synchronized (object) {
                this.connectionClosed = true;
                this.accessLock.notifyAll();
                return;
            }
        }
        if (this.kxs == null && msg[0] != 20) {
            throw new IOException("Unexpected KEX message (type " + msg[0] + ")");
        }
        if (this.ignore_next_kex_packet) {
            this.ignore_next_kex_packet = false;
            return;
        }
        if (msg[0] == 20) {
            PacketKexInit kip;
            if (this.kxs != null && this.kxs.state != 0) {
                throw new IOException("Unexpected SSH_MSG_KEXINIT message during on-going kex exchange!");
            }
            if (this.kxs == null) {
                this.kxs = new KexState();
                this.kxs.dhgexParameters = this.nextKEXdhgexParameters;
                this.kxs.localKEX = kip = new PacketKexInit(this.nextKEXcryptoWishList);
                this.tm.sendKexMessage(kip.getPayload());
            }
            this.kxs.remoteKEX = kip = new PacketKexInit(msg, 0, msglen);
            this.kxs.np = this.mergeKexParameters(this.kxs.localKEX.getKexParameters(), this.kxs.remoteKEX.getKexParameters());
            if (this.kxs.np == null) {
                throw new IOException("Cannot negotiate, proposals do not match.");
            }
            if (this.kxs.remoteKEX.isFirst_kex_packet_follows() && !this.kxs.np.guessOK) {
                this.ignore_next_kex_packet = true;
            }
            if (this.kxs.np.kex_algo.equals("diffie-hellman-group-exchange-sha1") || this.kxs.np.kex_algo.equals("diffie-hellman-group-exchange-sha256")) {
                if (this.kxs.dhgexParameters.getMin_group_len() == 0 || this.csh.server_versioncomment.matches("OpenSSH_2\\.([0-4]\\.|5\\.[0-2]).*")) {
                    PacketKexDhGexRequestOld dhgexreq = new PacketKexDhGexRequestOld(this.kxs.dhgexParameters);
                    this.tm.sendKexMessage(dhgexreq.getPayload());
                } else {
                    PacketKexDhGexRequest dhgexreq = new PacketKexDhGexRequest(this.kxs.dhgexParameters);
                    this.tm.sendKexMessage(dhgexreq.getPayload());
                }
                this.kxs.hashAlgo = this.kxs.np.kex_algo.endsWith("sha1") ? "SHA1" : "SHA-256";
                this.kxs.state = 1;
                return;
            }
            if (this.kxs.np.kex_algo.equals("curve25519-sha256") || this.kxs.np.kex_algo.equals("curve25519-sha256@libssh.org") || this.kxs.np.kex_algo.equals("ecdh-sha2-nistp521") || this.kxs.np.kex_algo.equals("ecdh-sha2-nistp384") || this.kxs.np.kex_algo.equals("ecdh-sha2-nistp256") || this.kxs.np.kex_algo.equals("diffie-hellman-group18-sha512") || this.kxs.np.kex_algo.equals("diffie-hellman-group16-sha512") || this.kxs.np.kex_algo.equals("diffie-hellman-group14-sha256") || this.kxs.np.kex_algo.equals("diffie-hellman-group14-sha1") || this.kxs.np.kex_algo.equals("diffie-hellman-group1-sha1")) {
                this.kxs.dhx = GenericDhExchange.getInstance(this.kxs.np.kex_algo);
                this.kxs.dhx.init(this.kxs.np.kex_algo);
                this.kxs.hashAlgo = this.kxs.dhx.getHashAlgo();
                PacketKexDHInit kp = new PacketKexDHInit(this.kxs.dhx.getE());
                this.tm.sendKexMessage(kp.getPayload());
                this.kxs.state = 1;
                return;
            }
            throw new IllegalStateException("Unknown KEX method!");
        }
        if (msg[0] == 21) {
            ICompressor comp;
            HMAC mac;
            BlockCipher cbc;
            if (this.km == null) {
                throw new IOException("Peer sent SSH_MSG_NEWKEYS, but I have no key material ready!");
            }
            try {
                cbc = BlockCipherFactory.createCipher(this.kxs.np.enc_algo_server_to_client, false, this.km.enc_key_server_to_client, this.km.initial_iv_server_to_client);
                mac = new HMAC(this.kxs.np.mac_algo_server_to_client, this.km.integrity_key_server_to_client);
                comp = CompressionFactory.createCompressor(this.kxs.np.comp_algo_server_to_client);
            }
            catch (IllegalArgumentException e1) {
                throw new IOException("Fatal error during MAC startup: " + e1.getMessage());
            }
            this.tm.changeRecvCipher(cbc, mac);
            this.tm.changeRecvCompression(comp);
            ConnectionInfo sci = new ConnectionInfo();
            ++this.kexCount;
            sci.keyExchangeAlgorithm = this.kxs.np.kex_algo;
            sci.keyExchangeCounter = this.kexCount;
            sci.clientToServerCryptoAlgorithm = this.kxs.np.enc_algo_client_to_server;
            sci.serverToClientCryptoAlgorithm = this.kxs.np.enc_algo_server_to_client;
            sci.clientToServerMACAlgorithm = this.kxs.np.mac_algo_client_to_server;
            sci.serverToClientMACAlgorithm = this.kxs.np.mac_algo_server_to_client;
            sci.serverHostKeyAlgorithm = this.kxs.np.server_host_key_algo;
            sci.serverHostKey = this.kxs.hostkey;
            sci.clientToServerCompressionAlgorithm = this.kxs.np.comp_algo_client_to_server;
            sci.serverToClientCompressionAlgorithm = this.kxs.np.comp_algo_server_to_client;
            Object object = this.accessLock;
            synchronized (object) {
                this.lastConnInfo = sci;
                this.accessLock.notifyAll();
            }
            this.kxs = null;
            return;
        }
        if (this.kxs == null || this.kxs.state == 0) {
            throw new IOException("Unexpected Kex submessage!");
        }
        if (this.kxs.np.kex_algo.equals("diffie-hellman-group-exchange-sha1") || this.kxs.np.kex_algo.equals("diffie-hellman-group-exchange-sha256")) {
            if (this.kxs.state == 1) {
                PacketKexDhGexGroup dhgexgrp = new PacketKexDhGexGroup(msg, 0, msglen);
                this.kxs.dhgx = new DhGroupExchange(dhgexgrp.getP(), dhgexgrp.getG());
                this.kxs.dhgx.init(this.rnd);
                PacketKexDhGexInit dhgexinit = new PacketKexDhGexInit(this.kxs.dhgx.getE());
                this.tm.sendKexMessage(dhgexinit.getPayload());
                this.kxs.state = 2;
                return;
            }
            if (this.kxs.state == 2) {
                PacketKexDhGexReply dhgexrpl = new PacketKexDhGexReply(msg, 0, msglen);
                this.kxs.hostkey = dhgexrpl.getHostKey();
                if (this.verifier != null) {
                    boolean vres = false;
                    try {
                        vres = this.verifier.verifyServerHostKey(this.hostname, this.port, this.kxs.np.server_host_key_algo, this.kxs.hostkey);
                    }
                    catch (Exception e) {
                        throw new IOException("The server hostkey was not accepted by the verifier callback.", e);
                    }
                    if (!vres) {
                        throw new IOException("The server hostkey was not accepted by the verifier callback");
                    }
                }
                this.kxs.dhgx.setF(dhgexrpl.getF());
                try {
                    this.kxs.H = this.kxs.dhgx.calculateH(this.kxs.hashAlgo, this.csh.getClientString(), this.csh.getServerString(), this.kxs.localKEX.getPayload(), this.kxs.remoteKEX.getPayload(), dhgexrpl.getHostKey(), this.kxs.dhgexParameters);
                }
                catch (IllegalArgumentException e) {
                    throw new IOException("KEX error.", e);
                }
                boolean res = this.verifySignature(dhgexrpl.getSignature(), this.kxs.hostkey);
                if (!res) {
                    throw new IOException("Hostkey signature sent by remote is wrong!");
                }
                this.kxs.K = this.kxs.dhgx.getK();
                this.finishKex();
                this.kxs.state = -1;
                return;
            }
            throw new IllegalStateException("Illegal State in KEX Exchange!");
        }
        if ((this.kxs.np.kex_algo.equals("diffie-hellman-group1-sha1") || this.kxs.np.kex_algo.equals("diffie-hellman-group14-sha1") || this.kxs.np.kex_algo.equals("diffie-hellman-group14-sha256") || this.kxs.np.kex_algo.equals("diffie-hellman-group16-sha512") || this.kxs.np.kex_algo.equals("diffie-hellman-group18-sha512") || this.kxs.np.kex_algo.equals("ecdh-sha2-nistp256") || this.kxs.np.kex_algo.equals("ecdh-sha2-nistp384") || this.kxs.np.kex_algo.equals("ecdh-sha2-nistp521") || this.kxs.np.kex_algo.equals("curve25519-sha256") || this.kxs.np.kex_algo.equals("curve25519-sha256@libssh.org")) && this.kxs.state == 1) {
            PacketKexDHReply dhr = new PacketKexDHReply(msg, 0, msglen);
            this.kxs.hostkey = dhr.getHostKey();
            if (this.verifier != null) {
                boolean vres = false;
                try {
                    vres = this.verifier.verifyServerHostKey(this.hostname, this.port, this.kxs.np.server_host_key_algo, this.kxs.hostkey);
                }
                catch (Exception e) {
                    throw new IOException("The server hostkey was not accepted by the verifier callback.", e);
                }
                if (!vres) {
                    throw new IOException("The server hostkey was not accepted by the verifier callback");
                }
            }
            this.kxs.dhx.setF(dhr.getF());
            try {
                this.kxs.H = this.kxs.dhx.calculateH(this.csh.getClientString(), this.csh.getServerString(), this.kxs.localKEX.getPayload(), this.kxs.remoteKEX.getPayload(), dhr.getHostKey());
            }
            catch (IllegalArgumentException e) {
                throw new IOException("KEX error.", e);
            }
            boolean res = this.verifySignature(dhr.getSignature(), this.kxs.hostkey);
            if (!res) {
                throw new IOException("Hostkey signature sent by remote is wrong!");
            }
            this.kxs.K = this.kxs.dhx.getK();
            this.finishKex();
            this.kxs.state = -1;
            return;
        }
        throw new IllegalStateException("Unkown KEX method! (" + this.kxs.np.kex_algo + ")");
    }

    public boolean isStrictKex() {
        return this.kxs.np.isStrictKex;
    }

    static {
        KeyFactory keyFact;
        log = Logger.getLogger(KexManager.class);
        try {
            keyFact = KeyFactory.getInstance("EC");
        }
        catch (NoSuchAlgorithmException ignored) {
            keyFact = null;
            log.log(10, "Disabling EC support due to lack of KeyFactory");
        }
        supportsEc = keyFact != null;
        HOSTKEY_ALGS = new LinkedHashSet<String>();
        HOSTKEY_ALGS.add("ssh-ed25519");
        if (supportsEc) {
            HOSTKEY_ALGS.add("ecdsa-sha2-nistp256");
            HOSTKEY_ALGS.add("ecdsa-sha2-nistp384");
            HOSTKEY_ALGS.add("ecdsa-sha2-nistp521");
        }
        HOSTKEY_ALGS.add("rsa-sha2-512");
        HOSTKEY_ALGS.add("rsa-sha2-256");
        HOSTKEY_ALGS.add("ssh-rsa");
        HOSTKEY_ALGS.add("ssh-dss");
        KEX_ALGS = new LinkedHashSet<String>();
        KEX_ALGS.add("curve25519-sha256");
        KEX_ALGS.add("curve25519-sha256@libssh.org");
        if (supportsEc) {
            KEX_ALGS.add("ecdh-sha2-nistp256");
            KEX_ALGS.add("ecdh-sha2-nistp384");
            KEX_ALGS.add("ecdh-sha2-nistp521");
        }
        KEX_ALGS.add("diffie-hellman-group18-sha512");
        KEX_ALGS.add("diffie-hellman-group16-sha512");
        KEX_ALGS.add("diffie-hellman-group-exchange-sha256");
        KEX_ALGS.add("diffie-hellman-group14-sha256");
        KEX_ALGS.add("diffie-hellman-group-exchange-sha1");
        KEX_ALGS.add("diffie-hellman-group14-sha1");
        KEX_ALGS.add("diffie-hellman-group1-sha1");
    }
}

