/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing.xp;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.testing.PipelineUnitTest;
import org.apache.hop.testing.gui.TestingGuiPlugin;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;

@ExtensionPoint(id="AutoOpenTestExtensionPoint", extensionPointId="PipelineAfterOpen", description="Open the pipeline unit test along with the pipeline. Pick the one marked for auto opening.")
public class AutoOpenTestExtensionPoint
implements IExtensionPoint<PipelineMeta> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, PipelineMeta pipelineMeta) throws HopException {
        HopGui hopGui = HopGui.getInstance();
        TestingGuiPlugin helper = TestingGuiPlugin.getInstance();
        HopGuiPipelineGraph activePipelineGraph = HopGui.getActivePipelineGraph();
        if (activePipelineGraph == null) {
            return;
        }
        List<PipelineUnitTest> tests = TestingGuiPlugin.findPipelineUnitTest(variables, pipelineMeta, (IHopMetadataProvider)hopGui.getMetadataProvider());
        ArrayList openTests = new ArrayList();
        tests.forEach(test -> {
            if (test.isAutoOpening()) {
                openTests.add(test);
            }
        });
        if (openTests.isEmpty()) {
            return;
        }
        if (!openTests.isEmpty()) {
            PipelineUnitTest test2 = (PipelineUnitTest)openTests.get(0);
            TestingGuiPlugin.selectUnitTest(pipelineMeta, test2);
            return;
        }
    }
}

