/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class SparkStringUtils$
implements Logging {
    public static SparkStringUtils$ MODULE$;
    private final AtomicBoolean truncationWarningPrinted;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparkStringUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private AtomicBoolean truncationWarningPrinted() {
        return this.truncationWarningPrinted;
    }

    public <T> String truncatedString(Seq<T> seq, String start, String sep, String end, int maxFields) {
        if (seq.length() > maxFields) {
            if (this.truncationWarningPrinted().compareAndSet(false, true)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(147).append("Truncated the string representation of a plan since it was too large. This ").append("behavior can be adjusted by setting 'spark.sql.debug.maxToStringFields'.").toString());
            }
            int numFields = package$.MODULE$.max(0, maxFields - 1);
            return ((TraversableOnce)seq.take(numFields)).mkString(start, sep, new StringBuilder(16).append(sep).append("... ").append(seq.length() - numFields).append(" more fields").append(end).toString());
        }
        return seq.mkString(start, sep, end);
    }

    public <T> String truncatedString(Seq<T> seq, String sep, int maxFields) {
        return this.truncatedString(seq, "", sep, "", maxFields);
    }

    public String getHexString(byte[] bytes) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).map((Function1 & Serializable & scala.Serializable)x$1 -> SparkStringUtils$.$anonfun$getHexString$1(BoxesRunTime.unboxToByte((Object)x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("[", " ", "]");
    }

    public Seq<String> sideBySide(String left, String right) {
        return this.sideBySide((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])left.split("\n")), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])right.split("\n")));
    }

    public Seq<String> sideBySide(Seq<String> left, Seq<String> right) {
        int maxLeftSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)left.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.length()), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        Seq leftPadded = (Seq)left.$plus$plus((GenTraversableOnce)Seq$.MODULE$.fill(package$.MODULE$.max(right.size() - left.size(), 0), (Function0 & Serializable & scala.Serializable)() -> ""), Seq$.MODULE$.canBuildFrom());
        Seq rightPadded = (Seq)right.$plus$plus((GenTraversableOnce)Seq$.MODULE$.fill(package$.MODULE$.max(left.size() - right.size(), 0), (Function0 & Serializable & scala.Serializable)() -> ""), Seq$.MODULE$.canBuildFrom());
        return (Seq)((TraversableLike)leftPadded.zip((GenIterable)rightPadded, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String l = (String)tuple2._1();
                String r = (String)tuple2._2();
                String string = l;
                String string2 = r;
                return new StringBuilder(0).append(!(string != null ? !string.equals(string2) : string2 != null) ? " " : "!").append(l).append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(maxLeftSize - l.length() + 3)).append(r).toString();
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ String $anonfun$getHexString$1(byte x$1) {
        return new StringOps(Predef$.MODULE$.augmentString("%02X")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)x$1)}));
    }

    private SparkStringUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.truncationWarningPrinted = new AtomicBoolean(false);
    }
}

