/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.api.core.ObsoleteApi;
import com.google.cloud.bigquery.storage.util.TimeConversionUtils;
import com.google.common.base.Preconditions;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import org.threeten.bp.LocalTime;

public final class CivilTimeEncoder {
    private static final int NANO_LENGTH = 30;
    private static final int MICRO_LENGTH = 20;
    private static final int NANO_SHIFT = 0;
    private static final int MICRO_SHIFT = 0;
    private static final int SECOND_SHIFT = 0;
    private static final int MINUTE_SHIFT = 6;
    private static final int HOUR_SHIFT = 12;
    private static final int DAY_SHIFT = 17;
    private static final int MONTH_SHIFT = 22;
    private static final int YEAR_SHIFT = 26;
    private static final long NANO_MASK = 0x3FFFFFFFL;
    private static final long MICRO_MASK = 1048575L;
    private static final long SECOND_MASK = 63L;
    private static final long MINUTE_MASK = 4032L;
    private static final long HOUR_MASK = 126976L;
    private static final long DAY_MASK = 0x3E0000L;
    private static final long MONTH_MASK = 0x3C00000L;
    private static final long YEAR_MASK = 0xFFFC000000L;
    private static final long TIME_SECONDS_MASK = 131071L;
    private static final long TIME_MICROS_MASK = 0x1FFFFFFFFFL;
    private static final long TIME_NANOS_MASK = 0x7FFFFFFFFFFFL;
    private static final long DATETIME_SECONDS_MASK = 0xFFFFFFFFFFL;
    private static final long DATETIME_MICROS_MASK = 0xFFFFFFFFFFFFFFFL;

    private static int encodePacked32TimeSeconds(java.time.LocalTime time) {
        CivilTimeEncoder.checkValidTimeSeconds(time);
        int bitFieldTimeSeconds = 0;
        bitFieldTimeSeconds |= time.getHour() << 12;
        bitFieldTimeSeconds |= time.getMinute() << 6;
        return bitFieldTimeSeconds |= time.getSecond() << 0;
    }

    private static java.time.LocalTime decodePacked32TimeSeconds(int bitFieldTimeSeconds) {
        CivilTimeEncoder.checkValidBitField(bitFieldTimeSeconds, 131071L);
        int hourOfDay = CivilTimeEncoder.getFieldFromBitField(bitFieldTimeSeconds, 126976L, 12);
        int minuteOfHour = CivilTimeEncoder.getFieldFromBitField(bitFieldTimeSeconds, 4032L, 6);
        int secondOfMinute = CivilTimeEncoder.getFieldFromBitField(bitFieldTimeSeconds, 63L, 0);
        try {
            return java.time.LocalTime.of(hourOfDay, minuteOfHour, secondOfMinute);
        }
        catch (DateTimeException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @ObsoleteApi(value="Use encodePacked64TimeMicrosLocalTime(java.time.LocalTime) instead")
    public static long encodePacked64TimeMicros(LocalTime time) {
        return CivilTimeEncoder.encodePacked64TimeMicrosLocalTime(TimeConversionUtils.toJavaTimeLocalTime(time));
    }

    public static long encodePacked64TimeMicrosLocalTime(java.time.LocalTime time) {
        CivilTimeEncoder.checkValidTimeMicros(time);
        return (long)CivilTimeEncoder.encodePacked32TimeSeconds(time) << 20 | (long)time.getNano() / 1000L;
    }

    @ObsoleteApi(value="Use decodePacked64TimeMicrosLocalTime(long) instead")
    public static LocalTime decodePacked64TimeMicros(long bitFieldTimeMicros) {
        return TimeConversionUtils.toThreetenLocalTime(CivilTimeEncoder.decodePacked64TimeMicrosLocalTime(bitFieldTimeMicros));
    }

    public static java.time.LocalTime decodePacked64TimeMicrosLocalTime(long bitFieldTimeMicros) {
        CivilTimeEncoder.checkValidBitField(bitFieldTimeMicros, 0x1FFFFFFFFFL);
        int bitFieldTimeSeconds = (int)(bitFieldTimeMicros >> 20);
        java.time.LocalTime timeSeconds = CivilTimeEncoder.decodePacked32TimeSeconds(bitFieldTimeSeconds);
        int microOfSecond = CivilTimeEncoder.getFieldFromBitField(bitFieldTimeMicros, 1048575L, 0);
        CivilTimeEncoder.checkValidMicroOfSecond(microOfSecond);
        java.time.LocalTime time = timeSeconds.withNano(microOfSecond * 1000);
        CivilTimeEncoder.checkValidTimeMicros(time);
        return time;
    }

    private static long encodePacked64DatetimeSeconds(LocalDateTime dateTime) {
        CivilTimeEncoder.checkValidDateTimeSeconds(dateTime);
        long bitFieldDatetimeSeconds = 0L;
        bitFieldDatetimeSeconds |= (long)dateTime.getYear() << 26;
        bitFieldDatetimeSeconds |= (long)dateTime.getMonthValue() << 22;
        bitFieldDatetimeSeconds |= (long)dateTime.getDayOfMonth() << 17;
        return bitFieldDatetimeSeconds |= (long)CivilTimeEncoder.encodePacked32TimeSeconds(dateTime.toLocalTime());
    }

    private static LocalDateTime decodePacked64DatetimeSeconds(long bitFieldDatetimeSeconds) {
        CivilTimeEncoder.checkValidBitField(bitFieldDatetimeSeconds, 0xFFFFFFFFFFL);
        int bitFieldTimeSeconds = (int)(bitFieldDatetimeSeconds & 0x1FFFFL);
        java.time.LocalTime timeSeconds = CivilTimeEncoder.decodePacked32TimeSeconds(bitFieldTimeSeconds);
        int year = CivilTimeEncoder.getFieldFromBitField(bitFieldDatetimeSeconds, 0xFFFC000000L, 26);
        int monthOfYear = CivilTimeEncoder.getFieldFromBitField(bitFieldDatetimeSeconds, 0x3C00000L, 22);
        int dayOfMonth = CivilTimeEncoder.getFieldFromBitField(bitFieldDatetimeSeconds, 0x3E0000L, 17);
        try {
            LocalDateTime dateTime = LocalDateTime.of(year, monthOfYear, dayOfMonth, timeSeconds.getHour(), timeSeconds.getMinute(), timeSeconds.getSecond());
            CivilTimeEncoder.checkValidDateTimeSeconds(dateTime);
            return dateTime;
        }
        catch (DateTimeException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @ObsoleteApi(value="Use encodePacked64DatetimeMicrosLocalDateTime(java.time.LocalDateTime) instead")
    public static long encodePacked64DatetimeMicros(org.threeten.bp.LocalDateTime dateTime) {
        return CivilTimeEncoder.encodePacked64DatetimeMicrosLocalDateTime(TimeConversionUtils.toJavaTimeLocalDateTime(dateTime));
    }

    public static long encodePacked64DatetimeMicrosLocalDateTime(LocalDateTime dateTime) {
        CivilTimeEncoder.checkValidDateTimeMicros(dateTime);
        return CivilTimeEncoder.encodePacked64DatetimeSeconds(dateTime) << 20 | (long)dateTime.getNano() / 1000L;
    }

    @ObsoleteApi(value="Use decodePacked64DatetimeMicrosLocalDateTime(long) instead")
    public static org.threeten.bp.LocalDateTime decodePacked64DatetimeMicros(long bitFieldDatetimeMicros) {
        return TimeConversionUtils.toThreetenLocalDateTime(CivilTimeEncoder.decodePacked64DatetimeMicrosLocalDateTime(bitFieldDatetimeMicros));
    }

    public static LocalDateTime decodePacked64DatetimeMicrosLocalDateTime(long bitFieldDatetimeMicros) {
        CivilTimeEncoder.checkValidBitField(bitFieldDatetimeMicros, 0xFFFFFFFFFFFFFFFL);
        long bitFieldDatetimeSeconds = bitFieldDatetimeMicros >> 20;
        LocalDateTime dateTimeSeconds = CivilTimeEncoder.decodePacked64DatetimeSeconds(bitFieldDatetimeSeconds);
        int microOfSecond = CivilTimeEncoder.getFieldFromBitField(bitFieldDatetimeMicros, 1048575L, 0);
        CivilTimeEncoder.checkValidMicroOfSecond(microOfSecond);
        LocalDateTime dateTime = dateTimeSeconds.withNano(microOfSecond * 1000);
        CivilTimeEncoder.checkValidDateTimeMicros(dateTime);
        return dateTime;
    }

    private static int getFieldFromBitField(long bitField, long mask, int shift) {
        return (int)((bitField & mask) >> shift);
    }

    private static void checkValidTimeSeconds(java.time.LocalTime time) {
        Preconditions.checkArgument((time.getHour() >= 0 && time.getHour() <= 23 ? 1 : 0) != 0);
        Preconditions.checkArgument((time.getMinute() >= 0 && time.getMinute() <= 59 ? 1 : 0) != 0);
        Preconditions.checkArgument((time.getSecond() >= 0 && time.getSecond() <= 59 ? 1 : 0) != 0);
    }

    private static void checkValidDateTimeSeconds(LocalDateTime dateTime) {
        Preconditions.checkArgument((dateTime.getYear() >= 1 && dateTime.getYear() <= 9999 ? 1 : 0) != 0);
        Preconditions.checkArgument((dateTime.getMonthValue() >= 1 && dateTime.getMonthValue() <= 12 ? 1 : 0) != 0);
        Preconditions.checkArgument((dateTime.getDayOfMonth() >= 1 && dateTime.getDayOfMonth() <= 31 ? 1 : 0) != 0);
        CivilTimeEncoder.checkValidTimeSeconds(dateTime.toLocalTime());
    }

    private static void checkValidTimeMicros(java.time.LocalTime time) {
        CivilTimeEncoder.checkValidTimeSeconds(time);
        Preconditions.checkArgument((boolean)time.equals(time.truncatedTo(ChronoUnit.MICROS)));
    }

    private static void checkValidDateTimeMicros(LocalDateTime dateTime) {
        CivilTimeEncoder.checkValidDateTimeSeconds(dateTime);
        Preconditions.checkArgument((boolean)dateTime.equals(dateTime.truncatedTo(ChronoUnit.MICROS)));
    }

    private static void checkValidMicroOfSecond(int microOfSecond) {
        Preconditions.checkArgument((microOfSecond >= 0 && microOfSecond <= 999999 ? 1 : 0) != 0);
    }

    private static void checkValidBitField(long bitField, long mask) {
        Preconditions.checkArgument(((bitField & (mask ^ 0xFFFFFFFFFFFFFFFFL)) == 0L ? 1 : 0) != 0);
    }

    private CivilTimeEncoder() {
    }
}

